/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal.aop;

import com.plotsquared.google.internal.aop.ClassDefining;
import com.plotsquared.google.internal.aop.GlueException;
import com.plotsquared.google.internal.aop.ImmutableStringTrie;
import com.plotsquared.google.internal.asm.$ClassWriter;
import com.plotsquared.google.internal.asm.$Label;
import com.plotsquared.google.internal.asm.$MethodVisitor;
import com.plotsquared.google.internal.asm.$Type;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.NavigableMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToIntFunction;

abstract class AbstractGlueGenerator {
    protected static final String GENERATED_SOURCE = "<generated>";
    protected static final String TRAMPOLINE_NAME = "GUICE$TRAMPOLINE";
    protected static final String TRAMPOLINE_DESCRIPTOR = "(ILjava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;";
    protected final Class<?> hostClass;
    protected final String hostName;
    protected final String proxyName;
    private static final AtomicInteger COUNTER = new AtomicInteger();

    protected AbstractGlueGenerator(Class<?> clazz, String string) {
        this.hostClass = clazz;
        this.hostName = $Type.getInternalName(clazz);
        this.proxyName = AbstractGlueGenerator.proxyName(this.hostName, string, this.hashCode());
    }

    private static String proxyName(String string, String string2, int n) {
        long l = n & 0xFFFFF | COUNTER.getAndIncrement() << 20;
        String string3 = string + string2 + Long.toHexString(l);
        if (string3.startsWith("java/") && !ClassDefining.hasPackageAccess()) {
            string3 = '$' + string3;
        }
        return string3;
    }

    public final Function<String, BiFunction<Object, Object[], Object>> glue(NavigableMap<String, Executable> navigableMap) {
        MethodHandle methodHandle;
        Object object;
        try {
            object = this.generateGlue(navigableMap.values());
            Class<?> clazz = ClassDefining.define(this.hostClass, object);
            methodHandle = this.lookupInvokerTable(clazz);
        }
        catch (Throwable throwable) {
            throw new GlueException("Problem generating " + this.proxyName, throwable);
        }
        object = ImmutableStringTrie.buildTrie(navigableMap.keySet());
        return AbstractGlueGenerator.bindSignaturesToInvokers((ToIntFunction<String>)object, methodHandle);
    }

    protected abstract byte[] generateGlue(Collection<Executable> var1);

    protected abstract MethodHandle lookupInvokerTable(Class<?> var1);

    private static Function<String, BiFunction<Object, Object[], Object>> bindSignaturesToInvokers(ToIntFunction<String> toIntFunction, MethodHandle methodHandle) {
        if (methodHandle.type().parameterCount() == 1) {
            return string -> {
                try {
                    return methodHandle.invokeExact(toIntFunction.applyAsInt((String)string));
                }
                catch (Throwable throwable) {
                    throw AbstractGlueGenerator.asIfUnchecked(throwable);
                }
            };
        }
        return string -> {
            int n = toIntFunction.applyAsInt((String)string);
            return (object, objectArray) -> {
                try {
                    return methodHandle.invokeExact(n, object, (Object[])objectArray);
                }
                catch (Throwable throwable) {
                    throw AbstractGlueGenerator.asIfUnchecked(throwable);
                }
            };
        };
    }

    private static <E extends Throwable> RuntimeException asIfUnchecked(Throwable throwable) {
        throw throwable;
    }

    protected final void generateTrampoline($ClassWriter $ClassWriter, Collection<Executable> collection) {
        $MethodVisitor $MethodVisitor = $ClassWriter.visitMethod(9, TRAMPOLINE_NAME, TRAMPOLINE_DESCRIPTOR, null, null);
        $MethodVisitor.visitCode();
        $Label[] $LabelArray = new $Label[collection.size()];
        Arrays.setAll($LabelArray, n -> new $Label());
        $Label $Label = new $Label();
        $MethodVisitor.visitVarInsn(21, 0);
        $MethodVisitor.visitTableSwitchInsn(0, $LabelArray.length - 1, $Label, $LabelArray);
        int n2 = 0;
        for (Executable executable : collection) {
            $MethodVisitor.visitLabel($LabelArray[n2++]);
            $MethodVisitor.visitFrame(3, 0, null, 0, null);
            if (executable instanceof Constructor) {
                this.generateConstructorInvoker($MethodVisitor, (Constructor)executable);
            } else {
                this.generateMethodInvoker($MethodVisitor, (Method)executable);
            }
            $MethodVisitor.visitInsn(176);
        }
        $MethodVisitor.visitLabel($Label);
        $MethodVisitor.visitFrame(3, 0, null, 0, null);
        $MethodVisitor.visitInsn(1);
        $MethodVisitor.visitInsn(176);
        $MethodVisitor.visitMaxs(0, 0);
        $MethodVisitor.visitEnd();
    }

    protected abstract void generateConstructorInvoker($MethodVisitor var1, Constructor<?> var2);

    protected abstract void generateMethodInvoker($MethodVisitor var1, Method var2);
}

