/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal.aop;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.plotsquared.google.internal.aop.ClassDefiner;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;

final class ChildClassDefiner
implements ClassDefiner {
    private static final Logger logger = Logger.getLogger(ChildClassDefiner.class.getName());

    ChildClassDefiner() {
    }

    @Override
    public Class<?> define(Class<?> clazz, byte[] byArray) {
        ClassLoader classLoader = clazz.getClassLoader();
        ChildLoader childLoader = classLoader != null ? (ChildLoader)ChildLoaderCacheHolder.CHILD_LOADER_CACHE.get((Object)classLoader) : SystemChildLoaderHolder.SYSTEM_CHILD_LOADER;
        return childLoader.defineInChild(byArray);
    }

    static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
        return AccessController.doPrivileged(privilegedAction);
    }

    static ChildLoader childLoader(ClassLoader classLoader) {
        logger.fine("Creating a child loader for " + classLoader);
        return ChildClassDefiner.doPrivileged(() -> new ChildLoader(classLoader));
    }

    private static final class ChildLoader
    extends ClassLoader {
        ChildLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        ChildLoader() {
        }

        Class<?> defineInChild(byte[] byArray) {
            Class<?> clazz = this.defineClass(null, byArray, 0, byArray.length, null);
            this.resolveClass(clazz);
            return clazz;
        }
    }

    private static class ChildLoaderCacheHolder {
        static final LoadingCache<ClassLoader, ChildLoader> CHILD_LOADER_CACHE = CacheBuilder.newBuilder().weakKeys().weakValues().build(CacheLoader.from(ChildClassDefiner::childLoader));

        private ChildLoaderCacheHolder() {
        }
    }

    private static class SystemChildLoaderHolder {
        static final ChildLoader SYSTEM_CHILD_LOADER = ChildClassDefiner.doPrivileged(ChildLoader::new);

        private SystemChildLoaderHolder() {
        }
    }
}

