/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal.aop;

import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.internal.BytecodeGen;
import com.plotsquared.google.internal.aop.ClassDefining;
import com.plotsquared.google.internal.aop.EnhancerBuilderImpl;
import com.plotsquared.google.internal.aop.FastClass;
import com.plotsquared.google.internal.aop.MethodPartition;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public final class ClassBuilding {
    private static final Method[] OVERRIDABLE_OBJECT_METHODS = ClassBuilding.getOverridableObjectMethods();

    private ClassBuilding() {
    }

    public static String signature(Constructor<?> constructor) {
        return ClassBuilding.signature("<init>", constructor.getParameterTypes());
    }

    public static String signature(Method method) {
        return ClassBuilding.signature(method.getName(), method.getParameterTypes());
    }

    private static String signature(String string, Class<?>[] classArray) {
        StringBuilder stringBuilder = new StringBuilder(string);
        for (Class<?> clazz : classArray) {
            stringBuilder.append(';').append(clazz.getName());
        }
        return stringBuilder.toString();
    }

    public static boolean canEnhance(Executable executable) {
        return ClassBuilding.canAccess(executable, ClassDefining.hasPackageAccess());
    }

    public static BytecodeGen.EnhancerBuilder buildEnhancerBuilder(Class<?> clazz) {
        HashMap hashMap = new HashMap();
        ClassBuilding.visitMethodHierarchy(clazz, method -> {
            if ((method.getModifiers() & 8) == 0) {
                ClassBuilding.partitionMethod(method, hashMap);
            }
        });
        TreeMap<String, Method> treeMap = new TreeMap<String, Method>();
        HashMap<Method, Method> hashMap2 = new HashMap<Method, Method>();
        TypeLiteral<?> typeLiteral = TypeLiteral.get(clazz);
        for (Object v : hashMap.values()) {
            if (v instanceof Method) {
                Method method2 = (Method)v;
                if ((method2.getModifiers() & 0x10) != 0) continue;
                treeMap.put(ClassBuilding.signature(method2), method2);
                continue;
            }
            ((MethodPartition)v).collectEnhanceableMethods(typeLiteral, method -> treeMap.put(ClassBuilding.signature(method), (Method)method), hashMap2);
        }
        return new EnhancerBuilderImpl(clazz, treeMap.values(), hashMap2);
    }

    private static void partitionMethod(Method method, Map<String, Object> map) {
        String string = method.getName() + '/' + method.getParameterCount();
        map.merge(string, method, ClassBuilding::mergeMethods);
    }

    private static Object mergeMethods(Object object, Object object2) {
        Method method = (Method)object2;
        if (object instanceof Method) {
            return new MethodPartition((Method)object, method);
        }
        return ((MethodPartition)object).addCandidate(method);
    }

    private static void visitMethodHierarchy(Class<?> methodArray, Consumer<Method> consumer) {
        Object object;
        ArrayDeque<Class<?>[]> arrayDeque = new ArrayDeque<Class<?>[]>();
        String string = ClassDefining.hasPackageAccess() ? ClassBuilding.packageName(methodArray.getName()) : null;
        for (object = methodArray; object != Object.class && object != null; object = ((Class)object).getSuperclass()) {
            int n = string != null && string.equals(ClassBuilding.packageName(((Class)object).getName())) ? 1 : 0;
            ClassBuilding.visitMembers((Executable[])((Class)object).getDeclaredMethods(), n != 0, consumer);
            ClassBuilding.pushInterfaces(arrayDeque, ((Class)object).getInterfaces());
        }
        for (Method method : OVERRIDABLE_OBJECT_METHODS) {
            consumer.accept(method);
        }
        object = new ArrayList();
        while (!arrayDeque.isEmpty()) {
            for (Class clazz : (Class[])arrayDeque.pop()) {
                if (!ClassBuilding.mergeInterface(object, clazz)) continue;
                ClassBuilding.pushInterfaces(arrayDeque, clazz.getInterfaces());
            }
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            ClassBuilding.visitMembers((Executable[])clazz.getDeclaredMethods(), (boolean)false, consumer);
        }
    }

    private static void pushInterfaces(Deque<Class<?>[]> deque, Class<?>[] classArray) {
        if (classArray.length > 0) {
            deque.push(classArray);
        }
    }

    private static boolean mergeInterface(List<Class<?>> list, Class<?> clazz) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Class<?> clazz2 = list.get(i);
            if (clazz2 == clazz) {
                return false;
            }
            if (!clazz2.isAssignableFrom(clazz)) continue;
            list.add(i, clazz);
            return true;
        }
        return list.add(clazz);
    }

    private static String packageName(String string) {
        return string.substring(0, string.lastIndexOf(46) + 1);
    }

    private static Method[] getOverridableObjectMethods() {
        ArrayList arrayList = new ArrayList();
        ClassBuilding.visitMembers((Executable[])Object.class.getDeclaredMethods(), (boolean)false, (T method) -> {
            if ((method.getModifiers() & 0x18) == 0 && !"finalize".equals(method.getName())) {
                arrayList.add(method);
            }
        });
        return arrayList.toArray(new Method[0]);
    }

    public static boolean canFastInvoke(Executable executable) {
        boolean bl;
        int n = executable.getModifiers() & 3;
        if (ClassDefining.hasPackageAccess()) {
            return n != 2;
        }
        boolean bl2 = bl = n == 1 && ClassBuilding.isPublic(executable.getDeclaringClass());
        if (bl) {
            for (Class<?> clazz : executable.getParameterTypes()) {
                if (ClassBuilding.isPublic(clazz)) continue;
                return false;
            }
        }
        return bl;
    }

    private static boolean isPublic(Class<?> clazz) {
        return (clazz.getModifiers() & 1) != 0;
    }

    public static Function<String, BiFunction<Object, Object[], Object>> buildFastClass(Class<?> clazz) {
        TreeMap<String, Executable> treeMap = new TreeMap<String, Executable>();
        ClassBuilding.visitFastConstructors(clazz, constructor -> treeMap.put(ClassBuilding.signature(constructor), (Executable)constructor));
        ClassBuilding.visitFastMethods(clazz, method -> treeMap.put(ClassBuilding.signature(method), (Executable)method));
        return new FastClass(clazz).glue(treeMap);
    }

    private static void visitFastConstructors(Class<?> clazz, Consumer<Constructor<?>> consumer) {
        if (ClassDefining.hasPackageAccess()) {
            ClassBuilding.visitMembers((Executable[])clazz.getDeclaredConstructors(), (boolean)true, consumer);
        } else {
            for (Constructor<?> constructor : clazz.getConstructors()) {
                consumer.accept(constructor);
            }
        }
    }

    private static void visitFastMethods(Class<?> clazz, Consumer<Method> consumer) {
        if (ClassDefining.hasPackageAccess()) {
            ClassBuilding.visitMembers((Executable[])clazz.getDeclaredMethods(), (boolean)true, consumer);
        } else {
            for (Method method : clazz.getMethods()) {
                if (clazz != method.getDeclaringClass()) continue;
                consumer.accept(method);
            }
        }
    }

    static <T extends Executable> void visitMembers(T[] TArray, boolean bl, Consumer<T> consumer) {
        for (T t : TArray) {
            if (!ClassBuilding.canAccess(t, bl)) continue;
            consumer.accept(t);
        }
    }

    private static boolean canAccess(Executable executable, boolean bl) {
        int n = executable.getModifiers();
        return (n & 5) != 0 || bl && (n & 2) == 0;
    }
}

