/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal.aop;

import com.plotsquared.google.internal.InternalFlags;
import com.plotsquared.google.internal.aop.ChildClassDefiner;
import com.plotsquared.google.internal.aop.ClassDefiner;
import com.plotsquared.google.internal.aop.UnsafeClassDefiner;
import java.util.logging.Logger;

public final class ClassDefining {
    private static final Logger logger = Logger.getLogger(ClassDefining.class.getName());
    private static final String CLASS_DEFINING_UNSUPPORTED = "Unsafe is not accessible and custom classloading is turned OFF.";

    private ClassDefining() {
    }

    public static Class<?> define(Class<?> clazz, byte[] byArray) {
        return ClassDefinerHolder.INSTANCE.define(clazz, byArray);
    }

    public static boolean hasPackageAccess() {
        return ClassDefinerHolder.IS_UNSAFE;
    }

    public static boolean canLoadProxyByName(Class<?> clazz) {
        return !ClassDefinerHolder.IS_UNSAFE || UnsafeClassDefiner.canLoadProxyByName(clazz);
    }

    public static boolean canDowncastToProxy(Class<?> clazz) {
        return !ClassDefinerHolder.IS_UNSAFE || UnsafeClassDefiner.canDowncastToProxy(clazz);
    }

    static ClassDefiner bindClassDefiner() {
        InternalFlags.CustomClassLoadingOption customClassLoadingOption = InternalFlags.getCustomClassLoadingOption();
        if (customClassLoadingOption == InternalFlags.CustomClassLoadingOption.CHILD) {
            return new ChildClassDefiner();
        }
        if (UnsafeClassDefiner.isAccessible()) {
            return new UnsafeClassDefiner();
        }
        if (customClassLoadingOption != InternalFlags.CustomClassLoadingOption.OFF) {
            return new ChildClassDefiner();
        }
        logger.warning(CLASS_DEFINING_UNSUPPORTED);
        return (clazz, byArray) -> {
            throw new UnsupportedOperationException("Cannot define class, Unsafe is not accessible and custom classloading is turned OFF.");
        };
    }

    private static class ClassDefinerHolder {
        static final ClassDefiner INSTANCE = ClassDefining.bindClassDefiner();
        static final boolean IS_UNSAFE = INSTANCE instanceof UnsafeClassDefiner;

        private ClassDefinerHolder() {
        }
    }
}

