/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.plotsquared.google.internal.asm.$AnnotationVisitor;
import com.plotsquared.google.internal.asm.$ClassReader;
import com.plotsquared.google.internal.asm.$ClassVisitor;
import com.plotsquared.google.internal.asm.$FieldVisitor;
import com.plotsquared.google.internal.asm.$Label;
import com.plotsquared.google.internal.asm.$MethodVisitor;
import com.plotsquared.google.internal.asm.$Type;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

final class LineNumbers {
    private static final Logger logger = Logger.getLogger(LineNumbers.class.getName());
    private static volatile boolean alreadyLoggedReadingFailure;
    private static final int ASM_API_LEVEL = 589824;
    private final Class<?> type;
    private final Map<String, Integer> lines = Maps.newHashMap();
    private String source;
    private int firstLine = Integer.MAX_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineNumbers(Class<?> clazz) {
        this.type = clazz;
        if (!clazz.isArray()) {
            InputStream inputStream = null;
            try {
                inputStream = clazz.getResourceAsStream("/" + clazz.getName().replace('.', '/') + ".class");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (inputStream != null) {
                try {
                    new $ClassReader(inputStream).accept(new LineNumberReader(), 4);
                }
                catch (Exception exception) {
                    if (!alreadyLoggedReadingFailure) {
                        alreadyLoggedReadingFailure = true;
                        logger.log(Level.WARNING, "Failed loading line numbers. ASM is probably out of date. Further failures won't be logged.", exception);
                    }
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public String getSource() {
        return this.source;
    }

    public Integer getLineNumber(Member member) {
        Preconditions.checkArgument((this.type == member.getDeclaringClass() ? 1 : 0) != 0, (String)"Member %s belongs to %s, not %s", (Object)member, member.getDeclaringClass(), this.type);
        return this.lines.get(this.memberKey(member));
    }

    public int getFirstLine() {
        return this.firstLine == Integer.MAX_VALUE ? 1 : this.firstLine;
    }

    private String memberKey(Member member) {
        Preconditions.checkNotNull((Object)member, (Object)"member");
        if (member instanceof Field) {
            return member.getName();
        }
        if (member instanceof Method) {
            return member.getName() + $Type.getMethodDescriptor((Method)member);
        }
        if (member instanceof Constructor) {
            StringBuilder stringBuilder = new StringBuilder().append("<init>(");
            for (Class<?> clazz : ((Constructor)member).getParameterTypes()) {
                stringBuilder.append($Type.getDescriptor(clazz));
            }
            return stringBuilder.append(")V").toString();
        }
        throw new IllegalArgumentException("Unsupported implementation class for Member, " + member.getClass());
    }

    private class LineNumberReader
    extends $ClassVisitor {
        private int line;
        private String pendingMethod;
        private String name;

        LineNumberReader() {
            super(589824);
            this.line = -1;
        }

        @Override
        public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
            this.name = string;
        }

        @Override
        public $MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            if ((n & 2) != 0) {
                return null;
            }
            this.pendingMethod = string + string2;
            this.line = -1;
            return new LineNumberMethodVisitor();
        }

        @Override
        public void visitSource(String string, String string2) {
            LineNumbers.this.source = string;
        }

        public void visitLineNumber(int n, $Label $Label) {
            if (n < LineNumbers.this.firstLine) {
                LineNumbers.this.firstLine = n;
            }
            this.line = n;
            if (this.pendingMethod != null) {
                LineNumbers.this.lines.put(this.pendingMethod, n);
                this.pendingMethod = null;
            }
        }

        @Override
        public $FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
            return null;
        }

        @Override
        public $AnnotationVisitor visitAnnotation(String string, boolean bl) {
            return new LineNumberAnnotationVisitor(this);
        }

        public $AnnotationVisitor visitParameterAnnotation(int n, String string, boolean bl) {
            return new LineNumberAnnotationVisitor(this);
        }

        class LineNumberAnnotationVisitor
        extends $AnnotationVisitor {
            LineNumberAnnotationVisitor(LineNumberReader lineNumberReader) {
                super(589824);
            }

            @Override
            public $AnnotationVisitor visitAnnotation(String string, String string2) {
                return this;
            }

            @Override
            public $AnnotationVisitor visitArray(String string) {
                return this;
            }

            public void visitLocalVariable(String string, String string2, String string3, $Label $Label, $Label $Label2, int n) {
            }
        }

        class LineNumberMethodVisitor
        extends $MethodVisitor {
            LineNumberMethodVisitor() {
                super(589824);
            }

            @Override
            public $AnnotationVisitor visitAnnotation(String string, boolean bl) {
                return new LineNumberAnnotationVisitor(LineNumberReader.this);
            }

            @Override
            public $AnnotationVisitor visitAnnotationDefault() {
                return new LineNumberAnnotationVisitor(LineNumberReader.this);
            }

            @Override
            public void visitFieldInsn(int n, String string, String string2, String string3) {
                if (n == 181 && LineNumberReader.this.name.equals(string) && !LineNumbers.this.lines.containsKey(string2) && LineNumberReader.this.line != -1) {
                    LineNumbers.this.lines.put(string2, LineNumberReader.this.line);
                }
            }

            @Override
            public void visitLineNumber(int n, $Label $Label) {
                LineNumberReader.this.visitLineNumber(n, $Label);
            }
        }
    }
}

