/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.plotsquared.google.internal.util.CallerFinder;
import com.plotsquared.google.internal.util.NewThrowableFinder;
import java.util.ArrayList;
import java.util.List;

public final class SourceProvider {
    private static final CallerFinder FINDER = SourceProvider.loadCallerFinder();
    public static final Object UNKNOWN_SOURCE = "[unknown source]";
    private final SourceProvider parent;
    private final ImmutableSet<String> classNamesToSkip;
    public static final SourceProvider DEFAULT_INSTANCE = new SourceProvider((Iterable<String>)ImmutableSet.of((Object)SourceProvider.class.getName(), (Object)NewThrowableFinder.class.getName()));

    private SourceProvider(Iterable<String> iterable) {
        this(null, iterable);
    }

    private SourceProvider(SourceProvider sourceProvider, Iterable<String> iterable) {
        this.parent = sourceProvider;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String string : iterable) {
            if (sourceProvider != null && sourceProvider.shouldBeSkipped(string)) continue;
            builder.add((Object)string);
        }
        this.classNamesToSkip = builder.build();
    }

    public SourceProvider plusSkippedClasses(Class<?> ... classArray) {
        return new SourceProvider(this, SourceProvider.asStrings(classArray));
    }

    private boolean shouldBeSkipped(String string) {
        return this.parent != null && this.parent.shouldBeSkipped(string) || this.classNamesToSkip.contains((Object)string);
    }

    private static List<String> asStrings(Class<?> ... classArray) {
        ArrayList arrayList = Lists.newArrayList();
        for (Class<?> clazz : classArray) {
            arrayList.add(clazz.getName());
        }
        return arrayList;
    }

    public StackTraceElement getCaller() {
        return FINDER.findCaller(this::shouldBeSkipped);
    }

    public Object getFromClassNames(List<String> list) {
        Preconditions.checkNotNull(list, (Object)"The list of module class names cannot be null.");
        for (String string : list) {
            if (this.shouldBeSkipped(string)) continue;
            return new StackTraceElement(string, "configure", null, -1);
        }
        return UNKNOWN_SOURCE;
    }

    private static CallerFinder loadCallerFinder() {
        return new NewThrowableFinder();
    }
}

