/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.plotsquared.google.internal.util.Classes;
import com.plotsquared.google.internal.util.LineNumbers;
import com.plotsquared.google.internal.util.SourceProvider;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class StackTraceElements {
    private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
    private static final InMemoryStackTraceElement[] EMPTY_INMEMORY_STACK_TRACE = new InMemoryStackTraceElement[0];
    static final LoadingCache<Class<?>, LineNumbers> lineNumbersCache = CacheBuilder.newBuilder().weakKeys().softValues().build(new CacheLoader<Class<?>, LineNumbers>(){

        public LineNumbers load(Class<?> clazz) {
            try {
                return new LineNumbers(clazz);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    });
    private static final ConcurrentMap<InMemoryStackTraceElement, InMemoryStackTraceElement> elementCache = new ConcurrentHashMap<InMemoryStackTraceElement, InMemoryStackTraceElement>();
    private static final ConcurrentMap<String, String> stringCache = new ConcurrentHashMap<String, String>();
    private static final String UNKNOWN_SOURCE = "Unknown Source";

    public static Object forMember(Member member) {
        if (member == null) {
            return SourceProvider.UNKNOWN_SOURCE;
        }
        Class<?> clazz = member.getDeclaringClass();
        LineNumbers lineNumbers = (LineNumbers)lineNumbersCache.getUnchecked(clazz);
        String string = lineNumbers.getSource();
        Integer n = lineNumbers.getLineNumber(member);
        int n2 = n == null ? lineNumbers.getFirstLine() : n.intValue();
        Class<? extends Member> clazz2 = Classes.memberType(member);
        String string2 = clazz2 == Constructor.class ? "<init>" : member.getName();
        return new StackTraceElement(clazz.getName(), string2, string, n2);
    }

    public static Object forType(Class<?> clazz) {
        LineNumbers lineNumbers = (LineNumbers)lineNumbersCache.getUnchecked(clazz);
        int n = lineNumbers.getFirstLine();
        String string = lineNumbers.getSource();
        return new StackTraceElement(clazz.getName(), "class", string, n);
    }

    public static void clearCache() {
        elementCache.clear();
        stringCache.clear();
    }

    public static InMemoryStackTraceElement[] convertToInMemoryStackTraceElement(StackTraceElement[] stackTraceElementArray) {
        if (stackTraceElementArray.length == 0) {
            return EMPTY_INMEMORY_STACK_TRACE;
        }
        InMemoryStackTraceElement[] inMemoryStackTraceElementArray = new InMemoryStackTraceElement[stackTraceElementArray.length];
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            inMemoryStackTraceElementArray[i] = StackTraceElements.weakIntern(new InMemoryStackTraceElement(stackTraceElementArray[i]));
        }
        return inMemoryStackTraceElementArray;
    }

    public static StackTraceElement[] convertToStackTraceElement(InMemoryStackTraceElement[] inMemoryStackTraceElementArray) {
        if (inMemoryStackTraceElementArray.length == 0) {
            return EMPTY_STACK_TRACE;
        }
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[inMemoryStackTraceElementArray.length];
        for (int i = 0; i < inMemoryStackTraceElementArray.length; ++i) {
            String string = inMemoryStackTraceElementArray[i].getClassName();
            String string2 = inMemoryStackTraceElementArray[i].getMethodName();
            int n = inMemoryStackTraceElementArray[i].getLineNumber();
            stackTraceElementArray[i] = new StackTraceElement(string, string2, UNKNOWN_SOURCE, n);
        }
        return stackTraceElementArray;
    }

    private static InMemoryStackTraceElement weakIntern(InMemoryStackTraceElement inMemoryStackTraceElement) {
        InMemoryStackTraceElement inMemoryStackTraceElement2 = (InMemoryStackTraceElement)elementCache.get(inMemoryStackTraceElement);
        if (inMemoryStackTraceElement2 != null) {
            return inMemoryStackTraceElement2;
        }
        inMemoryStackTraceElement = new InMemoryStackTraceElement(StackTraceElements.weakIntern(inMemoryStackTraceElement.getClassName()), StackTraceElements.weakIntern(inMemoryStackTraceElement.getMethodName()), inMemoryStackTraceElement.getLineNumber());
        elementCache.put(inMemoryStackTraceElement, inMemoryStackTraceElement);
        return inMemoryStackTraceElement;
    }

    private static String weakIntern(String string) {
        String string2 = (String)stringCache.get(string);
        if (string2 != null) {
            return string2;
        }
        stringCache.put(string, string);
        return string;
    }

    private StackTraceElements() {
    }

    public static class InMemoryStackTraceElement {
        private final String declaringClass;
        private final String methodName;
        private final int lineNumber;

        InMemoryStackTraceElement(StackTraceElement stackTraceElement) {
            this(stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getLineNumber());
        }

        InMemoryStackTraceElement(String string, String string2, int n) {
            this.declaringClass = string;
            this.methodName = string2;
            this.lineNumber = n;
        }

        String getClassName() {
            return this.declaringClass;
        }

        String getMethodName() {
            return this.methodName;
        }

        int getLineNumber() {
            return this.lineNumber;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof InMemoryStackTraceElement)) {
                return false;
            }
            InMemoryStackTraceElement inMemoryStackTraceElement = (InMemoryStackTraceElement)object;
            return inMemoryStackTraceElement.declaringClass.equals(this.declaringClass) && inMemoryStackTraceElement.lineNumber == this.lineNumber && this.methodName.equals(inMemoryStackTraceElement.methodName);
        }

        public int hashCode() {
            int n = 31 * this.declaringClass.hashCode() + this.methodName.hashCode();
            n = 31 * n + this.lineNumber;
            return n;
        }

        public String toString() {
            return this.declaringClass + "." + this.methodName + "(" + this.lineNumber + ")";
        }
    }
}

