/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.multibindings;

import com.plotsquared.google.Binder;
import com.plotsquared.google.Key;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.binder.LinkedBindingBuilder;
import com.plotsquared.google.internal.RealMultibinder;
import java.lang.annotation.Annotation;

public class Multibinder<T> {
    private final RealMultibinder<T> delegate;

    public static <T> Multibinder<T> newSetBinder(Binder binder, TypeLiteral<T> typeLiteral) {
        return Multibinder.newSetBinder(binder, Key.get(typeLiteral));
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, Class<T> clazz) {
        return Multibinder.newSetBinder(binder, Key.get(clazz));
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, TypeLiteral<T> typeLiteral, Annotation annotation) {
        return Multibinder.newSetBinder(binder, Key.get(typeLiteral, annotation));
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, Class<T> clazz, Annotation annotation) {
        return Multibinder.newSetBinder(binder, Key.get(clazz, annotation));
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, TypeLiteral<T> typeLiteral, Class<? extends Annotation> clazz) {
        return Multibinder.newSetBinder(binder, Key.get(typeLiteral, clazz));
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, Key<T> key) {
        return new Multibinder<T>(RealMultibinder.newRealSetBinder(binder, key));
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, Class<T> clazz, Class<? extends Annotation> clazz2) {
        return Multibinder.newSetBinder(binder, Key.get(clazz, clazz2));
    }

    private Multibinder(RealMultibinder<T> realMultibinder) {
        this.delegate = realMultibinder;
    }

    public Multibinder<T> permitDuplicates() {
        this.delegate.permitDuplicates();
        return this;
    }

    public LinkedBindingBuilder<T> addBinding() {
        return this.delegate.addBinding();
    }

    public boolean equals(Object object) {
        if (object instanceof Multibinder) {
            return this.delegate.equals(((Multibinder)object).delegate);
        }
        return false;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

