/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.spi;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.plotsquared.google.Key;
import com.plotsquared.google.internal.MoreTypes;
import com.plotsquared.google.spi.InjectionPoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public final class Dependency<T> {
    private final InjectionPoint injectionPoint;
    private final Key<T> key;
    private final boolean nullable;
    private final int parameterIndex;

    Dependency(InjectionPoint injectionPoint, Key<T> key, boolean bl, int n) {
        this.injectionPoint = injectionPoint;
        this.key = (Key)Preconditions.checkNotNull(key, (Object)"key");
        this.nullable = bl;
        this.parameterIndex = n;
    }

    public static <T> Dependency<T> get(Key<T> key) {
        return new Dependency<T>(null, MoreTypes.canonicalizeKey(key), true, -1);
    }

    public static Set<Dependency<?>> forInjectionPoints(Set<InjectionPoint> set) {
        ArrayList arrayList = Lists.newArrayList();
        for (InjectionPoint injectionPoint : set) {
            arrayList.addAll(injectionPoint.getDependencies());
        }
        return ImmutableSet.copyOf((Collection)arrayList);
    }

    public Key<T> getKey() {
        return this.key;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.injectionPoint, this.parameterIndex, this.key});
    }

    public boolean equals(Object object) {
        if (object instanceof Dependency) {
            Dependency dependency = (Dependency)object;
            return Objects.equal((Object)this.injectionPoint, (Object)dependency.injectionPoint) && this.parameterIndex == dependency.parameterIndex && this.key.equals(dependency.key);
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.key);
        if (this.injectionPoint != null) {
            stringBuilder.append('@').append(this.injectionPoint);
            if (this.parameterIndex != -1) {
                stringBuilder.append('[').append(this.parameterIndex).append(']');
            }
        }
        return stringBuilder.toString();
    }
}

