/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.spi;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.plotsquared.core.aopalliance.intercept.MethodInterceptor;
import com.plotsquared.google.AbstractModule;
import com.plotsquared.google.Binder;
import com.plotsquared.google.Binding;
import com.plotsquared.google.Key;
import com.plotsquared.google.MembersInjector;
import com.plotsquared.google.Module;
import com.plotsquared.google.PrivateBinder;
import com.plotsquared.google.PrivateModule;
import com.plotsquared.google.Provider;
import com.plotsquared.google.Scope;
import com.plotsquared.google.Stage;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.binder.AnnotatedBindingBuilder;
import com.plotsquared.google.binder.AnnotatedConstantBindingBuilder;
import com.plotsquared.google.binder.AnnotatedElementBuilder;
import com.plotsquared.google.internal.AbstractBindingBuilder;
import com.plotsquared.google.internal.BindingBuilder;
import com.plotsquared.google.internal.ConstantBindingBuilderImpl;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.ExposureBuilder;
import com.plotsquared.google.internal.GuiceInternal;
import com.plotsquared.google.internal.InternalClassesToSkipSources;
import com.plotsquared.google.internal.InternalFlags;
import com.plotsquared.google.internal.MoreTypes;
import com.plotsquared.google.internal.PrivateElementsImpl;
import com.plotsquared.google.internal.ProviderMethod;
import com.plotsquared.google.internal.ProviderMethodsModule;
import com.plotsquared.google.internal.util.SourceProvider;
import com.plotsquared.google.internal.util.StackTraceElements;
import com.plotsquared.google.matcher.Matcher;
import com.plotsquared.google.multibindings.MapBinder;
import com.plotsquared.google.multibindings.Multibinder;
import com.plotsquared.google.multibindings.OptionalBinder;
import com.plotsquared.google.spi.BindingSourceRestriction;
import com.plotsquared.google.spi.BindingTargetVisitor;
import com.plotsquared.google.spi.DefaultBindingTargetVisitor;
import com.plotsquared.google.spi.Dependency;
import com.plotsquared.google.spi.DisableCircularProxiesOption;
import com.plotsquared.google.spi.Element;
import com.plotsquared.google.spi.ElementSource;
import com.plotsquared.google.spi.InjectionRequest;
import com.plotsquared.google.spi.InstanceBinding;
import com.plotsquared.google.spi.InterceptorBinding;
import com.plotsquared.google.spi.MembersInjectorLookup;
import com.plotsquared.google.spi.Message;
import com.plotsquared.google.spi.ModuleAnnotatedMethodScanner;
import com.plotsquared.google.spi.ModuleAnnotatedMethodScannerBinding;
import com.plotsquared.google.spi.ModuleSource;
import com.plotsquared.google.spi.ProviderLookup;
import com.plotsquared.google.spi.ProvisionListener;
import com.plotsquared.google.spi.ProvisionListenerBinding;
import com.plotsquared.google.spi.RequireAtInjectOnConstructorsOption;
import com.plotsquared.google.spi.RequireExactBindingAnnotationsOption;
import com.plotsquared.google.spi.RequireExplicitBindingsOption;
import com.plotsquared.google.spi.ScopeBinding;
import com.plotsquared.google.spi.StaticInjectionRequest;
import com.plotsquared.google.spi.TypeConverter;
import com.plotsquared.google.spi.TypeConverterBinding;
import com.plotsquared.google.spi.TypeListener;
import com.plotsquared.google.spi.TypeListenerBinding;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Elements {
    private static final BindingTargetVisitor<Object, Object> GET_INSTANCE_VISITOR = new DefaultBindingTargetVisitor<Object, Object>(){

        @Override
        public Object visit(InstanceBinding<?> instanceBinding) {
            return instanceBinding.getInstance();
        }

        @Override
        protected Object visitOther(Binding<?> binding) {
            throw new IllegalArgumentException();
        }
    };

    public static List<Element> getElements(Module ... moduleArray) {
        return Elements.getElements(Stage.DEVELOPMENT, Arrays.asList(moduleArray));
    }

    public static List<Element> getElements(Stage stage, Module ... moduleArray) {
        return Elements.getElements(stage, Arrays.asList(moduleArray));
    }

    public static List<Element> getElements(Iterable<? extends Module> iterable) {
        return Elements.getElements(Stage.DEVELOPMENT, iterable);
    }

    public static List<Element> getElements(Stage stage, Iterable<? extends Module> iterable) {
        RecordingBinder recordingBinder = new RecordingBinder(stage);
        for (Module object : iterable) {
            recordingBinder.install(object);
        }
        recordingBinder.scanForAnnotatedMethods();
        for (RecordingBinder recordingBinder2 : recordingBinder.privateBindersForScanning) {
            recordingBinder2.scanForAnnotatedMethods();
        }
        recordingBinder.permitMapConstruction.finish();
        StackTraceElements.clearCache();
        return Collections.unmodifiableList(recordingBinder.elements);
    }

    public static Binder withTrustedSource(GuiceInternal guiceInternal, Binder binder, Object object) {
        Preconditions.checkNotNull((Object)guiceInternal);
        if (binder instanceof RecordingBinder) {
            return ((RecordingBinder)binder).withTrustedSource(object);
        }
        return binder.withSource(object);
    }

    public static Module getModule(Iterable<? extends Element> iterable) {
        return new ElementsAsModule(iterable);
    }

    static <T> BindingTargetVisitor<T, T> getInstanceVisitor() {
        return GET_INSTANCE_VISITOR;
    }

    private static class RecordingBinder
    implements Binder,
    PrivateBinder {
        private static final ImmutableSet<Class<?>> CLASSES_TO_SKIP = ImmutableSet.builder().add((Object[])new Class[]{Elements.class, RecordingBinder.class, AbstractModule.class, ConstantBindingBuilderImpl.class, AbstractBindingBuilder.class, BindingBuilder.class, MapBinder.class, Multibinder.class, OptionalBinder.class}).addAll(InternalClassesToSkipSources.classesToSkipSources()).build();
        private static final SourceProvider DEFAULT_SOURCE_PROVIDER = SourceProvider.DEFAULT_INSTANCE.plusSkippedClasses((Class[])CLASSES_TO_SKIP.toArray((Object[])new Class[0]));
        private final Stage stage;
        private final Map<Module, ModuleInfo> modules;
        private final List<Element> elements;
        private final Object source;
        private final SourceProvider sourceProvider;
        private final Set<ModuleAnnotatedMethodScanner> scanners;
        private final RecordingBinder parent;
        private final PrivateElementsImpl privateElements;
        private final List<RecordingBinder> privateBindersForScanning;
        private final BindingSourceRestriction.PermitMapConstruction permitMapConstruction;
        private ModuleSource moduleSource = null;
        private ModuleAnnotatedMethodScanner scannerSource = null;
        private ModuleAnnotatedMethodScanner currentScanner = null;
        private boolean trustedSource = false;

        private RecordingBinder(Stage stage) {
            this.stage = stage;
            this.modules = Maps.newLinkedHashMap();
            this.scanners = Sets.newLinkedHashSet();
            this.elements = Lists.newArrayList();
            this.source = null;
            this.sourceProvider = DEFAULT_SOURCE_PROVIDER;
            this.parent = null;
            this.privateElements = null;
            this.privateBindersForScanning = Lists.newArrayList();
            this.permitMapConstruction = new BindingSourceRestriction.PermitMapConstruction();
        }

        private RecordingBinder(RecordingBinder recordingBinder, Object object, SourceProvider sourceProvider, boolean bl) {
            Preconditions.checkArgument((boolean)(object == null ^ sourceProvider == null));
            this.stage = recordingBinder.stage;
            this.modules = recordingBinder.modules;
            this.elements = recordingBinder.elements;
            this.scanners = recordingBinder.scanners;
            this.currentScanner = recordingBinder.currentScanner;
            this.source = object;
            this.trustedSource = bl;
            this.moduleSource = recordingBinder.moduleSource;
            this.sourceProvider = sourceProvider;
            this.parent = recordingBinder.parent;
            this.privateElements = recordingBinder.privateElements;
            this.privateBindersForScanning = recordingBinder.privateBindersForScanning;
            this.permitMapConstruction = recordingBinder.permitMapConstruction;
            this.scannerSource = recordingBinder.scannerSource;
        }

        private RecordingBinder(RecordingBinder recordingBinder, PrivateElementsImpl privateElementsImpl) {
            this.stage = recordingBinder.stage;
            this.modules = Maps.newLinkedHashMap();
            this.scanners = Sets.newLinkedHashSet();
            this.currentScanner = recordingBinder.currentScanner;
            this.elements = privateElementsImpl.getElementsMutable();
            this.source = recordingBinder.source;
            this.moduleSource = recordingBinder.moduleSource;
            this.sourceProvider = recordingBinder.sourceProvider;
            this.parent = recordingBinder;
            this.privateElements = privateElementsImpl;
            this.privateBindersForScanning = recordingBinder.privateBindersForScanning;
            this.permitMapConstruction = recordingBinder.permitMapConstruction;
            this.scannerSource = recordingBinder.scannerSource;
        }

        @Override
        public void bindInterceptor(Matcher<? super Class<?>> matcher, Matcher<? super Method> matcher2, MethodInterceptor ... methodInterceptorArray) {
            this.elements.add(new InterceptorBinding(this.getElementSource(), matcher, matcher2, methodInterceptorArray));
        }

        @Override
        public void bindScope(Class<? extends Annotation> clazz, Scope scope) {
            this.elements.add(new ScopeBinding(this.getElementSource(), clazz, scope));
        }

        @Override
        public void requestInjection(Object object) {
            Preconditions.checkNotNull((Object)object, (Object)"instance");
            this.requestInjection(TypeLiteral.get(object.getClass()), object);
        }

        @Override
        public <T> void requestInjection(TypeLiteral<T> typeLiteral, T t) {
            Preconditions.checkNotNull(t, (Object)"instance");
            this.elements.add(new InjectionRequest<T>(this.getElementSource(), MoreTypes.canonicalizeForKey(typeLiteral), t));
        }

        @Override
        public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> typeLiteral) {
            MembersInjectorLookup<T> membersInjectorLookup = new MembersInjectorLookup<T>(this.getElementSource(), MoreTypes.canonicalizeForKey(typeLiteral));
            this.elements.add(membersInjectorLookup);
            return membersInjectorLookup.getMembersInjector();
        }

        @Override
        public <T> MembersInjector<T> getMembersInjector(Class<T> clazz) {
            return this.getMembersInjector(TypeLiteral.get(clazz));
        }

        @Override
        public void bindListener(Matcher<? super TypeLiteral<?>> matcher, TypeListener typeListener) {
            this.elements.add(new TypeListenerBinding(this.getElementSource(), typeListener, matcher));
        }

        @Override
        public void bindListener(Matcher<? super Binding<?>> matcher, ProvisionListener ... provisionListenerArray) {
            this.elements.add(new ProvisionListenerBinding(this.getElementSource(), matcher, provisionListenerArray));
        }

        @Override
        public void requestStaticInjection(Class<?> ... classArray) {
            for (Class<?> clazz : classArray) {
                this.elements.add(new StaticInjectionRequest(this.getElementSource(), clazz));
            }
        }

        void scanForAnnotatedMethods() {
            Iterable<ModuleAnnotatedMethodScanner> iterable = this.getAllScanners();
            for (Map.Entry entry : Maps.newLinkedHashMap(this.modules).entrySet()) {
                Module module = (Module)entry.getKey();
                ModuleInfo moduleInfo = (ModuleInfo)entry.getValue();
                if (moduleInfo.skipScanning) continue;
                Iterator<ModuleAnnotatedMethodScanner> iterator = iterable.iterator();
                while (iterator.hasNext()) {
                    ModuleAnnotatedMethodScanner moduleAnnotatedMethodScanner;
                    this.currentScanner = moduleAnnotatedMethodScanner = iterator.next();
                    this.moduleSource = ((ModuleInfo)entry.getValue()).moduleSource;
                    this.permitMapConstruction.restoreCurrentModulePermits(this.moduleSource);
                    try {
                        this.install(ProviderMethodsModule.forModule(module, moduleAnnotatedMethodScanner));
                    }
                    catch (RuntimeException runtimeException) {
                        Collection<Message> collection = Errors.getMessagesFromThrowable(runtimeException);
                        if (!collection.isEmpty()) {
                            this.elements.addAll(collection);
                            continue;
                        }
                        this.addError(runtimeException);
                    }
                }
            }
            this.moduleSource = null;
        }

        @Override
        public void install(Module module) {
            if (this.modules.containsKey(module)) {
                return;
            }
            boolean bl = false;
            Class<?> clazz = null;
            RecordingBinder recordingBinder = this;
            if (module instanceof ProviderMethodsModule) {
                ProviderMethodsModule providerMethodsModule = (ProviderMethodsModule)module;
                if (!providerMethodsModule.isScanningBuiltInProvidesMethods()) {
                    this.scannerSource = providerMethodsModule.getScanner();
                    bl = true;
                }
                Class<?> clazz2 = providerMethodsModule.getDelegateModuleClass();
                if (this.moduleSource == null || !this.moduleSource.getModuleClassName().equals(clazz2.getName())) {
                    clazz = clazz2;
                }
            } else {
                if (this.moduleScanning()) {
                    this.forbidNestedScannerMethods(module);
                }
                clazz = module.getClass();
            }
            if (clazz != null) {
                this.moduleSource = this.getModuleSource(clazz);
                this.permitMapConstruction.pushModule(clazz, this.moduleSource);
            }
            boolean bl2 = false;
            if (module instanceof PrivateModule) {
                recordingBinder = (RecordingBinder)recordingBinder.newPrivateBinder();
                recordingBinder.modules.put(module, new ModuleInfo(this.moduleSource, false));
                bl2 = true;
            }
            this.modules.put(module, new ModuleInfo(this.moduleSource, bl2));
            try {
                module.configure(recordingBinder);
            }
            catch (RuntimeException runtimeException) {
                Collection<Message> collection = Errors.getMessagesFromThrowable(runtimeException);
                if (!collection.isEmpty()) {
                    this.elements.addAll(collection);
                }
                this.addError(runtimeException);
            }
            recordingBinder.install(ProviderMethodsModule.forModule(module));
            if (clazz != null) {
                this.moduleSource = this.moduleSource.getParent();
                this.permitMapConstruction.popModule();
            }
            if (bl) {
                this.scannerSource = null;
            }
        }

        private void forbidNestedScannerMethods(Module module) {
            for (ModuleAnnotatedMethodScanner moduleAnnotatedMethodScanner : this.getAllScanners()) {
                ProviderMethodsModule providerMethodsModule = (ProviderMethodsModule)ProviderMethodsModule.forModule(module, moduleAnnotatedMethodScanner);
                for (ProviderMethod<?> providerMethod : providerMethodsModule.getProviderMethods(this)) {
                    this.addError("Scanner %s is installing a module with %s method. Installing modules with custom provides methods from a ModuleAnnotatedMethodScanner is not supported.", this.currentScanner, providerMethod.getAnnotation().annotationType().getCanonicalName());
                }
            }
        }

        private Iterable<ModuleAnnotatedMethodScanner> getAllScanners() {
            if (this.privateElements == null) {
                return this.scanners;
            }
            return Iterables.concat(this.scanners, this.parent.getAllScanners());
        }

        @Override
        public Stage currentStage() {
            return this.stage;
        }

        @Override
        public void addError(String string, Object ... objectArray) {
            this.elements.add(new Message(this.getElementSource(), Errors.format(string, objectArray)));
        }

        @Override
        public void addError(Throwable throwable) {
            String string = "An exception was caught and reported. Message: " + throwable.getMessage();
            this.elements.add(new Message((List<Object>)ImmutableList.of((Object)this.getElementSource()), string, throwable));
        }

        @Override
        public void addError(Message message) {
            this.elements.add(message);
        }

        public <T> AnnotatedBindingBuilder<T> bind(Key<T> key) {
            BindingBuilder<T> bindingBuilder = new BindingBuilder<T>(this, this.elements, this.getElementSource(), MoreTypes.canonicalizeKey(key));
            return bindingBuilder;
        }

        @Override
        public <T> AnnotatedBindingBuilder<T> bind(TypeLiteral<T> typeLiteral) {
            return this.bind((Key)Key.get(typeLiteral));
        }

        @Override
        public <T> AnnotatedBindingBuilder<T> bind(Class<T> clazz) {
            return this.bind((Key)Key.get(clazz));
        }

        @Override
        public AnnotatedConstantBindingBuilder bindConstant() {
            return new ConstantBindingBuilderImpl(this, this.elements, this.getElementSource());
        }

        @Override
        public <T> Provider<T> getProvider(Key<T> key) {
            return this.getProvider(Dependency.get(key));
        }

        @Override
        public <T> Provider<T> getProvider(Dependency<T> dependency) {
            ProviderLookup<T> providerLookup = new ProviderLookup<T>((Object)this.getElementSource(), dependency);
            this.elements.add(providerLookup);
            return providerLookup.getProvider();
        }

        @Override
        public <T> Provider<T> getProvider(Class<T> clazz) {
            return this.getProvider(Key.get(clazz));
        }

        @Override
        public void convertToTypes(Matcher<? super TypeLiteral<?>> matcher, TypeConverter typeConverter) {
            this.elements.add(new TypeConverterBinding(this.getElementSource(), matcher, typeConverter));
        }

        @Override
        public RecordingBinder withSource(Object object) {
            return object == this.source ? this : new RecordingBinder(this, object, null, false);
        }

        public RecordingBinder withTrustedSource(Object object) {
            return object == this.source ? this : new RecordingBinder(this, object, null, true);
        }

        @Override
        public RecordingBinder skipSources(Class<?> ... classArray) {
            if (this.source != null) {
                return this;
            }
            SourceProvider sourceProvider = this.sourceProvider.plusSkippedClasses(classArray);
            return new RecordingBinder(this, null, sourceProvider, false);
        }

        @Override
        public PrivateBinder newPrivateBinder() {
            PrivateElementsImpl privateElementsImpl = new PrivateElementsImpl(this.getElementSource());
            RecordingBinder recordingBinder = new RecordingBinder(this, privateElementsImpl);
            this.elements.add(privateElementsImpl);
            if (!this.moduleScanning()) {
                this.privateBindersForScanning.add(recordingBinder);
            }
            return recordingBinder;
        }

        @Override
        public void disableCircularProxies() {
            this.elements.add(new DisableCircularProxiesOption(this.getElementSource()));
        }

        @Override
        public void requireExplicitBindings() {
            this.elements.add(new RequireExplicitBindingsOption(this.getElementSource()));
        }

        @Override
        public void requireAtInjectOnConstructors() {
            this.elements.add(new RequireAtInjectOnConstructorsOption(this.getElementSource()));
        }

        @Override
        public void requireExactBindingAnnotations() {
            this.elements.add(new RequireExactBindingAnnotationsOption(this.getElementSource()));
        }

        @Override
        public void scanModulesForAnnotatedMethods(ModuleAnnotatedMethodScanner moduleAnnotatedMethodScanner) {
            if (this.moduleScanning()) {
                this.addError("Attempting to register ModuleAnnotatedMethodScanner %s from scanner %s. Scanners are not allowed to register other scanners.", this.currentScanner, moduleAnnotatedMethodScanner);
                return;
            }
            this.scanners.add(moduleAnnotatedMethodScanner);
            this.elements.add(new ModuleAnnotatedMethodScannerBinding(this.getElementSource(), moduleAnnotatedMethodScanner));
        }

        @Override
        public void expose(Key<?> key) {
            this.exposeInternal(key);
        }

        @Override
        public AnnotatedElementBuilder expose(Class<?> clazz) {
            return this.exposeInternal(Key.get(clazz));
        }

        @Override
        public AnnotatedElementBuilder expose(TypeLiteral<?> typeLiteral) {
            return this.exposeInternal(Key.get(typeLiteral));
        }

        private <T> AnnotatedElementBuilder exposeInternal(Key<T> key) {
            if (this.privateElements == null) {
                this.addError("Cannot expose %s on a standard binder. Exposed bindings are only applicable to private binders.", key);
                return new AnnotatedElementBuilder(this){

                    @Override
                    public void annotatedWith(Class<? extends Annotation> clazz) {
                    }

                    @Override
                    public void annotatedWith(Annotation annotation) {
                    }
                };
            }
            ExposureBuilder<T> exposureBuilder = new ExposureBuilder<T>(this, this.getElementSource(), MoreTypes.canonicalizeKey(key));
            this.privateElements.addExposureBuilder(exposureBuilder);
            return exposureBuilder;
        }

        private ModuleSource getModuleSource(Class<?> clazz) {
            if (this.moduleSource == null) {
                return new ModuleSource(clazz, this.permitMapConstruction.getPermitMap());
            }
            return this.moduleSource.createChild(clazz);
        }

        private ElementSource getElementSource() {
            ElementSource elementSource = null;
            Object object = this.source;
            if (object instanceof ElementSource) {
                elementSource = (ElementSource)object;
                object = elementSource.getDeclaringSource();
            }
            if (object == null) {
                StackTraceElement stackTraceElement;
                InternalFlags.IncludeStackTraceOption includeStackTraceOption = InternalFlags.getIncludeStackTraceOption();
                object = includeStackTraceOption == InternalFlags.IncludeStackTraceOption.ONLY_FOR_DECLARING_SOURCE ? ((stackTraceElement = this.sourceProvider.getCaller()).getClassName().equals("com.plotsquared.google.internal.InjectorShell$Builder") && stackTraceElement.getMethodName().equals("build") ? SourceProvider.UNKNOWN_SOURCE : stackTraceElement) : this.sourceProvider.getFromClassNames(this.moduleSource.getModuleClassNames());
            }
            return new ElementSource(elementSource, this.trustedSource, object, this.moduleSource, this.scannerSource);
        }

        private boolean moduleScanning() {
            return this.currentScanner != null;
        }

        public String toString() {
            return "Binder";
        }
    }

    private static class ModuleInfo {
        private final ModuleSource moduleSource;
        private final boolean skipScanning;

        private ModuleInfo(ModuleSource moduleSource, boolean bl) {
            this.moduleSource = moduleSource;
            this.skipScanning = bl;
        }
    }

    private static class ElementsAsModule
    implements Module {
        private final Iterable<? extends Element> elements;

        ElementsAsModule(Iterable<? extends Element> iterable) {
            this.elements = iterable;
        }

        @Override
        public void configure(Binder binder) {
            for (Element element : this.elements) {
                element.applyTo(binder);
            }
        }
    }
}

