/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.spi;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.plotsquared.google.internal.Messages;
import java.io.Serializable;
import java.util.Formatter;
import java.util.List;
import java.util.Optional;

public abstract class ErrorDetail<SelfT extends ErrorDetail<SelfT>>
implements Serializable {
    private final String message;
    private final ImmutableList<Object> sources;
    private final Throwable cause;

    protected ErrorDetail(String string, List<Object> list, Throwable throwable) {
        this.message = string;
        this.sources = ImmutableList.copyOf(list);
        this.cause = throwable;
    }

    public boolean isMergeable(ErrorDetail<?> errorDetail) {
        return false;
    }

    public final void format(int n, List<ErrorDetail<?>> list, Formatter formatter) {
        String string2 = this.getErrorIdentifier().map(string -> "[" + Messages.redBold(string) + "]: ").orElse("");
        formatter.format("%s) %s%s\n", n, string2, this.getMessage());
        this.formatDetail(list, formatter);
        Optional<String> optional = this.getLearnMoreLink();
        if (optional.isPresent()) {
            formatter.format("\n%s\n", Messages.bold("Learn more:"));
            formatter.format("  %s\n", Messages.underline(optional.get()));
        }
    }

    protected abstract void formatDetail(List<ErrorDetail<?>> var1, Formatter var2);

    protected Optional<String> getLearnMoreLink() {
        return Optional.empty();
    }

    protected Optional<String> getErrorIdentifier() {
        return Optional.empty();
    }

    public String getMessage() {
        return this.message;
    }

    public List<Object> getSources() {
        return this.sources;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.message, this.cause, this.sources});
    }

    public boolean equals(Object object) {
        if (!(object instanceof ErrorDetail)) {
            return false;
        }
        ErrorDetail errorDetail = (ErrorDetail)object;
        return this.message.equals(errorDetail.message) && Objects.equal((Object)this.cause, (Object)errorDetail.cause) && this.sources.equals(errorDetail.sources);
    }

    public abstract SelfT withSources(List<Object> var1);
}

