/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.spi;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.plotsquared.core.annotation.Nullable;
import com.plotsquared.google.spi.BindingSourceRestriction;
import java.util.List;

final class ModuleSource {
    private final String moduleClassName;
    private final ModuleSource parent;
    private final BindingSourceRestriction.PermitMap permitMap;

    ModuleSource(Class<?> clazz, BindingSourceRestriction.PermitMap permitMap) {
        this(null, clazz, permitMap);
    }

    private ModuleSource(@Nullable ModuleSource moduleSource, Class<?> clazz, BindingSourceRestriction.PermitMap permitMap) {
        Preconditions.checkNotNull(clazz, (Object)"module cannot be null.");
        this.parent = moduleSource;
        this.moduleClassName = clazz.getName();
        this.permitMap = permitMap;
    }

    String getModuleClassName() {
        return this.moduleClassName;
    }

    ModuleSource createChild(Class<?> clazz) {
        return new ModuleSource(this, clazz, this.permitMap);
    }

    ModuleSource getParent() {
        return this.parent;
    }

    List<String> getModuleClassNames() {
        ImmutableList.Builder builder = ImmutableList.builder();
        ModuleSource moduleSource = this;
        while (moduleSource != null) {
            String string = moduleSource.moduleClassName;
            builder.add((Object)string);
            moduleSource = moduleSource.parent;
        }
        return builder.build();
    }

    int size() {
        if (this.parent == null) {
            return 1;
        }
        return this.parent.size() + 1;
    }

    BindingSourceRestriction.PermitMap getPermitMap() {
        return this.permitMap;
    }
}

