/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.spi;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.plotsquared.google.Binder;
import com.plotsquared.google.Scope;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.spi.Element;
import com.plotsquared.google.spi.ElementVisitor;
import java.lang.annotation.Annotation;

public final class ScopeBinding
implements Element {
    private final Object source;
    private final Class<? extends Annotation> annotationType;
    private final Scope scope;

    ScopeBinding(Object object, Class<? extends Annotation> clazz, Scope scope) {
        this.source = Preconditions.checkNotNull((Object)object, (Object)"source");
        this.annotationType = (Class)Preconditions.checkNotNull(clazz, (Object)"annotationType");
        this.scope = (Scope)Preconditions.checkNotNull((Object)scope, (Object)"scope");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    public Scope getScope() {
        return this.scope;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> elementVisitor) {
        return elementVisitor.visit(this);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).bindScope(this.annotationType, this.scope);
    }

    public String toString() {
        return MoreObjects.toStringHelper(ScopeBinding.class).add("annotationType", this.annotationType).add("scope", (Object)this.scope).add("source", Errors.convert(this.source)).toString();
    }
}

