/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.spi;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.plotsquared.google.Binder;
import com.plotsquared.google.spi.Element;
import com.plotsquared.google.spi.ElementVisitor;
import com.plotsquared.google.spi.InjectionPoint;
import java.util.Set;

public final class StaticInjectionRequest
implements Element {
    private final Object source;
    private final Class<?> type;

    StaticInjectionRequest(Object object, Class<?> clazz) {
        this.source = Preconditions.checkNotNull((Object)object, (Object)"source");
        this.type = (Class)Preconditions.checkNotNull(clazz, (Object)"type");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return InjectionPoint.forStaticMethodsAndFields(this.type);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).requestStaticInjection(this.type);
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> elementVisitor) {
        return elementVisitor.visit(this);
    }

    public boolean equals(Object object) {
        return object instanceof StaticInjectionRequest && ((StaticInjectionRequest)object).source.equals(this.source) && ((StaticInjectionRequest)object).type.equals(this.type);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.source, this.type});
    }
}

