/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.util;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CheckReturnValue;
import com.plotsquared.google.Inject;
import com.plotsquared.google.Injector;
import com.plotsquared.google.Provider;
import com.plotsquared.google.spi.Dependency;
import com.plotsquared.google.spi.InjectionPoint;
import com.plotsquared.google.spi.ProviderWithDependencies;
import java.util.Set;

@CheckReturnValue
public final class Providers {
    private Providers() {
    }

    public static <T> Provider<T> of(T t) {
        return new ConstantProvider(t);
    }

    @Deprecated
    public static <T> Provider<T> guicify(Provider<T> provider) {
        return provider;
    }

    public static <T> Provider<T> guicify(jakarta.inject.Provider<T> provider) {
        if (provider instanceof Provider) {
            return (Provider)provider;
        }
        jakarta.inject.Provider provider2 = (jakarta.inject.Provider)Preconditions.checkNotNull(provider, (Object)"provider");
        Set<InjectionPoint> set = InjectionPoint.forInstanceMethodsAndFields(provider.getClass());
        if (set.isEmpty()) {
            return new GuicifiedJakartaProvider(provider2);
        }
        ImmutableSet immutableSet = (ImmutableSet)set.stream().flatMap(injectionPoint -> injectionPoint.getDependencies().stream()).collect(ImmutableSet.toImmutableSet());
        return new GuicifiedJakartaProviderWithDependencies((Set)immutableSet, provider2);
    }

    private static final class GuicifiedJakartaProviderWithDependencies<T>
    extends GuicifiedJakartaProvider<T>
    implements ProviderWithDependencies<T> {
        private final Set<Dependency<?>> dependencies;

        private GuicifiedJakartaProviderWithDependencies(Set<Dependency<?>> set, jakarta.inject.Provider<T> provider) {
            super(provider);
            this.dependencies = set;
        }

        @Inject
        void initialize(Injector injector) {
            injector.injectMembers(this.delegate);
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.dependencies;
        }
    }

    private static class GuicifiedJakartaProvider<T>
    implements Provider<T> {
        protected final jakarta.inject.Provider<T> delegate;

        private GuicifiedJakartaProvider(jakarta.inject.Provider<T> provider) {
            this.delegate = provider;
        }

        @Override
        public T get() {
            return this.delegate.get();
        }

        public String toString() {
            return "guicified(" + this.delegate + ")";
        }

        public boolean equals(Object object) {
            return object instanceof GuicifiedJakartaProvider && Objects.equal(this.delegate, ((GuicifiedJakartaProvider)object).delegate);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.delegate});
        }
    }

    private static final class ConstantProvider<T>
    implements Provider<T> {
        private final T instance;

        private ConstantProvider(T t) {
            this.instance = t;
        }

        @Override
        public T get() {
            return this.instance;
        }

        public String toString() {
            return "of(" + this.instance + ")";
        }

        public boolean equals(Object object) {
            return object instanceof ConstantProvider && Objects.equal(this.instance, ((ConstantProvider)object).instance);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.instance});
        }
    }
}

