/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.prtree;

import com.plotsquared.prtree.DistanceCalculator;
import com.plotsquared.prtree.DistanceResult;
import com.plotsquared.prtree.MBRConverter;
import com.plotsquared.prtree.MinDistComparator;
import com.plotsquared.prtree.Node;
import com.plotsquared.prtree.NodeFilter;
import com.plotsquared.prtree.PointND;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;

class NearestNeighbour<T> {
    private final MBRConverter<T> converter;
    private final NodeFilter<T> filter;
    private final int maxHits;
    private final Node<T> root;
    private final DistanceCalculator<T> dc;
    private final PointND p;

    public NearestNeighbour(MBRConverter<T> mBRConverter, NodeFilter<T> nodeFilter, int n, Node<T> node, DistanceCalculator<T> distanceCalculator, PointND pointND) {
        this.converter = mBRConverter;
        this.filter = nodeFilter;
        this.maxHits = n;
        this.root = node;
        this.dc = distanceCalculator;
        this.p = pointND;
    }

    public List<DistanceResult<T>> find() {
        ArrayList<DistanceResult<T>> arrayList = new ArrayList<DistanceResult<T>>(this.maxHits);
        MinDistComparator minDistComparator = new MinDistComparator(this.converter, this.p);
        PriorityQueue priorityQueue = new PriorityQueue(20, minDistComparator);
        priorityQueue.add(this.root);
        while (!priorityQueue.isEmpty()) {
            Node node = (Node)priorityQueue.remove();
            node.nnExpand(this.dc, this.filter, arrayList, this.maxHits, priorityQueue, minDistComparator);
        }
        return arrayList;
    }
}

