/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.squirrelid.squirrelid.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.json.simple.JSONValue;

public class HttpRequest
implements Closeable {
    private static final Logger log = Logger.getLogger(HttpRequest.class.getCanonicalName());
    private static final int READ_TIMEOUT = 600000;
    private static final int READ_BUFFER_SIZE = 8192;
    private final Map<String, String> headers = new HashMap<String, String>();
    private final String method;
    private final URL url;
    private String contentType;
    private byte[] body;
    private HttpURLConnection conn;
    private InputStream inputStream;

    private HttpRequest(String string, URL uRL) {
        this.method = string;
        this.url = uRL;
    }

    public static HttpRequest get(URL uRL) {
        return HttpRequest.request("GET", uRL);
    }

    public static HttpRequest post(URL uRL) {
        return HttpRequest.request("POST", uRL);
    }

    public static HttpRequest request(String string, URL uRL) {
        return new HttpRequest(string, uRL);
    }

    public static URL url(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    private static URL reformat(URL uRL) {
        try {
            URL uRL2 = new URL(uRL.toString());
            URI uRI = new URI(uRL2.getProtocol(), uRL2.getUserInfo(), uRL2.getHost(), uRL2.getPort(), uRL2.getPath(), uRL2.getQuery(), uRL2.getRef());
            uRL2 = uRI.toURL();
            return uRL2;
        }
        catch (MalformedURLException | URISyntaxException exception) {
            return uRL;
        }
    }

    private static void checkInterrupted() {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public HttpRequest bodyJson(Object object) {
        this.contentType = "application/json";
        this.body = JSONValue.toJSONString((Object)object).getBytes();
        return this;
    }

    public HttpRequest bodyForm(Form form) {
        this.contentType = "application/x-www-form-urlencoded";
        this.body = form.toString().getBytes();
        return this;
    }

    public HttpRequest header(String string, String string2) {
        this.headers.put(string, string2);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpRequest execute() {
        boolean bl = false;
        try {
            if (this.conn != null) {
                throw new IllegalArgumentException("Connection already executed");
            }
            this.conn = (HttpURLConnection)HttpRequest.reformat(this.url).openConnection();
            if (this.body != null) {
                this.conn.setRequestProperty("Content-Type", this.contentType);
                this.conn.setRequestProperty("Content-Length", Integer.toString(this.body.length));
                this.conn.setDoInput(true);
            }
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                this.conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
            this.conn.setRequestMethod(this.method);
            this.conn.setUseCaches(false);
            this.conn.setDoOutput(true);
            this.conn.setReadTimeout(600000);
            this.conn.connect();
            if (this.body != null) {
                DataOutputStream dataOutputStream = new DataOutputStream(this.conn.getOutputStream());
                dataOutputStream.write(this.body);
                dataOutputStream.flush();
                dataOutputStream.close();
            }
            this.inputStream = this.conn.getResponseCode() == 200 ? this.conn.getInputStream() : this.conn.getErrorStream();
            bl = true;
        }
        finally {
            if (!bl) {
                this.close();
            }
        }
        return this;
    }

    public HttpRequest expectResponseCode(int ... nArray) {
        int n = this.getResponseCode();
        for (int n2 : nArray) {
            if (n2 != n) continue;
            return this;
        }
        this.close();
        throw new IOException("Did not get expected response code, got " + n + " for " + this.url);
    }

    public int getResponseCode() {
        if (this.conn == null) {
            throw new IllegalArgumentException("No connection has been made");
        }
        return this.conn.getResponseCode();
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedResponse returnContent() {
        if (this.inputStream == null) {
            throw new IllegalArgumentException("No input stream available");
        }
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = this.inputStream.read()) != -1) {
                HttpRequest.checkInterrupted();
                byteArrayOutputStream.write(n);
            }
            BufferedResponse bufferedResponse = new BufferedResponse(byteArrayOutputStream.toByteArray());
            return bufferedResponse;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpRequest saveContent(File file) {
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            this.saveContent(bufferedOutputStream);
        }
        catch (Throwable throwable) {
            HttpRequest.closeQuietly(bufferedOutputStream);
            HttpRequest.closeQuietly(fileOutputStream);
            throw throwable;
        }
        HttpRequest.closeQuietly(bufferedOutputStream);
        HttpRequest.closeQuietly(fileOutputStream);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpRequest saveContent(OutputStream outputStream) {
        try {
            int n;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.inputStream);
            byte[] byArray = new byte[8192];
            while ((n = bufferedInputStream.read(byArray, 0, 8192)) >= 0) {
                outputStream.write(byArray, 0, n);
                HttpRequest.checkInterrupted();
            }
        }
        finally {
            this.close();
        }
        return this;
    }

    @Override
    public void close() {
        if (this.conn != null) {
            this.conn.disconnect();
        }
    }

    public static final class Form {
        public final List<String> elements = new ArrayList<String>();

        private Form() {
        }

        public static Form form() {
            return new Form();
        }

        public Form add(String string, String string2) {
            try {
                this.elements.add(URLEncoder.encode(string, "UTF-8") + "=" + URLEncoder.encode(string2, "UTF-8"));
                return this;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            for (String string : this.elements) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append("&");
                }
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }
    }

    public static class BufferedResponse {
        private final byte[] data;

        private BufferedResponse(byte[] byArray) {
            this.data = byArray;
        }

        public byte[] asBytes() {
            return this.data;
        }

        public String asString(String string) {
            return new String(this.data, string);
        }

        public Object asJson() {
            return JSONValue.parse((String)this.asString("UTF-8"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BufferedResponse saveContent(File file) {
            FileOutputStream fileOutputStream = null;
            BufferedOutputStream bufferedOutputStream = null;
            file.getParentFile().mkdirs();
            try {
                fileOutputStream = new FileOutputStream(file);
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                this.saveContent(bufferedOutputStream);
            }
            catch (Throwable throwable) {
                HttpRequest.closeQuietly(bufferedOutputStream);
                HttpRequest.closeQuietly(fileOutputStream);
                throw throwable;
            }
            HttpRequest.closeQuietly(bufferedOutputStream);
            HttpRequest.closeQuietly(fileOutputStream);
            return this;
        }

        public BufferedResponse saveContent(OutputStream outputStream) {
            outputStream.write(this.data);
            return this;
        }
    }
}

