/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.EntityHandler;
import java.util.Iterator;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public abstract class CustomEntity {
    protected Mob entity;
    protected UUID entityUUID;
    protected String species;
    protected Main plugin;
    protected CustomEntityType entityType;

    public CustomEntity(Mob mob, Main main) {
        if (mob != null) {
            this.entity = mob;
            this.entityUUID = mob.getUniqueId();
            if (mob.getPersistentDataContainer().has(EntityHandler.removalKey, PersistentDataType.BYTE)) {
                main.getServer().getScheduler().runTaskLater((Plugin)main, () -> {
                    if (mob != null) {
                        mob.remove();
                    }
                }, 1L);
            }
        }
        this.plugin = main;
    }

    public abstract void tick();

    public abstract void function(Iterator<CustomEntity> var1);

    public abstract void clean();

    public abstract void update(FileConfiguration var1);

    public LivingEntity getEntity() {
        return this.entity;
    }

    public UUID getUUID() {
        return this.entityUUID;
    }

    public String getSpecies() {
        return this.species;
    }

    public CustomEntityType getType() {
        return this.entityType;
    }

    public void refreshReferences(Entity[] entityArray) {
        int n = 0;
        while (n < entityArray.length) {
            if (entityArray[n] != null) {
                entityArray[n] = this.plugin.getServer().getEntity(entityArray[n].getUniqueId());
            }
            ++n;
        }
    }

    public void refreshReferences(Entity[] entityArray, UUID[] uUIDArray) {
        int n = 0;
        while (n < entityArray.length) {
            entityArray[n] = this.plugin.getServer().getEntity(uUIDArray[n]);
            ++n;
        }
    }
}

