/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.christmasentities.Elf;
import deadlydisasters.entities.christmasentities.Frosty;
import deadlydisasters.entities.christmasentities.Grinch;
import deadlydisasters.entities.christmasentities.Santa;
import deadlydisasters.entities.easterentities.EasterBunny;
import deadlydisasters.entities.easterentities.KillerChicken;
import deadlydisasters.entities.easterentities.RampagingGoat;
import deadlydisasters.entities.endstormentities.BabyEndTotem;
import deadlydisasters.entities.endstormentities.EndTotem;
import deadlydisasters.entities.endstormentities.EndWorm;
import deadlydisasters.entities.endstormentities.VoidArcher;
import deadlydisasters.entities.endstormentities.VoidGuardian;
import deadlydisasters.entities.endstormentities.VoidStalker;
import deadlydisasters.entities.halloweenentities.Ghoul;
import deadlydisasters.entities.halloweenentities.Psyco;
import deadlydisasters.entities.halloweenentities.Scarecrow;
import deadlydisasters.entities.halloweenentities.Vampire;
import deadlydisasters.entities.infestedcavesentities.InfestedCreeper;
import deadlydisasters.entities.infestedcavesentities.InfestedDevourer;
import deadlydisasters.entities.infestedcavesentities.InfestedEnderman;
import deadlydisasters.entities.infestedcavesentities.InfestedHowler;
import deadlydisasters.entities.infestedcavesentities.InfestedSkeleton;
import deadlydisasters.entities.infestedcavesentities.InfestedSpirit;
import deadlydisasters.entities.infestedcavesentities.InfestedTribesman;
import deadlydisasters.entities.infestedcavesentities.InfestedZombie;
import deadlydisasters.entities.monsoonentities.CursedDiver;
import deadlydisasters.entities.purgeentities.DarkMage;
import deadlydisasters.entities.purgeentities.PrimedCreeper;
import deadlydisasters.entities.purgeentities.ShadowLeech;
import deadlydisasters.entities.purgeentities.SkeletonKnight;
import deadlydisasters.entities.purgeentities.SwampBeast;
import deadlydisasters.entities.purgeentities.TunnellerZombie;
import deadlydisasters.entities.purgeentities.ZombieKnight;
import deadlydisasters.entities.sandstormentities.AncientMummy;
import deadlydisasters.entities.sandstormentities.AncientSkeleton;
import deadlydisasters.entities.snowstormentities.Yeti;
import deadlydisasters.entities.solarstormentities.FirePhantom;
import deadlydisasters.entities.soulstormentities.LostSoul;
import deadlydisasters.entities.soulstormentities.SoulReaper;
import deadlydisasters.entities.soulstormentities.TamedLostSoul;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Goat;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Zombie;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class EntityHandler {
    private Main plugin;
    private FileConfiguration file;
    private boolean running;
    private RepeatingTask tick;
    private Random rand;
    public NamespacedKey globalKey;
    public static NamespacedKey removalKey;
    private Set<CustomEntity> list = ConcurrentHashMap.newKeySet();

    public EntityHandler(Main main, FileConfiguration fileConfiguration) {
        this.plugin = main;
        this.file = fileConfiguration;
        this.rand = main.random;
        this.globalKey = new NamespacedKey((Plugin)main, "customentity");
        removalKey = new NamespacedKey((Plugin)main, "removalkey");
        main.getServer().getScheduler().runTaskLater((Plugin)main, () -> {
            for (World world : Bukkit.getWorlds()) {
                for (LivingEntity livingEntity : world.getLivingEntities()) {
                    if (!livingEntity.getPersistentDataContainer().has(this.globalKey, PersistentDataType.BYTE)) continue;
                    this.addEntityBySpecies(null, (Entity)livingEntity);
                }
            }
        }, 1L);
    }

    public void addEntityBySpecies(String string, Entity entity) {
        if (string == null) {
            CustomEntityType[] customEntityTypeArray = CustomEntityType.values();
            int n = customEntityTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = customEntityTypeArray[n2];
                if (entity.getPersistentDataContainer().has(((CustomEntityType)((Object)object)).nameKey, PersistentDataType.BYTE)) {
                    string = ((CustomEntityType)((Object)object)).species;
                    break;
                }
                ++n2;
            }
        }
        switch (string) {
            case "babyendtotem": {
                this.addEntity(new BabyEndTotem((Mob)entity, this.file, this.plugin, this.rand));
                break;
            }
            case "endtotem": {
                this.addEntity(new EndTotem((Mob)entity, this.plugin, this.rand));
                break;
            }
            case "endworm": {
                this.addEntity(new EndWorm((Mob)entity, this.plugin, this.rand));
                break;
            }
            case "voidguardian": {
                this.addEntity(new VoidGuardian((Mob)entity, this.plugin, this.rand));
                break;
            }
            case "voidarcher": {
                this.addEntity(new VoidArcher((Mob)entity, this.plugin, this.rand));
                break;
            }
            case "voidstalker": {
                this.addEntity(new VoidStalker((Mob)entity, this.plugin, this.rand));
                break;
            }
            case "lostsoul": {
                this.addEntity(new LostSoul((Mob)entity, this.plugin, this.rand));
                break;
            }
            case "ancientskeleton": {
                this.addEntity(new AncientSkeleton((Mob)entity, this.plugin, this.rand));
                break;
            }
            case "ancientmummy": {
                this.addEntity(new AncientMummy((Mob)entity, this.plugin, this.rand));
                break;
            }
            case "primedcreeper": {
                this.addEntity(new PrimedCreeper((Mob)entity, this.plugin));
                break;
            }
            case "tunnellerzombie": {
                this.addEntity(new TunnellerZombie((Zombie)entity, null, this.plugin));
                break;
            }
            case "skeletonknight": {
                this.addEntity(new SkeletonKnight((Skeleton)entity, this.plugin));
                break;
            }
            case "darkmage": {
                this.addEntity(new DarkMage((Mob)entity, this.plugin));
                break;
            }
            case "soulreaper": {
                this.addEntity(new SoulReaper((Mob)entity, this.plugin, this.rand));
                break;
            }
            case "tamedlostsoul": {
                this.addEntity(new TamedLostSoul((Mob)entity, this.plugin, this.rand, null));
                break;
            }
            case "yeti": {
                this.addEntity(new Yeti((Mob)entity, this.plugin, this.rand));
                break;
            }
            case "firephantom": {
                this.addEntity(new FirePhantom((Mob)entity, this.plugin, this.rand));
                break;
            }
            case "curseddiver": {
                this.addEntity(new CursedDiver((Mob)entity, this.plugin, this.rand));
                break;
            }
            case "swampbeast": {
                this.addEntity(new SwampBeast((Mob)entity, this.plugin));
                break;
            }
            case "zombieknight": {
                this.addEntity(new ZombieKnight((Mob)entity, this.plugin));
                break;
            }
            case "shadowleech": {
                this.addEntity(new ShadowLeech((Zombie)entity, this.plugin, this.rand));
                break;
            }
            case "infestedskeleton": {
                this.addEntity(new InfestedSkeleton((Mob)entity, this.plugin));
                break;
            }
            case "infestedzombie": {
                this.addEntity(new InfestedZombie((Mob)entity, this.plugin));
                break;
            }
            case "infestedcreeper": {
                this.addEntity(new InfestedCreeper((Creeper)entity, this.plugin));
                break;
            }
            case "infestedenderman": {
                this.addEntity(new InfestedEnderman((Mob)entity, this.plugin));
                break;
            }
            case "infestedspirit": {
                this.addEntity(new InfestedSpirit((Mob)entity, this.plugin, this.rand));
                break;
            }
            case "infestedtribesman": {
                this.addEntity(new InfestedTribesman((Zombie)entity, this.plugin, this.rand));
                break;
            }
            case "infesteddevourer": {
                this.addEntity(new InfestedDevourer((Zombie)entity, this.plugin, this.rand));
                break;
            }
            case "infestedhowler": {
                this.addEntity(new InfestedHowler((Zombie)entity, this.plugin, this.rand));
                break;
            }
            case "elf": {
                this.addEntity(new Elf((Zombie)entity, this.plugin, this.rand));
                break;
            }
            case "frosty": {
                this.addEntity(new Frosty((Snowman)entity, this.plugin, this.rand));
                break;
            }
            case "grinch": {
                this.addEntity(new Grinch((Mob)entity, this.plugin, this.rand));
                break;
            }
            case "santa": {
                this.addEntity(new Santa((Zombie)entity, this.plugin, this.rand));
                break;
            }
            case "rampaginggoat": {
                this.addEntity(new RampagingGoat((Goat)entity, this.plugin));
                break;
            }
            case "easterbunny": {
                this.addEntity(new EasterBunny((Rabbit)entity, this.plugin, this.rand));
                break;
            }
            case "killerchicken": {
                this.addEntity(new KillerChicken((Zombie)entity, this.plugin));
                break;
            }
            case "scarecrow": {
                this.addEntity(new Scarecrow((Zombie)entity, this.plugin, this.rand));
                break;
            }
            case "ghoul": {
                this.addEntity(new Ghoul((Zombie)entity, null, this.plugin, false));
                break;
            }
            case "vampire": {
                this.addEntity(new Vampire((Mob)entity, this.plugin));
                break;
            }
            case "psyco": {
                this.addEntity(new Psyco((Mob)entity, this.plugin, this.rand));
            }
        }
    }

    public void startTimers() {
        this.running = true;
        this.tick = new RepeatingTask(this.plugin, 0, 1){

            @Override
            public void run() {
                Iterator<CustomEntity> iterator = EntityHandler.this.list.iterator();
                CustomEntity customEntity = null;
                while (iterator.hasNext()) {
                    try {
                        customEntity = iterator.next();
                        customEntity.tick();
                    }
                    catch (Exception exception) {
                        if (!CustomEntityType.bossTypes.contains((Object)customEntity.getType())) {
                            customEntity.clean();
                            iterator.remove();
                        }
                        if (!EntityHandler.this.plugin.debug) continue;
                        exception.printStackTrace();
                        Utils.sendDebugMessage();
                    }
                }
            }
        };
        new RepeatingTask(this.plugin, 0, 20){

            @Override
            public void run() {
                if (EntityHandler.this.list.isEmpty()) {
                    EntityHandler.this.tick.cancel();
                    this.cancel();
                    EntityHandler.this.running = false;
                    return;
                }
                Iterator<CustomEntity> iterator = EntityHandler.this.list.iterator();
                CustomEntity customEntity = null;
                while (iterator.hasNext()) {
                    try {
                        customEntity = iterator.next();
                        customEntity.function(iterator);
                    }
                    catch (Exception exception) {
                        if (!CustomEntityType.bossTypes.contains((Object)customEntity.getType())) {
                            customEntity.clean();
                            iterator.remove();
                        }
                        if (!EntityHandler.this.plugin.debug) continue;
                        exception.printStackTrace();
                        Utils.sendDebugMessage();
                    }
                }
            }
        };
    }

    public <T extends CustomEntity> T addEntity(T t) {
        if (this.findEntity(t.getEntity()) != null) {
            return t;
        }
        t.entity.setMetadata("dd-customentity", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)"protected"));
        t.entity.getPersistentDataContainer().set(this.globalKey, PersistentDataType.BYTE, (Object)0);
        this.list.add(t);
        if (!this.running) {
            this.startTimers();
        }
        return t;
    }

    public void addFalseEntity(CustomEntity customEntity) {
        this.list.add(customEntity);
        if (!this.running) {
            this.startTimers();
        }
    }

    public void removeEntity(CustomEntity customEntity) {
        this.list.remove(customEntity);
    }

    public CustomEntity findEntity(LivingEntity livingEntity) {
        for (CustomEntity customEntity : this.list) {
            if (customEntity.getUUID() == null || !customEntity.getUUID().equals(livingEntity.getUniqueId())) continue;
            return customEntity;
        }
        return null;
    }

    public void cleanEntities() {
        this.list.forEach(customEntity -> customEntity.clean());
    }

    public Set<CustomEntity> getList() {
        return this.list;
    }
}

