/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.endstormentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.EntityHandler;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.Iterator;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class EndWorm
extends CustomEntity {
    private double health = 30.0;
    private int cooldown = 0;
    private int frame = 0;
    private ArmorStand[] stands = new ArmorStand[10];
    private EvokerFangs fangs;
    private Random rand;
    private boolean anim;
    private Enderman damageEntity;
    private LivingEntity lastTarget;

    public EndWorm(final Mob mob, Main main, Random random) {
        super(mob, main);
        this.entityType = CustomEntityType.ENDWORM;
        this.rand = random;
        this.species = this.entityType.species;
        mob.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        if (main.mcVersion >= 1.16) {
            ((Zombie)mob).setBaby();
        } else {
            ((Zombie)mob).setBaby(true);
        }
        mob.setCanPickupItems(false);
        this.health = this.entityType.getHealth();
        if (main.mcVersion >= 1.16) {
            mob.getAttribute(Attribute.GENERIC_ATTACK_KNOCKBACK).setBaseValue(0.0);
        }
        mob.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(0.0);
        mob.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(40.0);
        mob.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.2);
        mob.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 999999, 0, true));
        mob.setSilent(true);
        mob.setInvulnerable(true);
        mob.setCollidable(false);
        new RepeatingTask(main, 0, 5){

            @Override
            public void run() {
                if (mob.isDead()) {
                    this.cancel();
                }
                mob.getWorld().playSound(mob.getLocation(), Sound.BLOCK_CHORUS_FLOWER_DEATH, SoundCategory.HOSTILE, 0.15f, 0.5f);
            }
        };
        mob.setMetadata("dd-unburnable", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)"protected"));
        mob.setMetadata("dd-endworm", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)"protected"));
    }

    @Override
    public void tick() {
        ArmorStand armorStand;
        int n;
        int n2;
        ArmorStand[] armorStandArray;
        BlockData blockData2;
        Vector vector;
        if (this.entity == null) {
            return;
        }
        World world = this.entity.getWorld();
        if (this.anim && this.cooldown == 0) {
            vector = new Vector(0.0, 0.32, 0.0);
            blockData2 = this.entity.getLocation().clone().subtract(0.0, 1.0, 0.0).getBlock().getBlockData();
            armorStandArray = this.stands;
            n2 = this.stands.length;
            n = 0;
            while (n < n2) {
                armorStand = armorStandArray[n];
                if (armorStand != null) {
                    armorStand.teleport(armorStand.getLocation().add(vector));
                    world.spawnParticle(Particle.BLOCK_DUST, armorStand.getLocation().clone().add(0.0, 1.5, 0.0), 5, 0.2, 0.2, 0.2, 0.1, (Object)blockData2);
                }
                ++n;
            }
            if (this.frame % 2 == 0) {
                this.stands[this.frame / 2] = this.createStand(this.entity.getLocation().clone().subtract((this.rand.nextDouble() - 0.5) / 4.0, 2.0, (this.rand.nextDouble() - 0.5) / 4.0), this.rand.nextInt(90));
            }
            ++this.frame;
            this.fangs.remove();
            this.fangs = (EvokerFangs)world.spawnEntity(this.stands[0].getLocation().clone().add(0.0, 2.0, 0.0), EntityType.EVOKER_FANGS);
            this.fangs.setSilent(true);
            if (this.stands[9] != null) {
                this.anim = false;
                this.cooldown = 8;
                this.fangs.setMetadata("dd-endworm", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)"protected"));
                this.fangs.setSilent(false);
            } else if (this.damageEntity == null && this.stands[4] != null) {
                this.damageEntity = (Enderman)world.spawnEntity(this.entity.getLocation(), EntityType.ENDERMAN);
                this.damageEntity.setAI(false);
                this.damageEntity.setSilent(true);
                this.damageEntity.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 999999, 0, true));
                this.damageEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.health);
                this.damageEntity.setHealth(this.health);
                this.damageEntity.setMetadata("dd-customentity", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)"protected"));
            }
        } else if (this.cooldown <= 7 && this.stands[0] != null) {
            vector = new Vector(0.0, -0.4, 0.0);
            blockData2 = this.entity.getLocation().clone().subtract(0.0, 1.0, 0.0).getBlock().getBlockData();
            armorStandArray = this.stands;
            n2 = this.stands.length;
            n = 0;
            while (n < n2) {
                armorStand = armorStandArray[n];
                if (armorStand != null) {
                    armorStand.teleport(armorStand.getLocation().add(vector));
                    world.spawnParticle(Particle.BLOCK_DUST, armorStand.getLocation().clone().add(0.0, 1.0, 0.0), 3, 0.2, 0.2, 0.2, 0.1, (Object)blockData2);
                }
                ++n;
            }
            this.fangs.remove();
            this.fangs = (EvokerFangs)world.spawnEntity(this.stands[0].getLocation().clone().add(0.0, 3.5, 0.0), EntityType.EVOKER_FANGS);
            this.fangs.setSilent(true);
            --this.frame;
            if (this.frame % 2 == 0) {
                this.stands[this.frame / 2].remove();
                this.stands[this.frame / 2] = null;
                if (this.frame == 0) {
                    this.fangs.setMetadata("dd-endworm", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)"protected"));
                    this.fangs.setSilent(false);
                    this.fangs.setVelocity(new Vector(0.0, -0.1, 0.0));
                }
            }
            if (this.damageEntity != null && this.stands[4] == null) {
                if (this.damageEntity.isDead()) {
                    if (this.plugin.mcVersion >= 1.16) {
                        world.spawnParticle(Particle.SOUL, this.entity.getLocation().add(0.0, 2.0, 0.0), 15, 0.3, 1.0, 0.3, 0.03);
                        world.playSound(this.entity.getLocation(), Sound.ENTITY_PIGLIN_BRUTE_DEATH, SoundCategory.HOSTILE, 1.0f, 0.5f);
                    }
                    if (this.damageEntity.getKiller() != null) {
                        CustomDropsFactory.generateDrops(this.damageEntity.getLocation(), this.entityType);
                        this.plugin.achievementsHandler.awardProgress(this.damageEntity.getKiller().getUniqueId(), "mobs.slayer.void_mobs", 1);
                    }
                    this.clean();
                    this.entity.remove();
                }
                this.health = this.damageEntity.getHealth();
                this.damageEntity.remove();
                this.damageEntity = null;
            }
        }
        if (this.fangs != null && this.fangs.isValid()) {
            vector = this.fangs.getLocation().clone();
            if (this.cooldown <= 7) {
                vector.subtract(0.0, 2.2, 0.0);
            }
            for (BlockData blockData2 : this.fangs.getNearbyEntities(0.7, 1.5, 0.7)) {
                if (!(blockData2 instanceof LivingEntity) || blockData2 instanceof ArmorStand || blockData2 instanceof Player && Utils.isPlayerImmune((Player)blockData2)) continue;
                blockData2.setVelocity(new Vector(blockData2.getLocation().getX() - vector.getX(), blockData2.getLocation().getY() - vector.getY(), blockData2.getLocation().getZ() - vector.getZ()).normalize().multiply(-1).multiply(0.3));
            }
        }
        if (this.damageEntity != null && this.damageEntity.getNoDamageTicks() == 20) {
            world.spawnParticle(Particle.DAMAGE_INDICATOR, this.entity.getLocation().add(0.0, 2.0, 0.0), 20, 0.3, 2.0, 0.3, 0.25);
            if (this.plugin.mcVersion >= 1.16) {
                world.playSound(this.entity.getLocation(), Sound.ENTITY_PIGLIN_BRUTE_HURT, SoundCategory.HOSTILE, 1.0f, 0.5f);
            }
        }
        if (this.entity.getLocation().clone().subtract(0.0, 1.0, 0.0).getBlock().getType().isBlock()) {
            if (!this.anim) {
                world.spawnParticle(Particle.BLOCK_CRACK, this.entity.getLocation(), 5, 0.2, 0.2, 0.2, 0.1, (Object)this.entity.getLocation().clone().subtract(0.0, 1.0, 0.0).getBlock().getBlockData());
            } else {
                world.spawnParticle(Particle.BLOCK_CRACK, this.entity.getLocation(), 40, 0.4, 0.3, 0.4, 0.1, (Object)this.entity.getLocation().clone().subtract(0.0, 1.0, 0.0).getBlock().getBlockData());
            }
        }
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null) {
            ArmorStand[] armorStandArray = this.stands;
            int n = this.stands.length;
            int n2 = 0;
            while (n2 < n) {
                ArmorStand armorStand = armorStandArray[n2];
                if (armorStand != null) {
                    armorStand.remove();
                }
                ++n2;
            }
            iterator.remove();
            return;
        }
        int n = 0;
        while (n < this.stands.length) {
            if (this.stands[n] != null) {
                this.stands[n] = (ArmorStand)this.plugin.getServer().getEntity(this.stands[n].getUniqueId());
            }
            ++n;
        }
        if (this.entity.isDead()) {
            this.clean();
            iterator.remove();
            return;
        }
        if (this.entity.getTarget() != null) {
            this.lastTarget = this.entity.getTarget();
        }
        if (this.entity.getLocation().getBlockY() < -64 && this.lastTarget != null && this.lastTarget instanceof Player) {
            this.plugin.achievementsHandler.awardProgress(this.lastTarget.getUniqueId(), "master.series.void_master", 1, 4);
            this.entity.remove();
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            if (this.cooldown == 2) {
                this.entity.setAI(true);
            }
        }
    }

    @Override
    public void clean() {
        ArmorStand[] armorStandArray = this.stands;
        int n = this.stands.length;
        int n2 = 0;
        while (n2 < n) {
            ArmorStand armorStand = armorStandArray[n2];
            if (armorStand != null) {
                armorStand.remove();
            }
            ++n2;
        }
        if (this.fangs != null) {
            this.fangs.remove();
        }
        if (this.damageEntity != null) {
            this.damageEntity.remove();
        }
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }

    public void triggerAnimation() {
        if (this.cooldown == 0 && this.entity.isOnGround() && this.entity.hasAI()) {
            this.entity.setAI(false);
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    EndWorm.this.anim = true;
                    EndWorm.this.fangs = (EvokerFangs)EndWorm.this.entity.getWorld().spawnEntity(EndWorm.this.entity.getLocation().clone().subtract(0.0, 0.5, 0.0), EntityType.EVOKER_FANGS);
                    EndWorm.this.fangs.setSilent(true);
                    EndWorm.this.entity.getWorld().playSound(EndWorm.this.entity.getLocation(), Sound.BLOCK_GRAVEL_BREAK, SoundCategory.HOSTILE, 1.0f, 0.5f);
                    if (((EndWorm)EndWorm.this).plugin.mcVersion >= 1.16) {
                        EndWorm.this.entity.getWorld().playSound(EndWorm.this.entity.getLocation(), Sound.BLOCK_NETHER_SPROUTS_BREAK, SoundCategory.HOSTILE, 1.0f, 0.5f);
                        EndWorm.this.entity.getWorld().playSound(EndWorm.this.entity.getLocation(), Sound.ENTITY_HOGLIN_DEATH, SoundCategory.HOSTILE, 1.0f, 0.5f);
                    }
                }
            }, 5L);
        }
    }

    private ArmorStand createStand(Location location, float f) {
        location.setYaw(f);
        ArmorStand armorStand = (ArmorStand)location.getWorld().spawnEntity(location, EntityType.ARMOR_STAND);
        if (this.plugin.mcVersion >= 1.16) {
            armorStand.setInvisible(true);
        } else {
            armorStand.setVisible(false);
        }
        armorStand.setGravity(false);
        armorStand.setMarker(true);
        if (this.plugin.mcVersion >= 1.16) {
            armorStand.addEquipmentLock(EquipmentSlot.CHEST, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.FEET, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.HEAD, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.LEGS, ArmorStand.LockType.ADDING_OR_CHANGING);
        }
        if (this.plugin.mcVersion >= 1.16) {
            armorStand.getEquipment().setHelmet(new ItemStack(Material.CRYING_OBSIDIAN));
        } else {
            armorStand.getEquipment().setHelmet(new ItemStack(Material.OBSIDIAN));
        }
        armorStand.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        return armorStand;
    }
}

