/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.endstormentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.handlers.ItemsHandler;
import deadlydisasters.handlers.Languages;
import java.util.Iterator;
import java.util.Random;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.persistence.PersistentDataType;

public class VoidArcher
extends CustomEntity {
    private double health = 20.0;
    private Random rand;
    private ItemStack[] armor = new ItemStack[]{new ItemStack(Material.LEATHER_BOOTS), new ItemStack(Material.LEATHER_LEGGINGS), new ItemStack(Material.LEATHER_CHESTPLATE), CustomHead.VOIDARCHER.getHead()};

    public VoidArcher(Mob mob, Main main, Random random) {
        super(mob, main);
        this.entityType = CustomEntityType.VOIDARCHER;
        this.rand = random;
        this.species = this.entityType.species;
        mob.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        this.health = this.entityType.getHealth();
        mob.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.health);
        mob.setHealth(this.health);
        mob.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(40.0);
        mob.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.05);
        int n = 0;
        while (n < 3) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)this.armor[n].getItemMeta();
            leatherArmorMeta.setColor(Color.fromRGB((int)50, (int)50, (int)50));
            this.armor[n].setItemMeta((ItemMeta)leatherArmorMeta);
            ++n;
        }
        mob.getEquipment().setArmorContents(this.armor);
        mob.getEquipment().setItemInMainHand(ItemsHandler.voidswrath);
        EntityEquipment entityEquipment = mob.getEquipment();
        entityEquipment.setHelmetDropChance(0.0f);
        entityEquipment.setChestplateDropChance(0.0f);
        entityEquipment.setLeggingsDropChance(0.0f);
        entityEquipment.setBootsDropChance(0.0f);
        entityEquipment.setItemInMainHandDropChance(0.0f);
        if (mob.getCustomName() == null) {
            mob.setCustomName(Languages.getString("entities.voidArcher"));
        }
        mob.setSilent(true);
    }

    @Override
    public void tick() {
        if (this.entity == null) {
            return;
        }
        this.entity.getWorld().spawnParticle(Particle.PORTAL, this.entity.getLocation().add(0.0, 0.75, 0.0), 7, 0.1, 0.1, 0.1, 0.8);
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null) {
            iterator.remove();
            return;
        }
        if (this.entity.isDead()) {
            if (this.plugin.mcVersion >= 1.16) {
                this.entity.getWorld().spawnParticle(Particle.SOUL, this.entity.getLocation().add(0.0, 0.5, 0.0), 15, 0.3, 0.5, 0.3, 0.03);
            }
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_DONKEY_DEATH, SoundCategory.HOSTILE, 0.3f, 0.5f);
            if (this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            iterator.remove();
            return;
        }
        if (this.entity.getHealth() < this.health) {
            this.health = this.entity.getHealth();
            int n = 0;
            while (n < 3) {
                int n2 = (int)(this.entity.getLocation().getX() + (double)(this.rand.nextInt(50) - 25));
                int n3 = (int)(this.entity.getLocation().getZ() + (double)(this.rand.nextInt(50) - 25));
                if (!(this.entity.getLocation().distance(this.entity.getWorld().getHighestBlockAt(n2, n3).getLocation()) > 25.0)) {
                    for (Entity entity : this.entity.getNearbyEntities(6.0, 6.0, 6.0)) {
                        if (!(entity instanceof Player)) continue;
                        ((Player)entity).playSound(entity.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
                    }
                    this.entity.teleport(this.entity.getWorld().getHighestBlockAt(n2, n3).getLocation().add(0.0, 1.0, 0.0));
                    break;
                }
                ++n;
            }
        }
        if (this.rand.nextInt(6) == 0) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ELDER_GUARDIAN_AMBIENT, SoundCategory.HOSTILE, 1.0f, 0.8f);
        }
    }

    @Override
    public void clean() {
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }
}

