/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.infestedcavesentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.entities.EntityHandler;
import deadlydisasters.handlers.Languages;
import java.util.Iterator;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.EulerAngle;

public class InfestedCreeper
extends CustomEntity {
    private BlockData data;
    private ArmorStand stand;

    public InfestedCreeper(Creeper creeper, Main main) {
        super((Mob)creeper, main);
        this.entityType = CustomEntityType.INFESTEDCREEPER;
        this.species = this.entityType.species;
        creeper.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        creeper.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        creeper.setHealth(this.entityType.getHealth());
        creeper.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
        creeper.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.25);
        creeper.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(40.0);
        creeper.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 999999, 0, true, false));
        creeper.setExplosionRadius(5);
        if (main.mcVersion >= 1.16) {
            creeper.setFuseTicks(15);
        }
        this.stand = (ArmorStand)creeper.getWorld().spawnEntity(creeper.getLocation().clone().add(100.0, 100.0, 0.0), EntityType.ARMOR_STAND);
        if (main.mcVersion >= 1.16) {
            this.stand.setInvisible(true);
        } else {
            this.stand.setVisible(false);
        }
        this.stand.setMarker(true);
        this.stand.setGravity(false);
        if (main.mcVersion >= 1.16) {
            this.stand.addEquipmentLock(EquipmentSlot.CHEST, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.FEET, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.HEAD, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.LEGS, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.OFF_HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
        }
        this.stand.getEquipment().setHelmet(CustomHead.INFESTEDCREEPER.getHead());
        this.stand.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        creeper.setMetadata("dd-infestedcreeper", (MetadataValue)main.fixedData);
        if (creeper.getCustomName() == null) {
            creeper.setCustomName(Languages.getString("entities.infestedCreeper"));
        }
        this.data = main.mcVersion >= 1.19 ? Material.SCULK.createBlockData() : Material.NETHERRACK.createBlockData();
    }

    @Override
    public void tick() {
        if (this.entity == null || this.stand == null) {
            return;
        }
        this.entity.getWorld().spawnParticle(Particle.BLOCK_CRACK, this.entity.getLocation().add(0.0, 0.7, 0.0), 10, 0.25, 0.4, 0.25, 0.1, (Object)this.data);
        this.stand.teleport(this.entity.getLocation().subtract(0.0, 0.2, 0.0));
        this.stand.setHeadPose(new EulerAngle(Math.toRadians(this.entity.getLocation().getPitch()), 0.0, 0.0));
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null || this.entity.isDead() || this.stand == null) {
            if (this.entity != null && this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            this.clean();
            iterator.remove();
            return;
        }
        this.stand = (ArmorStand)this.plugin.getServer().getEntity(this.stand.getUniqueId());
    }

    @Override
    public void clean() {
        if (this.stand != null) {
            this.stand.remove();
        }
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }
}

