/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.purgeentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.handlers.ItemsHandler;
import deadlydisasters.handlers.Languages;
import java.util.Iterator;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class DarkMage
extends CustomEntity {
    private int cooldown = 0;
    private double speed;
    private FixedMetadataValue fixdata = new FixedMetadataValue((Plugin)this.plugin, (Object)"protected");
    private ShulkerBullet[] bullets = new ShulkerBullet[13];
    public LivingEntity reboundTarget;

    public DarkMage(Mob mob, Main main) {
        super(mob, main);
        this.entityType = CustomEntityType.DARKMAGE;
        this.species = this.entityType.species;
        mob.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        ItemStack[] itemStackArray = new ItemStack[]{new ItemStack(Material.LEATHER_BOOTS), new ItemStack(Material.LEATHER_LEGGINGS), new ItemStack(Material.LEATHER_CHESTPLATE), CustomHead.MAGE.getHead()};
        int n = 0;
        while (n < 3) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemStackArray[n].getItemMeta();
            leatherArmorMeta.setColor(Color.fromBGR((int)40, (int)40, (int)40));
            itemStackArray[n].setItemMeta((ItemMeta)leatherArmorMeta);
            ++n;
        }
        mob.getEquipment().setArmorContents(itemStackArray);
        mob.getEquipment().setHelmetDropChance(0.0f);
        mob.getEquipment().setItemInMainHand(ItemsHandler.mageWand);
        mob.getEquipment().setItemInMainHandDropChance(0.0f);
        mob.setCanPickupItems(false);
        mob.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        mob.setHealth(this.entityType.getHealth());
        mob.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.3);
        mob.setMetadata("dd-darkmage", (MetadataValue)this.fixdata);
        if (mob.getCustomName() == null) {
            mob.setCustomName(Languages.getString("entities.darkMage"));
        }
    }

    @Override
    public void tick() {
        if (this.entity == null) {
            return;
        }
        Location location = this.entity.getLocation();
        if (this.entity.getNoDamageTicks() == 20 && this.reboundTarget != null) {
            Location location2 = this.reboundTarget.getLocation();
            Vector vector = new Vector(location2.getX() - location.getX(), location2.getY() - location.getY(), location2.getZ() - location.getZ()).normalize();
            try {
                vector.checkFinite();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
            this.bullets[12] = (ShulkerBullet)this.entity.getWorld().spawnEntity(location.clone().add(0.0, 1.0, 0.0), EntityType.SHULKER_BULLET);
            this.bullets[12].setShooter((ProjectileSource)this.entity);
            this.bullets[12].setVelocity(vector);
            this.bullets[12].setMetadata("dd-magebullet", (MetadataValue)this.fixdata);
            this.reboundTarget = null;
        }
        if (this.cooldown <= 5) {
            return;
        }
        if (this.cooldown > 6) {
            Location location3;
            this.speed += 0.09;
            double d = this.entity.getLocation().getY() + 1.0;
            int n = 0;
            while (n < 6) {
                location3 = this.bullets[n].getLocation();
                location3.setY(d + 0.3);
                this.bullets[n].teleport(location3);
                this.bullets[n].setVelocity(new Vector(location3.getX() - location.getX(), 0.0, location3.getZ() - location.getZ()).rotateAroundY(1.2).normalize().multiply(this.speed).setY(0.04));
                ++n;
            }
            n = 6;
            while (n < 12) {
                location3 = this.bullets[n].getLocation();
                location3.setY(d - 0.3);
                this.bullets[n].teleport(location3);
                this.bullets[n].setVelocity(new Vector(location3.getX() - location.getX(), 0.0, location3.getZ() - location.getZ()).rotateAroundY(-1.2).normalize().multiply(this.speed).setY(0.04));
                ++n;
            }
        } else if (this.entity.getTarget() != null) {
            double d = (this.entity.getTarget().getLocation().getY() + 1.0 - this.entity.getLocation().getY() + 1.0) / 10.0;
            int n = 0;
            while (n < 12) {
                Location location4 = this.bullets[n].getLocation();
                this.bullets[n].setVelocity(new Vector(location4.getX() - location.getX(), 0.0, location4.getZ() - location.getZ()).normalize().setY(d));
                ++n;
            }
            this.entity.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.3);
        }
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null) {
            iterator.remove();
            return;
        }
        if (this.entity.isDead()) {
            if (this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            iterator.remove();
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        if (this.entity.getTarget() != null && this.entity.getWorld().equals(this.entity.getTarget().getWorld()) && this.entity.getLocation().distanceSquared(this.entity.getTarget().getLocation()) <= 100.0) {
            this.cooldown = 7;
            this.entity.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.0);
            this.speed = 0.05;
            World world = this.entity.getWorld();
            int n = 0;
            while (n < 6) {
                this.bullets[n] = (ShulkerBullet)world.spawnEntity(this.entity.getLocation().clone().add(new Vector(1.0, 1.3, 0.0).rotateAroundY((double)n).normalize()), EntityType.SHULKER_BULLET);
                this.bullets[n].setShooter((ProjectileSource)this.entity);
                this.bullets[n].setMetadata("dd-magebullet", (MetadataValue)this.fixdata);
                ++n;
            }
            n = 6;
            while (n < 12) {
                this.bullets[n] = (ShulkerBullet)world.spawnEntity(this.entity.getLocation().clone().add(new Vector(1.0, 0.7, 0.0).rotateAroundY((double)n + 0.5).normalize()), EntityType.SHULKER_BULLET);
                this.bullets[n].setShooter((ProjectileSource)this.entity);
                this.bullets[n].setMetadata("dd-magebullet", (MetadataValue)this.fixdata);
                ++n;
            }
            if (this.plugin.mcVersion >= 1.16) {
                this.entity.swingMainHand();
            }
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ELDER_GUARDIAN_CURSE, SoundCategory.HOSTILE, 0.75f, 0.5f);
        }
    }

    @Override
    public void clean() {
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }
}

