/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.purgeentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.entities.EntityHandler;
import deadlydisasters.handlers.Languages;
import java.util.Iterator;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SkeletonKnight
extends CustomEntity {
    private SkeletonHorse horse;
    private UUID horseUUID;

    public SkeletonKnight(Skeleton skeleton, Main main) {
        super((Mob)skeleton, main);
        this.entityType = CustomEntityType.SKELETONKNIGHT;
        this.species = this.entityType.species;
        skeleton.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        skeleton.getEquipment().setHelmet(CustomHead.SKELETONKNIGHT.getHead());
        skeleton.getEquipment().setHelmetDropChance(0.0f);
        skeleton.getEquipment().setItemInMainHand(new ItemStack(Material.IRON_SWORD));
        skeleton.getEquipment().setItemInOffHand(new ItemStack(Material.SHIELD));
        skeleton.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        skeleton.setHealth(this.entityType.getHealth());
        skeleton.setCanPickupItems(false);
        if (!skeleton.isInsideVehicle()) {
            this.horse = (SkeletonHorse)skeleton.getWorld().spawnEntity(skeleton.getLocation(), EntityType.SKELETON_HORSE);
            this.horse.setTamed(true);
            this.horse.addPassenger((Entity)skeleton);
            this.horse.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.375);
            this.horseUUID = this.horse.getUniqueId();
            this.horse.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        } else if (skeleton.getVehicle() instanceof SkeletonHorse) {
            this.horseUUID = skeleton.getVehicle().getUniqueId();
        }
        if (skeleton.getCustomName() == null) {
            skeleton.setCustomName(Languages.getString("entities.skeletonKnight"));
        }
    }

    @Override
    public void tick() {
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Skeleton)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.horseUUID != null) {
            this.horse = (SkeletonHorse)this.plugin.getServer().getEntity(this.horseUUID);
        }
        if (this.entity == null || this.entity.isDead()) {
            if (this.entity != null && this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            iterator.remove();
            if (this.horse != null && !this.horse.isDead()) {
                this.horse.setTamed(false);
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        if (SkeletonKnight.this.horse != null && !SkeletonKnight.this.horse.isDead()) {
                            SkeletonKnight.this.horse.remove();
                        }
                    }
                }, 600L);
            }
            return;
        }
    }

    @Override
    public void clean() {
        if (this.horse != null && !this.horse.isDead()) {
            this.horse.remove();
        }
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }
}

