/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.snowstormentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.entities.EntityHandler;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.BlockVector;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class Yeti
extends CustomEntity {
    private Random rand;
    private UUID[] standUUID = new UUID[19];
    private ArmorStand[] stands = new ArmorStand[19];
    private int cooldown = 0;
    private int jumpTicks;
    private Vector jumpVel;
    private Location past;
    private Location step;
    private boolean alive = true;

    public Yeti(Mob mob, Main main, Random random) {
        super(mob, main);
        this.entityType = CustomEntityType.YETI;
        this.species = this.entityType.species;
        mob.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        this.rand = random;
        if (mob.getCustomName() == null) {
            mob.setCustomName(Languages.getString("entities.yeti"));
        }
        int n = 0;
        while (n < 19) {
            this.spawnStand(n);
            ++n;
        }
        if (main.mcVersion >= 1.16) {
            mob.getAttribute(Attribute.GENERIC_ATTACK_KNOCKBACK).setBaseValue(3.0);
        }
        mob.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
        mob.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        mob.setHealth(this.entityType.getHealth());
        mob.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.28);
        mob.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(40.0);
        mob.setMetadata("dd-yeti", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)"protected"));
        mob.setSilent(true);
        mob.setCanPickupItems(false);
        mob.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        this.step = mob.getLocation();
    }

    @Override
    public void tick() {
        if (this.entity == null || !this.alive) {
            return;
        }
        int n = 0;
        while (n < this.stands.length) {
            if (this.stands[n] == null || this.stands[n].isDead()) {
                this.spawnStand(n);
            }
            ++n;
        }
        if (this.entity.isDead()) {
            this.entity.remove();
            if (this.entity.getKiller() != null) {
                Object object;
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
                HashMap<ArmorStand, Vector> hashMap = new HashMap<ArmorStand, Vector>();
                ArmorStand[] armorStandArray = this.stands;
                int n2 = this.stands.length;
                int n3 = 0;
                while (n3 < n2) {
                    object = armorStandArray[n3];
                    hashMap.put((ArmorStand)object, new Vector((this.rand.nextDouble() - 0.5) / 7.0, -0.001, (this.rand.nextDouble() - 0.5) / 7.0));
                    object.setRotation((float)this.rand.nextInt(360), 0.0f);
                    ++n3;
                }
                object = new int[]{(Integer)this.entityType.grabCustomSetting("corpse_life_ticks")};
                new RepeatingTask(this.plugin, 0, 1, (int[])object, hashMap){
                    private final /* synthetic */ int[] val$deathTicks;
                    private final /* synthetic */ Map val$vecs;
                    {
                        this.val$deathTicks = nArray;
                        this.val$vecs = map;
                        super(javaPlugin, n, n2);
                    }

                    @Override
                    public void run() {
                        this.val$deathTicks[0] = this.val$deathTicks[0] - 1;
                        if (this.val$deathTicks[0] <= 0) {
                            this.cancel();
                            Yeti.this.clean();
                        }
                        Iterator iterator = this.val$vecs.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            ArmorStand armorStand = (ArmorStand)entry.getKey();
                            if (armorStand.getLocation().clone().add(0.0, 1.4, 0.0).getBlock().isPassable()) {
                                Vector vector = (Vector)entry.getValue();
                                armorStand.teleport(armorStand.getLocation().clone().add(vector));
                                entry.setValue(vector.setY(vector.getY() - 0.003));
                                continue;
                            }
                            iterator.remove();
                        }
                    }
                };
            } else {
                this.clean();
            }
            this.alive = false;
            return;
        }
        if (this.entity.getNoDamageTicks() == 20) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_RAVAGER_HURT, SoundCategory.HOSTILE, 1.0f, 0.5f);
        }
        Location location = this.entity.getLocation();
        this.stands[0].setHeadPose(new EulerAngle(Math.toRadians(location.getPitch()), 0.0, 0.0));
        if (this.plugin.mcVersion >= 1.17) {
            this.entity.getWorld().spawnParticle(Particle.SNOWFLAKE, location.clone().add(0.0, 1.4, 0.0), 10, 0.5, 0.6, 0.5, 0.04);
        }
        Vector vector = this.entity.getLocation().getDirection();
        Vector vector2 = new Vector(vector.getZ(), vector.getY(), -vector.getX());
        Vector vector3 = new Vector(-vector.getZ(), vector.getY(), vector.getX());
        this.stands[0].teleport(location.clone().add(0.0, 0.7, 0.0).add(vector.clone().multiply(0.35)));
        this.stands[1].teleport(location.clone().add(0.0, 0.4, 0.0).add(vector.clone().multiply(0.3)));
        this.stands[2].teleport(location.clone().add(0.0, 0.5, 0.0).add(vector2.clone().multiply(0.2)).add(vector.clone().multiply(0.15)));
        this.stands[3].teleport(location.clone().add(0.0, 0.5, 0.0).add(vector3.clone().multiply(0.2)).add(vector.clone().multiply(0.15)));
        this.stands[4].teleport(location.clone().add(0.0, 0.1, 0.0).add(vector2.clone().multiply(0.3)).add(vector.clone().multiply(0.25)));
        this.stands[5].teleport(location.clone().add(0.0, 0.1, 0.0).add(vector3.clone().multiply(0.3)).add(vector.clone().multiply(0.25)));
        this.stands[6].teleport(location.clone().add(0.0, -0.4, 0.0).add(vector2.clone().multiply(0.2)).add(vector.clone().multiply(0.15)));
        this.stands[7].teleport(location.clone().add(0.0, -0.4, 0.0).add(vector3.clone().multiply(0.2)).add(vector.clone().multiply(0.15)));
        this.stands[8].teleport(location.clone().add(0.0, -0.9, 0.0).add(vector2.clone().multiply(0.35)).add(vector.clone().multiply(0.1)));
        this.stands[9].teleport(location.clone().add(0.0, -0.9, 0.0).add(vector3.clone().multiply(0.35)).add(vector.clone().multiply(0.1)));
        this.stands[10].teleport(location.clone().add(0.0, -1.4, 0.0).add(vector2.clone().multiply(0.35)));
        this.stands[11].teleport(location.clone().add(0.0, -1.4, 0.0).add(vector3.clone().multiply(0.35)));
        this.stands[12].teleport(location.clone().add(0.0, 0.1, 0.0).add(vector2.clone().multiply(0.3)).add(vector.clone().multiply(-1).multiply(0.25)));
        this.stands[13].teleport(location.clone().add(0.0, 0.1, 0.0).add(vector3.clone().multiply(0.3)).add(vector.clone().multiply(-1).multiply(0.25)));
        this.stands[14].teleport(location.clone().add(0.0, -0.4, 0.0).add(vector2.clone().multiply(0.2)).add(vector.clone().multiply(-1).multiply(0.15)));
        this.stands[15].teleport(location.clone().add(0.0, -0.4, 0.0).add(vector3.clone().multiply(0.2)).add(vector.clone().multiply(-1).multiply(0.15)));
        this.stands[16].teleport(location.clone().add(0.0, 0.15, 0.0).add(vector2.clone().multiply(0.6)));
        this.stands[17].teleport(location.clone().add(0.0, 0.15, 0.0).add(vector3.clone().multiply(0.6)));
        this.stands[18].teleport(location.clone().add(0.0, 0.6, 0.0));
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
            this.entity.setVelocity(this.entity.getVelocity().add(this.jumpVel));
            if (this.entity.isOnGround()) {
                this.jumpTicks = 0;
                this.entity.getWorld().playSound(this.entity.getLocation(), Sound.BLOCK_GLASS_FALL, SoundCategory.HOSTILE, 2.0f, 0.5f);
                if (this.plugin.mcVersion >= 1.17) {
                    this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_PLAYER_HURT_FREEZE, SoundCategory.HOSTILE, 2.0f, 0.6f);
                } else {
                    this.entity.getWorld().playSound(this.entity.getLocation(), Sound.BLOCK_GLASS_BREAK, SoundCategory.HOSTILE, 0.5f, 1.0f);
                }
            }
        }
        if (this.step.distanceSquared(this.entity.getLocation()) > 0.8 && this.entity.isOnGround()) {
            this.step = this.entity.getLocation();
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.BLOCK_SNOW_STEP, SoundCategory.HOSTILE, 2.0f, 0.5f);
        }
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.alive && this.entity == null) {
            ArmorStand[] armorStandArray = this.stands;
            int n = this.stands.length;
            int n2 = 0;
            while (n2 < n) {
                ArmorStand armorStand = armorStandArray[n2];
                if (armorStand != null) {
                    armorStand.remove();
                }
                ++n2;
            }
            iterator.remove();
            return;
        }
        this.refreshReferences((Entity[])this.stands, this.standUUID);
        if (!this.alive) {
            return;
        }
        if (this.entity.isDead()) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_RAVAGER_DEATH, SoundCategory.HOSTILE, 2.0f, 0.5f);
            this.entity.getWorld().spawnParticle(Particle.SNOW_SHOVEL, this.entity.getLocation().add(0.0, 1.5, 0.0), 40, 0.3, 0.4, 0.3, 0.01);
            iterator.remove();
            return;
        }
        if (this.entity.getTarget() == null) {
            for (Entity entity : this.entity.getWorld().getNearbyEntities(this.entity.getLocation(), 15.0, 15.0, 15.0)) {
                if (!(entity instanceof Player) || Utils.isPlayerImmune((Player)entity)) continue;
                this.entity.setTarget((LivingEntity)entity);
                this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_RAVAGER_ROAR, SoundCategory.HOSTILE, 2.0f, 0.5f);
                break;
            }
        } else if (this.cooldown <= 12 && this.entity.getTarget().getLocation().getY() - 1.0 > this.entity.getLocation().getY() && this.past != null && this.past.distanceSquared(this.entity.getLocation()) < 0.8) {
            this.entity.setVelocity(new Vector(this.entity.getLocation().getX() - this.entity.getTarget().getLocation().getX(), 0.0, this.entity.getLocation().getZ() - this.entity.getTarget().getLocation().getZ()).normalize().multiply(-1).setY(0.9));
            this.jumpVel = new Vector(this.entity.getLocation().getX() - this.entity.getTarget().getLocation().getX(), 0.0, this.entity.getLocation().getZ() - this.entity.getTarget().getLocation().getZ()).normalize().multiply(-1).multiply(0.01).setY(0);
            this.jumpTicks = 20;
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_PANDA_BITE, SoundCategory.HOSTILE, 2.0f, 0.5f);
        }
        this.past = this.entity.getLocation().clone();
        if (this.rand.nextInt(10) == 0) {
            int n = this.rand.nextInt(4);
            if (n == 0) {
                this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_RAVAGER_AMBIENT, SoundCategory.HOSTILE, 1.0f, 0.5f);
            } else if (n == 1) {
                this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_RAVAGER_ATTACK, SoundCategory.HOSTILE, 1.0f, 0.5f);
            } else if (n == 2) {
                this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_RAVAGER_CELEBRATE, SoundCategory.HOSTILE, 1.0f, 0.5f);
            } else if (n == 3) {
                this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_RAVAGER_STUNNED, SoundCategory.HOSTILE, 1.0f, 0.5f);
            }
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        if (this.entity.getTarget() != null && this.entity.getTarget().getWorld().equals(this.entity.getWorld()) && this.entity.getTarget().getLocation().distanceSquared(this.entity.getLocation()) <= 49.0 && this.entity.isOnGround()) {
            this.cooldown = 15;
            final World world = this.entity.getWorld();
            this.entity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 40, 5, true, false));
            final LivingEntity livingEntity = this.entity.getTarget();
            final ArmorStand armorStand = (ArmorStand)world.spawnEntity(this.entity.getLocation().clone().add(this.entity.getLocation().getDirection().multiply(0.1)), EntityType.ARMOR_STAND);
            armorStand.setSmall(true);
            this.entity.setTarget((LivingEntity)armorStand);
            final int[] nArray = new int[]{2};
            final Location location = this.entity.getLocation().clone();
            final BlockVector blockVector = new BlockVector(location.getX(), location.getY(), location.getZ());
            final BlockData blockData = Material.PACKED_ICE.createBlockData();
            if (this.plugin.mcVersion >= 1.16) {
                world.playSound(location, Sound.BLOCK_RESPAWN_ANCHOR_SET_SPAWN, SoundCategory.HOSTILE, 1.0f, 0.6f);
            }
            world.playSound(location, Sound.ENTITY_RAVAGER_ROAR, SoundCategory.HOSTILE, 2.0f, 0.5f);
            new RepeatingTask(this.plugin, 10, 5){

                @Override
                public void run() {
                    if (!armorStand.isDead()) {
                        armorStand.remove();
                        if (livingEntity != null) {
                            Yeti.this.entity.setTarget(livingEntity);
                        }
                    }
                    nArray[0] = nArray[0] + 1;
                    int n = -nArray[0];
                    while (n < nArray[0]) {
                        int n2 = -nArray[0];
                        while (n2 < nArray[0]) {
                            block14: {
                                Block block;
                                block16: {
                                    int n3;
                                    block15: {
                                        Vector vector = blockVector.clone().add(new Vector(n, 0, n2));
                                        block = world.getBlockAt(vector.toLocation(world));
                                        if (!(blockVector.distance(vector) >= (double)(nArray[0] - 1)) || !(blockVector.distance(vector) <= (double)nArray[0])) break block14;
                                        if (!block.isPassable()) break block15;
                                        n3 = 0;
                                        while (n3 < 3) {
                                            if (!(block = block.getRelative(BlockFace.DOWN)).isPassable()) break;
                                            ++n3;
                                        }
                                        if (block.isPassable()) break block14;
                                        block = block.getRelative(BlockFace.UP);
                                        break block16;
                                    }
                                    n3 = 0;
                                    while (n3 < 3) {
                                        if ((block = block.getRelative(BlockFace.UP)).isPassable()) break;
                                        ++n3;
                                    }
                                    if (!block.isPassable()) break block14;
                                }
                                world.spawnParticle(Particle.SNOW_SHOVEL, block.getLocation().clone().add(0.5, 0.5, 0.5), 20, 0.3, 0.5, 0.3, 0.001);
                                world.spawnParticle(Particle.BLOCK_CRACK, block.getLocation().clone().add(0.5, 0.5, 0.5), 3, 0.3, 0.5, 0.3, 0.001, (Object)blockData);
                                if (block.getType() == Material.FIRE) {
                                    block.setType(Material.AIR);
                                    world.playSound(block.getLocation(), Sound.BLOCK_FIRE_EXTINGUISH, SoundCategory.BLOCKS, 1.0f, 1.0f);
                                    world.spawnParticle(Particle.SMOKE_LARGE, block.getLocation().clone().add(0.5, 0.2, 0.5), 5, 0.3, 0.5, 0.3, 0.001);
                                }
                                if (((Yeti)Yeti.this).plugin.mcVersion >= 1.17) {
                                    world.playSound(block.getLocation(), Sound.ENTITY_PLAYER_HURT_FREEZE, SoundCategory.HOSTILE, 0.5f, 0.5f);
                                } else {
                                    world.playSound(block.getLocation(), Sound.BLOCK_GLASS_BREAK, SoundCategory.HOSTILE, 0.5f, 1.0f);
                                }
                                for (Entity entity : world.getNearbyEntities(block.getLocation().clone().add(0.5, 0.5, 0.5), 0.5, 1.0, 0.5)) {
                                    if (entity.equals(Yeti.this.entity) || entity.equals(armorStand)) continue;
                                    entity.setVelocity(new Vector(entity.getLocation().getX() - location.getX(), 0.0, entity.getLocation().getZ() - location.getZ()).normalize().multiply(0.2).setY(0.8));
                                    if (!(entity instanceof LivingEntity) || entity instanceof Player && Utils.isPlayerImmune((Player)entity)) continue;
                                    ((LivingEntity)entity).addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 100, 7, true, false));
                                    if (!(((Yeti)Yeti.this).plugin.mcVersion >= 1.17)) continue;
                                    entity.setFreezeTicks(500);
                                }
                            }
                            ++n2;
                        }
                        ++n;
                    }
                    if (nArray[0] >= 10) {
                        this.cancel();
                    }
                }
            };
        }
    }

    @Override
    public void clean() {
        ArmorStand[] armorStandArray = this.stands;
        int n = this.stands.length;
        int n2 = 0;
        while (n2 < n) {
            ArmorStand armorStand = armorStandArray[n2];
            if (armorStand != null) {
                armorStand.remove();
            }
            ++n2;
        }
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }

    private void spawnStand(int n) {
        World world = this.entity.getWorld();
        Location location = this.entity.getLocation().add(150.0, 100.0, 0.0);
        switch (n) {
            case 0: {
                this.stands[n] = (ArmorStand)world.spawnEntity(location, EntityType.ARMOR_STAND);
                this.equipStand(this.stands[n], CustomHead.YETI.getHead());
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                this.stands[n] = (ArmorStand)world.spawnEntity(location, EntityType.ARMOR_STAND);
                this.equipStand(this.stands[n], Material.SNOW_BLOCK);
                break;
            }
            case 2: {
                this.stands[n] = (ArmorStand)world.spawnEntity(location, EntityType.ARMOR_STAND);
                this.equipStand(this.stands[n], Material.SNOW_BLOCK);
                this.stands[n].setHeadPose(new EulerAngle(0.0, 0.9, 0.4));
                break;
            }
            case 3: {
                this.stands[n] = (ArmorStand)world.spawnEntity(location, EntityType.ARMOR_STAND);
                this.equipStand(this.stands[n], Material.SNOW_BLOCK);
                this.stands[n].setHeadPose(new EulerAngle(0.0, 0.9, -0.4));
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                this.stands[n] = (ArmorStand)world.spawnEntity(location, EntityType.ARMOR_STAND);
                this.equipStand(this.stands[n], Material.PACKED_ICE);
                break;
            }
            case 18: {
                this.stands[n] = (ArmorStand)world.spawnEntity(location, EntityType.ARMOR_STAND);
                this.equipStand(this.stands[n], Material.SNOW_BLOCK);
                this.stands[n].setHeadPose(new EulerAngle(0.4, 0.0, 0.0));
                break;
            }
            default: {
                return;
            }
        }
        this.standUUID[n] = this.stands[n].getUniqueId();
        this.stands[n].getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
    }

    private void equipStand(ArmorStand armorStand, Material material) {
        this.lockStand(armorStand);
        armorStand.getEquipment().setHelmet(new ItemStack(material));
    }

    private void equipStand(ArmorStand armorStand, ItemStack itemStack) {
        this.lockStand(armorStand);
        armorStand.getEquipment().setHelmet(itemStack);
    }

    private void lockStand(ArmorStand armorStand) {
        if (this.plugin.mcVersion >= 1.16) {
            armorStand.setInvisible(true);
        } else {
            armorStand.setVisible(false);
        }
        armorStand.setGravity(false);
        armorStand.setArms(true);
        armorStand.setMarker(true);
        if (this.plugin.mcVersion >= 1.16) {
            armorStand.addEquipmentLock(EquipmentSlot.CHEST, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.FEET, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.HEAD, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.LEGS, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.OFF_HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
        }
    }
}

