/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.soulstormentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.entities.EntityHandler;
import deadlydisasters.handlers.ItemsHandler;
import deadlydisasters.handlers.Languages;
import java.util.Iterator;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Vex;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SoulReaper
extends CustomEntity {
    private Random rand;
    public LivingEntity target;
    private Mob vex;
    private UUID vexUUID;
    private boolean neutral;

    public SoulReaper(Mob mob, Main main, Random random) {
        super(mob, main);
        this.entityType = CustomEntityType.SOULREAPER;
        this.species = this.entityType.species;
        mob.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        mob.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        this.rand = random;
        this.vex = (Mob)mob.getWorld().spawnEntity(mob.getLocation(), EntityType.VEX);
        this.vexUUID = this.vex.getUniqueId();
        mob.setMetadata("dd-soulreaper", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)"protected"));
        mob.getEquipment().setHelmet(CustomHead.REAPER.getHead());
        mob.getEquipment().setItemInMainHand(ItemsHandler.soulRipper);
        mob.getEquipment().setItemInMainHandDropChance(0.0f);
        mob.setAI(false);
        mob.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        mob.setHealth(this.entityType.getHealth());
        mob.setCanPickupItems(false);
        this.vex.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
        this.vex.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.5);
        this.vex.setSilent(true);
        this.vex.setInvulnerable(true);
        this.vex.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 999999, 0, true, false));
        this.vex.getEquipment().setItemInMainHand(new ItemStack(Material.AIR));
        this.neutral = (Boolean)this.entityType.grabCustomSetting("neutral_to_players");
        if (this.vex.getCustomName() == null) {
            this.vex.setCustomName(Languages.getString("entities.soulReaper"));
        }
    }

    @Override
    public void tick() {
        if (this.entity == null || this.vex == null) {
            return;
        }
        this.entity.teleport(this.vex.getLocation().subtract(0.0, 0.3, 0.0));
        if (this.plugin.mcVersion >= 1.16) {
            this.vex.getWorld().spawnParticle(Particle.SOUL_FIRE_FLAME, this.vex.getLocation(), 1, 0.2, 0.2, 0.2, 0.04);
        }
        this.vex.getWorld().spawnParticle(Particle.SQUID_INK, this.vex.getLocation().clone().add(0.0, 0.5, 0.0), 8, 0.3, 0.4, 0.3, 0.015);
        if (this.neutral) {
            this.vex.setTarget(this.target);
        }
        this.entity.setRotation(this.vex.getLocation().getYaw(), (float)Math.toRadians(this.vex.getLocation().getPitch()));
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Skeleton)this.plugin.getServer().getEntity(this.entityUUID);
        this.vex = (Mob)this.plugin.getServer().getEntity(this.vexUUID);
        if (this.entity == null || this.vex == null) {
            if (this.vex != null) {
                this.vex.remove();
            }
            iterator.remove();
            return;
        }
        if (this.entity.isDead() || this.vex.isDead()) {
            if (this.plugin.mcVersion >= 1.16) {
                this.vex.getWorld().spawnParticle(Particle.SOUL, this.vex.getLocation().add(0.0, 0.5, 0.0), 15, 0.3, 0.5, 0.3, 0.03);
            }
            this.vex.getWorld().playSound(this.vex.getLocation(), Sound.ENTITY_CREEPER_DEATH, SoundCategory.HOSTILE, 1.5f, 0.5f);
            if (this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            this.vex.remove();
            this.clean();
            iterator.remove();
            return;
        }
        if (this.rand.nextInt(8) == 0) {
            if (this.rand.nextInt(2) == 0) {
                this.vex.getWorld().playSound(this.vex.getLocation(), Sound.ENTITY_VEX_AMBIENT, SoundCategory.HOSTILE, 1.0f, 0.5f);
            } else {
                this.vex.getWorld().playSound(this.vex.getLocation(), Sound.ENTITY_VEX_CHARGE, SoundCategory.HOSTILE, 1.0f, 0.5f);
            }
        }
        if (this.vex.getTarget() == null) {
            for (Entity entity : this.vex.getNearbyEntities(10.0, 10.0, 10.0)) {
                if (!(entity instanceof Vex)) continue;
                this.target = (LivingEntity)entity;
                this.vex.setTarget(this.target);
                break;
            }
        }
    }

    @Override
    public void clean() {
        if (this.vex != null) {
            this.vex.remove();
        }
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }
}

