/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events.disasters;

import deadlydisasters.events.Disaster;
import deadlydisasters.events.WeatherDisaster;
import deadlydisasters.events.WeatherDisasterEvent;
import deadlydisasters.handlers.WorldObject;
import deadlydisasters.listeners.CoreListener;
import deadlydisasters.listeners.DeathMessages;
import deadlydisasters.utils.Metrics;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class ExtremeWinds
extends WeatherDisaster {
    public static Set<Material> bannedBlocks = new HashSet<Material>();
    private double tempForce;
    private double breakForce;
    private Particle particle;
    private int maxParticles;
    private int blocksDestroyed;
    private Queue<Entity> entities = new ArrayDeque<Entity>();
    private ExtremeWinds me = this;

    public ExtremeWinds(int n) {
        super(n);
        this.time = this.configFile.getInt("extremewinds.time.level " + this.level) * 20;
        this.delay = this.configFile.getInt("extremewinds.start_delay") * 20;
        this.tempForce = this.configFile.getDouble("extremewinds.force.level " + n);
        this.particle = Particle.CLOUD;
        this.maxParticles = this.configFile.getInt("extremewinds.max_particles") / 6 * n;
        this.breakForce = this.configFile.getDouble("extremewinds.block_break_force");
        this.volume = this.configFile.getDouble("extremewinds.volume");
        this.type = Disaster.EXTREMEWINDS;
    }

    @Override
    public void start(World world, Player player, boolean bl) {
        WeatherDisasterEvent weatherDisasterEvent = new WeatherDisasterEvent(this, world, this.level, player);
        Bukkit.getPluginManager().callEvent((Event)weatherDisasterEvent);
        if (weatherDisasterEvent.isCancelled()) {
            return;
        }
        this.world = world;
        this.updateWeatherSettings();
        ongoingDisasters.add(this.me);
        DeathMessages.extremewinds.add(this);
        if (bl && ((Boolean)WorldObject.findWorldObject((World)world).settings.get("event_broadcast")).booleanValue()) {
            String string = Utils.chat(this.configFile.getString("messages.weather.winds.level " + this.level));
            if (this.configFile.getBoolean("messages.disaster_tips")) {
                string = String.valueOf(string) + "\n" + this.type.getTip();
            }
            for (Player player2 : world.getPlayers()) {
                player2.sendMessage(string);
            }
        }
        this.startWinds();
    }

    public void startWinds() {
        final Random random = this.plugin.random;
        final double[] dArray = new double[]{0.0, this.tempForce / 100.0, -(this.tempForce / 3.0), this.tempForce};
        final Vector vector = new Vector(random.nextDouble() - 0.5, 0.0, random.nextDouble() - 0.5).normalize().setY(Math.min(this.tempForce * 4.5, 0.5));
        final Vector vector2 = vector.clone().multiply(-1).setY(0);
        final int n = (8 - this.level) * 10;
        final int n2 = n / 2;
        final int n3 = this.configFile.getInt("extremewinds.interior_height_distance");
        final boolean bl = this.plugin.CProtect;
        final FixedMetadataValue fixedMetadataValue = new FixedMetadataValue((Plugin)this.plugin, (Object)"protected");
        final ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.world.getEntities());
        int[] nArray = new int[3];
        nArray[0] = arrayList.size() - 1;
        nArray[1] = arrayList.size() / 20;
        final int[] nArray2 = nArray;
        new RepeatingTask(this.plugin, this.delay, 1){

            @Override
            public void run() {
                Location location;
                if (ExtremeWinds.this.time <= 0) {
                    ongoingDisasters.remove(ExtremeWinds.this.me);
                    ExtremeWinds.this.triggerRegen(true);
                    this.cancel();
                    DeathMessages.extremewinds.remove(ExtremeWinds.this.me);
                    Metrics.incrementValue(Metrics.disasterDestroyedMap, ExtremeWinds.this.type.getMetricsLabel(), ExtremeWinds.this.blocksDestroyed);
                    return;
                }
                ExtremeWinds extremeWinds = ExtremeWinds.this;
                extremeWinds.time = extremeWinds.time - 1;
                dArray[0] = dArray[0] + dArray[1];
                if (dArray[1] > 0.0 && dArray[0] > dArray[3] || dArray[1] < 0.0 && dArray[0] < dArray[2]) {
                    dArray[1] = dArray[1] * -1.0;
                }
                Vector vector4 = vector.clone().multiply(dArray[0]);
                Vector vector22 = vector4.clone().multiply(-1).setY(0).multiply(dArray[0] * 700.0);
                Vector vector3 = vector4.clone().setY(vector4.getY() / 2.0).multiply(10);
                if (dArray[0] > 0.0) {
                    for (Entity entity : ExtremeWinds.this.entities) {
                        if (entity instanceof LivingEntity) {
                            entity.setVelocity(entity.getVelocity().setY(Math.min(entity.getVelocity().getY(), 0.35)).add(vector4));
                            continue;
                        }
                        entity.setVelocity(vector3);
                    }
                    for (Entity entity : ExtremeWinds.this.world.getPlayers()) {
                        if (entity.getLocation().getBlockY() <= 50) continue;
                        location = entity.getLocation();
                        int n5 = 0;
                        while (n5 < ExtremeWinds.this.maxParticles) {
                            entity.spawnParticle(ExtremeWinds.this.particle, random.nextDouble() * (double)n - (double)n2 + location.getX() + vector22.getX(), random.nextDouble() * (double)n - (double)(n / 4) + location.getY(), random.nextDouble() * (double)n - (double)n2 + location.getZ() + vector22.getZ(), 0, vector4.getX(), 0.001, vector4.getZ(), dArray[0] * 150.0);
                            ++n5;
                        }
                        if (nArray2[2] != 0) continue;
                        if (ExtremeWinds.this.entities.contains(entity)) {
                            entity.playSound(entity.getLocation().clone().add(vector4), Sound.WEATHER_RAIN, (float)(dArray[0] * 5.0 * ExtremeWinds.this.volume), 0.5f);
                        } else {
                            entity.playSound(entity.getLocation().clone().add(0.0, 2.0, 0.0), Sound.WEATHER_RAIN_ABOVE, (float)(dArray[0] * ExtremeWinds.this.volume), 0.5f);
                        }
                        if (!(dArray[0] > ExtremeWinds.this.breakForce)) continue;
                        Block block = location.clone().add(0.0, 2.0, 0.0).getBlock();
                        if (!block.getType().isSolid()) {
                            block = location.clone().add((double)(random.nextInt(8) - 4), (double)(random.nextInt(5) - 1), (double)(random.nextInt(8) - 4)).getBlock();
                        }
                        if (!block.getType().isSolid() || Utils.passStrengthTest(block.getType()) || Utils.isZoneProtected(block.getLocation())) continue;
                        if (bl) {
                            Utils.getCoreProtect().logRemoval("Deadly-Disasters", block.getLocation(), block.getType(), block.getBlockData());
                        }
                        FallingBlock fallingBlock = ExtremeWinds.this.world.spawnFallingBlock(block.getLocation().clone().add(0.5, 0.5, 0.5), block.getBlockData());
                        fallingBlock.setDropItem(false);
                        fallingBlock.setHurtEntities(true);
                        fallingBlock.setMetadata("dd-fb", (MetadataValue)fixedMetadataValue);
                        ExtremeWinds.this.entities.add((Entity)fallingBlock);
                        if (block.getState() instanceof InventoryHolder) {
                            CoreListener.addBlockInventory((Entity)fallingBlock, ((InventoryHolder)block.getState()).getInventory().getContents());
                        }
                        ExtremeWinds.this.addBlockWithTopToList(block, block.getState());
                        block.setType(Material.AIR);
                        EntityChangeBlockEvent entityChangeBlockEvent = new EntityChangeBlockEvent((Entity)fallingBlock, block, Material.AIR.createBlockData());
                        Bukkit.getPluginManager().callEvent((Event)entityChangeBlockEvent);
                        ++ExtremeWinds.this.blocksDestroyed;
                    }
                }
                int n6 = nArray2[0];
                while (n6 > nArray2[0] - nArray2[1]) {
                    block27: {
                        if (n6 < 0) break;
                        Entity entity = (Entity)arrayList.get(n6);
                        if (entity == null) {
                            arrayList.remove(n6);
                        } else {
                            location = entity.getLocation();
                            if (location.getBlockY() < 57 || Utils.isZoneProtected(location) || location.getBlockY() <= 63 && location.getBlock().isLiquid()) {
                                arrayList.remove(n6);
                            } else if (entity instanceof LivingEntity) {
                                if (location.getBlock().getLightFromBlocks() >= 9) {
                                    Block block = location.clone().add(0.0, 2.0, 0.0).getBlock();
                                    int n22 = 0;
                                    while (n22 < n3) {
                                        if (block.getType().isSolid() && !bannedBlocks.contains(block.getType())) {
                                            arrayList.remove(n6);
                                            break block27;
                                        }
                                        block = block.getRelative(BlockFace.UP);
                                        ++n22;
                                    }
                                }
                                int n32 = 0;
                                while (n32 < 5) {
                                    block28: {
                                        Block block = location.add(vector2).getBlock();
                                        if (block.getType().isSolid() && !bannedBlocks.contains(block.getType())) {
                                            int n4 = 0;
                                            while (n4 < n32) {
                                                if ((block = block.getRelative(BlockFace.UP)).getType().isSolid() && !bannedBlocks.contains(block.getType())) {
                                                    ++n4;
                                                    continue;
                                                }
                                                break block28;
                                            }
                                            arrayList.remove(n6);
                                            break block27;
                                        }
                                    }
                                    ++n32;
                                }
                                if (entity instanceof Player && ((Player)entity).isFlying()) {
                                    arrayList.remove(n6);
                                }
                            }
                        }
                    }
                    --n6;
                }
                nArray2[0] = nArray2[0] - nArray2[1];
                if (nArray2[0] <= 0) {
                    ExtremeWinds.this.entities.clear();
                    ExtremeWinds.this.entities.addAll(arrayList);
                    arrayList.clear();
                    arrayList.addAll(ExtremeWinds.this.world.getEntities());
                    nArray2[1] = arrayList.size() / 20;
                    nArray2[0] = arrayList.size() - 1;
                }
                nArray2[2] = nArray2[2] < 5 ? nArray2[2] + 1 : 0;
            }
        };
    }

    @Override
    public void clear() {
        this.time = 0;
    }

    public boolean isEntityInvolved(UUID uUID) {
        return this.entities.stream().anyMatch(entity -> entity.getUniqueId().equals(uUID));
    }

    public double getTempForce() {
        return this.tempForce;
    }

    public void setTempForce(double d) {
        this.tempForce = d;
    }

    public Particle getParticle() {
        return this.particle;
    }

    public void setParticle(Particle particle) {
        this.particle = particle;
    }

    public int getMaxParticles() {
        return this.maxParticles;
    }

    public void setMaxParticles(int n) {
        this.maxParticles = n;
    }

    public double getBreakForce() {
        return this.breakForce;
    }

    public void setBreakForce(double d) {
        this.breakForce = d;
    }
}

