/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events.disasters;

import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.soulstormentities.LostSoul;
import deadlydisasters.entities.soulstormentities.SoulReaper;
import deadlydisasters.events.Disaster;
import deadlydisasters.events.WeatherDisaster;
import deadlydisasters.events.WeatherDisasterEvent;
import deadlydisasters.handlers.WorldObject;
import deadlydisasters.listeners.DeathMessages;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vex;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SoulStorm
extends WeatherDisaster {
    private SoulStorm obj;
    private boolean spawnVex;
    private double version;
    private Queue<UUID> souls = new ArrayDeque<UUID>();

    public SoulStorm(int n) {
        super(n);
        this.obj = this;
        this.spawnVex = this.configFile.getBoolean("soulstorm.spawn_souls");
        this.time = this.configFile.getInt("soulstorm.time.level " + this.level) * 20;
        this.delay = this.configFile.getInt("soulstorm.start_delay") * 20;
        this.volume = this.configFile.getDouble("soulstorm.volume");
        this.version = this.plugin.mcVersion;
        this.type = Disaster.SOULSTORM;
    }

    @Override
    public void start(final World world, Player player, boolean bl) {
        WeatherDisasterEvent weatherDisasterEvent = new WeatherDisasterEvent(this, world, this.level, player);
        Bukkit.getPluginManager().callEvent((Event)weatherDisasterEvent);
        if (weatherDisasterEvent.isCancelled()) {
            return;
        }
        this.world = world;
        this.updateWeatherSettings();
        if (bl && ((Boolean)WorldObject.findWorldObject((World)world).settings.get("event_broadcast")).booleanValue()) {
            Utils.broadcastEvent(this.level, "weather", this.type, world);
        }
        DeathMessages.soulstorms.add(this);
        final Random random = new Random();
        final Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)170, (int)228, (int)255), 1.0f);
        new RepeatingTask(this.plugin, this.delay, 5){

            @Override
            public void run() {
                if (SoulStorm.this.time > 0) {
                    for (Player player2 : world.getPlayers()) {
                        Location location = player2.getLocation();
                        if (player2.getGameMode().equals((Object)GameMode.CREATIVE) || player2.getGameMode().equals((Object)GameMode.SPECTATOR) || Utils.isWeatherDisabled(location, SoulStorm.this.obj)) continue;
                        player2.removePotionEffect(PotionEffectType.BLINDNESS);
                        player2.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40, 1, true));
                        if (SoulStorm.this.version >= 1.16) {
                            player2.spawnParticle(Particle.ASH, location.getX(), location.getY() + 1.0, location.getZ(), 30, 1.0, 1.0, 1.0, 1.0);
                            player2.spawnParticle(Particle.WHITE_ASH, location.getX(), location.getY() + 1.0, location.getZ(), 30, 1.0, 1.0, 1.0, 1.0);
                            player2.spawnParticle(Particle.WARPED_SPORE, location.getX(), location.getY() + 1.0, location.getZ(), 30, 1.0, 1.0, 1.0, 1.0);
                            player2.spawnParticle(Particle.SOUL, location.getX(), location.getY() + 1.0, location.getZ(), 2, 2.0, 1.0, 2.0, 0.001);
                            if (random.nextInt(8) == 0) {
                                player2.spawnParticle(Particle.FLASH, location.getX(), location.getY() + 1.0, location.getZ(), 1, 1.0, 1.0, 1.0, 1.0);
                            }
                        } else {
                            player2.spawnParticle(Particle.SQUID_INK, location.getX(), location.getY() + 2.0, location.getZ(), 5, 2.0, 1.0, 2.0, 0.1);
                            player2.spawnParticle(Particle.REDSTONE, location.getX(), location.getY() + 1.0, location.getZ(), 30, 2.0, 1.0, 2.0, 0.1, (Object)dustOptions);
                        }
                        player2.playSound(new Location(player2.getWorld(), player2.getLocation().getX(), player2.getLocation().getY() + 3.0, player2.getLocation().getZ()), Sound.WEATHER_RAIN_ABOVE, (float)(0.017 * SoulStorm.this.volume), 0.5f);
                    }
                    SoulStorm soulStorm = SoulStorm.this;
                    soulStorm.time = soulStorm.time - 5;
                } else {
                    DeathMessages.soulstorms.remove(SoulStorm.this.obj);
                    if (SoulStorm.this.version >= 1.16) {
                        world.getPlayers().stream().forEach(player -> player.stopSound(Sound.AMBIENT_SOUL_SAND_VALLEY_LOOP));
                    }
                    this.cancel();
                }
            }
        };
        final boolean bl2 = (Boolean)WorldObject.findWorldObject((World)world).settings.get("custom_mob_spawning");
        new RepeatingTask(this.plugin, this.delay + 100, 80){

            @Override
            public void run() {
                if (SoulStorm.this.time > 0) {
                    block0: for (Player player : world.getPlayers()) {
                        if (SoulStorm.this.version >= 1.16) {
                            player.playSound(new Location(player.getWorld(), player.getLocation().getX(), player.getLocation().getY() + 3.0, player.getLocation().getZ()), Sound.AMBIENT_SOUL_SAND_VALLEY_LOOP, (float)(1.0 * SoulStorm.this.volume), 0.5f);
                            player.playSound(new Location(player.getWorld(), player.getLocation().getX(), player.getLocation().getY() + 3.0, player.getLocation().getZ()), Sound.AMBIENT_SOUL_SAND_VALLEY_ADDITIONS, (float)(1.0 * SoulStorm.this.volume), 0.5f);
                        }
                        if (random.nextInt(4) != 0 || player.getGameMode().equals((Object)GameMode.CREATIVE) || player.getGameMode().equals((Object)GameMode.SPECTATOR) || Utils.isWeatherDisabled(player.getLocation(), SoulStorm.this.obj)) continue;
                        if (SoulStorm.this.version >= 1.16) {
                            player.playSound(new Location(player.getWorld(), player.getLocation().getX(), player.getLocation().getY() + 3.0, player.getLocation().getZ()), Sound.AMBIENT_SOUL_SAND_VALLEY_MOOD, (float)(1.0 * SoulStorm.this.volume), 0.75f);
                        }
                        if (!SoulStorm.this.spawnVex) continue;
                        Location location = player.getLocation();
                        int n = location.getBlockX() - 2;
                        while (n < location.getBlockX() + 2) {
                            int n2 = location.getBlockZ() - 2;
                            while (n2 < location.getBlockZ() + 2) {
                                Location location2 = player.getLocation();
                                location2.setX((double)n);
                                location2.setY((double)(location.getBlockY() + 4));
                                location2.setZ((double)n2);
                                Block block = location2.getBlock();
                                if (block.getType() == Material.AIR) {
                                    Vex vex = (Vex)world.spawnEntity(location2, EntityType.VEX);
                                    if (bl2) {
                                        if (random.nextInt(100) < 3 && CustomEntityType.SOULREAPER.canSpawn()) {
                                            vex.remove();
                                            Mob mob = (Mob)world.spawnEntity(location2, EntityType.SKELETON);
                                            SoulStorm.this.plugin.handler.addEntity(new SoulReaper(mob, SoulStorm.this.plugin, random));
                                            SoulStorm.this.souls.add(mob.getUniqueId());
                                            continue block0;
                                        }
                                        if (CustomEntityType.LOSTSOUL.canSpawn()) {
                                            SoulStorm.this.plugin.handler.addEntity(new LostSoul((Mob)vex, SoulStorm.this.plugin, random));
                                        }
                                    }
                                    vex.setTarget((LivingEntity)player);
                                    SoulStorm.this.souls.add(vex.getUniqueId());
                                    continue block0;
                                }
                                ++n2;
                            }
                            ++n;
                        }
                    }
                } else {
                    SoulStorm.this.clearEntities();
                    this.cancel();
                }
            }
        };
    }

    @Override
    public void clear() {
        this.time = 0;
        this.clearEntities();
        DeathMessages.soulstorms.remove(this);
    }

    public void clearEntities() {
        for (UUID uUID : this.souls) {
            if (Bukkit.getEntity((UUID)uUID) == null) continue;
            Bukkit.getEntity((UUID)uUID).remove();
        }
    }

    public boolean canVexSpawn() {
        return this.spawnVex;
    }

    public void setVexSpawn(boolean bl) {
        this.spawnVex = bl;
    }
}

