/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events.disasters;

import deadlydisasters.events.DestructionDisaster;
import deadlydisasters.events.DestructionDisasterEvent;
import deadlydisasters.events.Disaster;
import deadlydisasters.listeners.DeathMessages;
import deadlydisasters.utils.Metrics;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public class Tsunami
extends DestructionDisaster
implements Listener {
    private int depth;
    private int current;
    private int radius;
    private int height;
    private boolean clean;
    private boolean stopPush;
    private double damage;
    private int tickSpeed = 2;
    private boolean removeWater;
    private Particle particleType;
    private boolean ignoreOcean;
    private Material liquid;
    private BlockData[] materials;
    private int blocksDestroyed;
    private Map<Block, Integer> waterBlocks = new HashMap<Block, Integer>();
    private Map<Integer, Queue<Block>> blocksMap = new HashMap<Integer, Queue<Block>>();
    private Set<Block> cleanMap = new LinkedHashSet<Block>();
    private Queue<FallingBlock> debris = new ArrayDeque<FallingBlock>();

    public Tsunami(int n) {
        super(n);
        this.depth = this.configFile.getInt("tsunami.minimum_depth");
        this.damage = this.configFile.getInt("tsunami.damage");
        this.radius = (int)((double)(15 * n) * this.configFile.getDouble("tsunami.size"));
        this.height = n * 3;
        this.removeWater = this.configFile.getBoolean("tsunami.remove_water");
        this.volume = this.configFile.getDouble("tsunami.volume");
        this.particleType = Particle.WATER_BUBBLE;
        this.liquid = Material.WATER;
        this.materials = new BlockData[]{Material.SAND.createBlockData(), Material.DIRT.createBlockData()};
        this.type = Disaster.TSUNAMI;
    }

    @Override
    public void start(Location location, Player player) {
        DestructionDisasterEvent destructionDisasterEvent = new DestructionDisasterEvent(this, location, this.level, player);
        Bukkit.getPluginManager().callEvent((Event)destructionDisasterEvent);
        if (destructionDisasterEvent.isCancelled()) {
            return;
        }
        this.loc = location;
        ongoingDisasters.add(this);
        this.world = this.loc.getWorld();
        this.current = this.level;
        final Random random = new Random();
        DeathMessages.tsunamis.add(this);
        final Tsunami tsunami = this;
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        final int[] nArray = new int[2];
        final int n = this.level * this.level;
        final Location location2 = this.loc.clone();
        new RepeatingTask(this.plugin, 0, 1){

            @Override
            public void run() {
                nArray[0] = nArray[0] + 1;
                ArrayDeque<Block> arrayDeque = new ArrayDeque<Block>();
                Tsunami.this.blocksMap.put(nArray[0], arrayDeque);
                if (nArray[0] < Tsunami.this.height) {
                    BlockVector blockVector = new BlockVector(Tsunami.this.loc.getX(), Tsunami.this.loc.getY(), Tsunami.this.loc.getZ());
                    int n6 = -Tsunami.this.level;
                    while (n6 < Tsunami.this.level) {
                        int n2 = -Tsunami.this.level;
                        while (n2 < Tsunami.this.level) {
                            Vector vector = blockVector.clone().add(new Vector(n6, 0, n2));
                            Block block = Tsunami.this.world.getBlockAt(vector.toLocation(Tsunami.this.world));
                            if (block.getType() == Material.AIR && !(blockVector.distanceSquared(vector) > (double)n)) {
                                arrayDeque.add(block);
                                Tsunami.this.waterBlocks.put(block, nArray[0]);
                            }
                            ++n2;
                        }
                        ++n6;
                    }
                    Tsunami.this.loc.setY(Tsunami.this.loc.getY() + 1.0);
                    return;
                }
                int n7 = nArray[0];
                while (n7 < Tsunami.this.radius + nArray[0] + 1) {
                    Tsunami.this.blocksMap.put(n7, new ArrayDeque());
                    ++n7;
                }
                BlockVector blockVector = new BlockVector(Tsunami.this.loc.getX(), Tsunami.this.loc.getY(), Tsunami.this.loc.getZ());
                int n3 = -Tsunami.this.radius;
                while (n3 < Tsunami.this.radius) {
                    int n4 = -Tsunami.this.radius;
                    while (n4 < Tsunami.this.radius) {
                        Vector vector = blockVector.clone().add(new Vector(n3, 0, n4));
                        Block block = Tsunami.this.world.getBlockAt(vector.toLocation(Tsunami.this.world));
                        double d = blockVector.distance(vector);
                        if (block.getType() == Material.AIR && !(d > (double)Tsunami.this.radius)) {
                            int n5 = (int)d + nArray[0];
                            Tsunami.this.blocksMap.get(n5).add(block);
                            Tsunami.this.waterBlocks.put(block, n5);
                        }
                        ++n4;
                    }
                    ++n3;
                }
                this.cancel();
                new RepeatingTask(Tsunami.this.plugin, 0, Tsunami.this.tickSpeed){

                    @Override
                    public void run() {
                        (this).Tsunami.this.current = nArray[1];
                        if (nArray[1] >= nArray[0] + (this).Tsunami.this.radius) {
                            this.cancel();
                            (this).Tsunami.this.clean = true;
                            if (!(this).Tsunami.this.removeWater) {
                                HandlerList.unregisterAll((Listener)tsunami);
                                DeathMessages.tsunamis.remove(tsunami);
                                ongoingDisasters.remove(tsunami);
                                Tsunami.this.triggerRegen(true);
                                Metrics.incrementValue(Metrics.disasterDestroyedMap, (this).Tsunami.this.type.getMetricsLabel(), (this).Tsunami.this.blocksDestroyed);
                                return;
                            }
                            new RepeatingTask((this).Tsunami.this.plugin, 80, 3){

                                @Override
                                public void run() {
                                    ((this).this).Tsunami.this.current = nArray[1];
                                    if (nArray[1] <= 0) {
                                        this.cancel();
                                        new RepeatingTask(((this).this).Tsunami.this.plugin, 0, 1){

                                            @Override
                                            public void run() {
                                                if ((((this).this).this).Tsunami.this.cleanMap.isEmpty()) {
                                                    this.cancel();
                                                    HandlerList.unregisterAll((Listener)tsunami);
                                                    return;
                                                }
                                                Iterator<Block> iterator = (((this).this).this).Tsunami.this.cleanMap.iterator();
                                                int n = 0;
                                                while (n < 30) {
                                                    if (!iterator.hasNext()) {
                                                        return;
                                                    }
                                                    Block block = iterator.next();
                                                    if (block.isLiquid() && !Utils.isZoneProtected(block.getLocation())) {
                                                        block.setType(Material.AIR);
                                                    }
                                                    iterator.remove();
                                                    ++n;
                                                }
                                            }
                                        };
                                        DeathMessages.tsunamis.remove(tsunami);
                                        ongoingDisasters.remove(tsunami);
                                        Tsunami.this.triggerRegen(true);
                                        Metrics.incrementValue(Metrics.disasterDestroyedMap, ((this).this).Tsunami.this.type.getMetricsLabel(), ((this).this).Tsunami.this.blocksDestroyed);
                                        ((this).this).Tsunami.this.stopPush = true;
                                        return;
                                    }
                                    for (Block block : ((this).this).Tsunami.this.blocksMap.get(nArray[1])) {
                                        if (!block.isLiquid()) continue;
                                        block.setType(Material.AIR);
                                    }
                                    nArray[1] = nArray[1] - 1;
                                }
                            };
                            return;
                        }
                        nArray[1] = nArray[1] + 1;
                        for (Block block : (this).Tsunami.this.blocksMap.get(nArray[1])) {
                            if (Utils.passStrengthTest(block.getType()) || Utils.isZoneProtected(block.getLocation())) continue;
                            block.setType((this).Tsunami.this.liquid);
                            ++(this).Tsunami.this.blocksDestroyed;
                            if ((this).Tsunami.this.plugin.random.nextInt(nArray[1]) != 0) continue;
                            (this).Tsunami.this.world.spawnParticle((this).Tsunami.this.particleType, block.getLocation().clone().subtract(0.0, 0.5, 0.0), 5, 0.7, 0.5, 0.7, 0.1);
                        }
                    }
                };
                final double d = 2.0 / (double)(Tsunami.this.radius + 31);
                new RepeatingTask(Tsunami.this.plugin, 20, 10){

                    @Override
                    public void run() {
                        if ((this).Tsunami.this.stopPush) {
                            this.cancel();
                            return;
                        }
                        int n = Tsunami.this.loc.getBlockY();
                        int n2 = location2.getBlockY() - (this).Tsunami.this.level;
                        for (Entity entity : Tsunami.this.loc.getWorld().getNearbyEntities(location2, (double)(nArray[1] + 25), (double)((this).Tsunami.this.level * 2), (double)(nArray[1] + 25))) {
                            Location location;
                            Vector vector;
                            Location location22 = entity.getLocation();
                            double d2 = location22.distance(location2);
                            if (d2 <= (double)nArray[1] && location22.getBlockY() <= n && location22.getBlockY() >= n2) {
                                if (location22.getBlock().getType() == (this).Tsunami.this.liquid) {
                                    entity.setVelocity(new Vector(location22.getX() - Tsunami.this.loc.getX(), 0.7, location22.getZ() - Tsunami.this.loc.getZ()).normalize().multiply(0.5));
                                    if (entity instanceof LivingEntity) {
                                        Utils.damageEntity((LivingEntity)entity, (this).Tsunami.this.damage, "dd-tsunamideath", false);
                                    }
                                    if (!(entity instanceof Player)) continue;
                                    ((Player)entity).spawnParticle((this).Tsunami.this.particleType, location22, 30, 1.0, 1.5, 1.0, 1.0);
                                    vector = new Location(entity.getWorld(), location22.getX() + (double)random.nextInt(8) - 4.0, location22.getY() + (double)random.nextInt(5) + 1.0, location22.getZ() + (double)random.nextInt(8) - 4.0);
                                    if (!vector.getBlock().isLiquid()) continue;
                                    location = entity.getWorld().spawnFallingBlock((Location)vector, (this).Tsunami.this.materials[random.nextInt((this).Tsunami.this.materials.length)]);
                                    location.setVelocity(Utils.getVectorTowards(location2, location22).multiply(0.5));
                                    location.setMetadata("dd-fb", (MetadataValue)new FixedMetadataValue((Plugin)(this).Tsunami.this.plugin, (Object)"protected"));
                                    (this).Tsunami.this.fallingUUID.add(location.getUniqueId());
                                    (this).Tsunami.this.debris.add((FallingBlock)location);
                                    continue;
                                }
                                if (!(entity instanceof Player)) continue;
                                if (d2 < (double)(nArray[0] - 15)) {
                                    vector = Utils.getVectorTowards(location2, location22);
                                    location = location2.clone().add(vector.clone().multiply(d2 - 6.0));
                                    location.setY(location22.getY() + (double)random.nextInt(5) - 1.0);
                                    if (!location.getBlock().isLiquid()) continue;
                                    FallingBlock fallingBlock = entity.getWorld().spawnFallingBlock(location.add(new Vector(vector.getZ(), 0.0, -vector.getX()).multiply(random.nextInt(8) - 4)), (this).Tsunami.this.materials[random.nextInt((this).Tsunami.this.materials.length)]);
                                    fallingBlock.setVelocity(vector.multiply(0.75).setY(0.2));
                                    ((Player)entity).spawnParticle((this).Tsunami.this.particleType, location, 20, 2.0, 1.5, 2.0, 1.0);
                                    fallingBlock.setMetadata("dd-fb", (MetadataValue)new FixedMetadataValue((Plugin)(this).Tsunami.this.plugin, (Object)"protected"));
                                    (this).Tsunami.this.fallingUUID.add(fallingBlock.getUniqueId());
                                    (this).Tsunami.this.debris.add(fallingBlock);
                                    continue;
                                }
                                vector = Utils.getVectorTowards(location2, location22);
                                location = location2.clone().add(vector.clone().multiply(Math.max(nArray[1] - (this).Tsunami.this.height * 2, 1)));
                                location.setY(location2.getY() + (Tsunami.this.loc.getY() - location2.getY()) / 3.0 * 2.0);
                                int n3 = Math.min(Math.max(nArray[1] - 10, 1), 15);
                                int n4 = 0;
                                while (n4 < 3) {
                                    location.add(new Vector(vector.getZ(), 0.0, -vector.getX()).multiply(random.nextInt(n3 * 2) - n3));
                                    if (location.getBlock().isLiquid()) {
                                        FallingBlock fallingBlock = entity.getWorld().spawnFallingBlock(location, (this).Tsunami.this.materials[random.nextInt((this).Tsunami.this.materials.length)]);
                                        fallingBlock.setVelocity(vector.multiply(0.75).setY(0.2));
                                        ((Player)entity).spawnParticle((this).Tsunami.this.particleType, location, 20, 2.0, 1.5, 2.0, 1.0);
                                        fallingBlock.setMetadata("dd-fb", (MetadataValue)new FixedMetadataValue((Plugin)(this).Tsunami.this.plugin, (Object)"protected"));
                                        (this).Tsunami.this.fallingUUID.add(fallingBlock.getUniqueId());
                                        (this).Tsunami.this.debris.add(fallingBlock);
                                    }
                                    ++n4;
                                }
                                continue;
                            }
                            if (!(entity instanceof Player)) continue;
                            vector = Utils.getVectorTowards(location2, location22);
                            location = location2.clone().add(vector.clone().multiply(Math.max(nArray[1] - (this).Tsunami.this.height * 2, 1)));
                            location.setY(location2.getY() + (Tsunami.this.loc.getY() - location2.getY()) / 3.0 * 2.0);
                            int n5 = Math.min(Math.max(nArray[1] - 10, 1), 15);
                            location.add(new Vector(vector.getZ(), 0.0, -vector.getX()).multiply(random.nextInt(n5 * 2) - n5));
                            if (!location.getBlock().isLiquid()) continue;
                            FallingBlock fallingBlock = entity.getWorld().spawnFallingBlock(location, (this).Tsunami.this.materials[random.nextInt((this).Tsunami.this.materials.length)]);
                            fallingBlock.setVelocity(vector.multiply(0.75).setY(0.3));
                            ((Player)entity).spawnParticle((this).Tsunami.this.particleType, location, 20, 2.0, 1.5, 2.0, 1.0);
                            fallingBlock.setMetadata("dd-fb", (MetadataValue)new FixedMetadataValue((Plugin)(this).Tsunami.this.plugin, (Object)"protected"));
                            (this).Tsunami.this.fallingUUID.add(fallingBlock.getUniqueId());
                            (this).Tsunami.this.debris.add(fallingBlock);
                        }
                        for (Entity entity : Tsunami.this.loc.getWorld().getPlayers()) {
                            double d3 = entity.getLocation().distance(location2);
                            if (!(d3 <= (double)(nArray[1] + 30))) continue;
                            entity.playSound(entity.getLocation().add(Utils.getVectorTowards(entity.getLocation(), Tsunami.this.loc).multiply(4.0)), Sound.WEATHER_RAIN_ABOVE, (float)(d * ((double)(this).Tsunami.this.radius - (d3 - (double)nArray[1])) * (this).Tsunami.this.volume), 0.5f);
                        }
                    }
                };
                new RepeatingTask(Tsunami.this.plugin, 0, 2){

                    @Override
                    public void run() {
                        if ((this).Tsunami.this.stopPush) {
                            this.cancel();
                            return;
                        }
                        Iterator iterator = (this).Tsunami.this.debris.iterator();
                        while (iterator.hasNext()) {
                            FallingBlock fallingBlock = (FallingBlock)iterator.next();
                            if (fallingBlock == null || fallingBlock.isDead()) {
                                iterator.remove();
                                continue;
                            }
                            for (Entity entity : (this).Tsunami.this.world.getNearbyEntities(fallingBlock.getLocation().add(0.5, 0.5, 0.5), 0.8, 0.8, 0.8)) {
                                if (!(entity instanceof LivingEntity)) continue;
                                if (entity instanceof Player) {
                                    if (Utils.isPlayerImmune((Player)entity)) continue;
                                    if ((this).Tsunami.this.plugin.achievementsHandler.isMasteryActive(entity.getUniqueId(), "disasters.survival.cavein")) {
                                        entity.setVelocity(fallingBlock.getVelocity().multiply(2.0));
                                        Utils.damageEntity((LivingEntity)entity, (this).Tsunami.this.damage - (this).Tsunami.this.damage / 100.0 * (this).Tsunami.this.plugin.achievementsHandler.getMasteryPower(entity.getUniqueId(), "disasters.survival.cavein"), "dd-tsunamideath", false);
                                        continue;
                                    }
                                }
                                entity.setVelocity(fallingBlock.getVelocity().multiply(2.0));
                                Utils.damageEntity((LivingEntity)entity, (this).Tsunami.this.damage, "dd-tsunamideath", false);
                            }
                        }
                    }
                };
            }
        };
    }

    @EventHandler
    public void onWaterSpread(BlockFromToEvent blockFromToEvent) {
        if (this.waterBlocks.containsKey(blockFromToEvent.getBlock()) || this.cleanMap.contains(blockFromToEvent.getBlock())) {
            if (this.clean) {
                this.cleanMap.add(blockFromToEvent.getToBlock());
                return;
            }
            int n = this.waterBlocks.get(blockFromToEvent.getBlock());
            this.blocksMap.get(n).add(blockFromToEvent.getToBlock());
            this.waterBlocks.put(blockFromToEvent.getToBlock(), n);
        }
    }

    public Location findAvailabePool(Location location) {
        int n;
        if (this.hasXAmountLiquid(this.depth, location)) {
            n = location.getBlockY();
            while (n > 0) {
                location.setY((double)n);
                if (location.getBlock().getType() == this.liquid) break;
                --n;
            }
            if (!Utils.isZoneProtected(location)) {
                return location.add(0.0, 1.0, 0.0);
            }
        }
        n = -2;
        while (n < 3) {
            int n2 = -2;
            while (n2 < 3) {
                Location location2 = location.getWorld().getChunkAt(location.getChunk().getX() + n, location.getChunk().getZ() + n2).getBlock(5, location.getBlockY(), 5).getLocation();
                if (this.hasXAmountLiquid(this.depth, location2)) {
                    int n3 = location2.getBlockY();
                    while (n3 > 0) {
                        location2.setY((double)n3);
                        if (location2.getBlock().getType() == this.liquid) {
                            location2.setY(location2.getY() + 1.0);
                            break;
                        }
                        --n3;
                    }
                    if (!Utils.isZoneProtected(location)) {
                        return location2.add(0.0, 1.0, 0.0);
                    }
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    private boolean hasXAmountLiquid(int n, Location location) {
        int n2 = 0;
        Block block = location.getBlock();
        int n3 = location.getBlockY();
        while (n3 > 0) {
            if (block.getType() == this.liquid) {
                ++n2;
            }
            if (n2 >= n) {
                return true;
            }
            block = block.getRelative(BlockFace.DOWN);
            --n3;
        }
        return false;
    }

    @Override
    public Location findApplicableLocation(Location location, Player player) {
        if ((location = this.findAvailabePool(location.clone())) == null || location.getBlockY() < this.type.getMinHeight()) {
            return null;
        }
        return location;
    }

    @Override
    public void startAdjustment(Location location, Player player) {
        Location location2 = this.findAvailabePool(location.clone());
        if (location2 != null) {
            this.start(location2, player);
            return;
        }
        if (this.ignoreOcean) {
            this.start(location, player);
        }
    }

    @Override
    public Location getLocation() {
        return this.loc;
    }

    public int getCurrent() {
        return this.current;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int n) {
        this.radius = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public double getDamage() {
        return this.damage;
    }

    public void setDamage(double d) {
        this.damage = d;
    }

    public int getTickSpeed() {
        return this.tickSpeed;
    }

    public void setTickSpeed(int n) {
        this.tickSpeed = n;
    }

    public boolean isRemoveWater() {
        return this.removeWater;
    }

    public void setRemoveWater(boolean bl) {
        this.removeWater = bl;
    }

    public Particle getParticleType() {
        return this.particleType;
    }

    public void setParticleType(Particle particle) {
        this.particleType = particle;
    }

    public boolean isIgnoreOcean() {
        return this.ignoreOcean;
    }

    public void setIgnoreOcean(boolean bl) {
        this.ignoreOcean = bl;
    }

    public Material getLiquid() {
        return this.liquid;
    }

    public void setLiquid(Material material) {
        this.liquid = material;
    }

    public BlockData[] getMaterials() {
        return this.materials;
    }

    public void setMaterials(BlockData[] blockDataArray) {
        this.materials = blockDataArray;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int n) {
        this.depth = n;
    }
}

