/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.handlers;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.events.disasters.CaveIn;
import deadlydisasters.handlers.ItemsHandler;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.AsyncRepeatingTask;
import deadlydisasters.utils.ChannelDataHolder;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public class AchievementsHandler
implements Listener {
    private Main plugin;
    private FileConfiguration file;
    public boolean isEnabled;
    public boolean announceToPlayers;
    public boolean broadcastToWorld;
    public boolean notifyPlayers;
    private ItemStack achievementInfo;
    private ItemStack noAchievement;
    private int maxMasteries;
    private String progress;
    private String rewards;
    private List<Achievement> achievementsList = new ArrayList<Achievement>();
    private Map<String, Achievement> achievementMap = new LinkedHashMap<String, Achievement>();
    private List<Mastery> masteriesList = new ArrayList<Mastery>();
    private Map<String, Mastery> masteryMap = new HashMap<String, Mastery>();
    private SurvivalChannel survivalChannel;
    private WeatherSurvivalChannel weatherSurvivalChannel;
    private Map<Inventory, Map<ItemStack, Achievement>> guiAchievements = new HashMap<Inventory, Map<ItemStack, Achievement>>();
    private Map<Inventory, Map<ItemStack, Mastery>> guiMasteries = new HashMap<Inventory, Map<ItemStack, Mastery>>();
    private Set<Player> twisterPlayers = ConcurrentHashMap.newKeySet();

    public AchievementsHandler(Main main) {
        this.plugin = main;
        if (!new File(main.getDataFolder().getAbsolutePath(), "achievements.yml").exists()) {
            this.createFile();
        }
        this.file = YamlConfiguration.loadConfiguration((File)new File(main.getDataFolder().getAbsolutePath(), "achievements.yml"));
        if (!this.file.getBoolean("enabled")) {
            main.getLogger().info("Achievements are disabled!");
            return;
        }
        this.isEnabled = true;
        this.announceToPlayers = this.file.getBoolean("messages.announce_to_player");
        this.broadcastToWorld = this.file.getBoolean("messages.broadcast_to_world");
        this.notifyPlayers = this.file.getBoolean("messages.unclaimed_notify");
        this.maxMasteries = this.file.getInt("masteries.max_enabled");
        this.progress = Languages.getString("words.progress");
        this.rewards = Languages.getString("words.rewards");
        main.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)main);
        this.achievementInfo = Utils.createItem(Material.NETHER_STAR, 1, "&6&lAchievements", Arrays.asList("&bHover above the items below to see your progress towards certain achievements!", " ", "&d&lMasteries &aare earned by progressing through tiers of an achievement, some are upgraded through tier progression. They provide various unique passive effects and abilities. You may have &e" + this.maxMasteries + " &amasteries active at a time.", " ", "&3Some achievements are locked and can't be progressed on while hidden! Although most can."), false, true);
        this.noAchievement = Utils.createItem(Material.BLACK_STAINED_GLASS_PANE, 1, "", null, false, true);
        for (String string : this.file.getConfigurationSection("achievements").getKeys(false)) {
            for (String string2 : this.file.getConfigurationSection("achievements." + string).getKeys(false)) {
                for (String string3 : this.file.getConfigurationSection("achievements." + string + '.' + string2).getKeys(false)) {
                    ArrayList<String> arrayList;
                    Achievement achievement;
                    ItemStack itemStack = null;
                    if (this.file.contains("display." + string + '.' + string2 + '.' + string3)) {
                        if (ItemsHandler.allItems.containsKey(this.file.getString("display." + string + '.' + string2 + '.' + string3 + ".item"))) {
                            itemStack = ItemsHandler.allItems.get(this.file.getString("display." + string + '.' + string2 + '.' + string3 + ".item")).clone();
                        } else {
                            try {
                                itemStack = new ItemStack(Material.valueOf((String)this.file.getString("display." + string + '.' + string2 + '.' + string3 + ".item")));
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                Main.consoleSender.sendMessage(String.valueOf(Languages.prefix) + Utils.chat("&eCould not add item display to achievement &d'" + string3 + "&d' &eno such item &c" + this.file.getString("display." + string + '.' + string2 + '.' + string3 + ".item") + " &eexists!"));
                            }
                        }
                        if (itemStack != null) {
                            if (this.file.contains("display." + string + '.' + string2 + '.' + string3 + ".amount")) {
                                itemStack.setAmount(this.file.getInt("display." + string + '.' + string2 + '.' + string3 + ".amount"));
                            }
                            if ((achievement = itemStack.getItemMeta()).hasLore()) {
                                arrayList = achievement.getLore();
                                arrayList.addAll(Arrays.asList(" ", Utils.chat(this.file.getString("display." + string + '.' + string2 + '.' + string3 + ".description"))));
                                achievement.setLore(arrayList);
                            } else {
                                arrayList = new ArrayList<String>(Arrays.asList(" ", Utils.chat(this.file.getString("display." + string + '.' + string2 + '.' + string3 + ".description"))));
                                achievement.setLore(arrayList);
                            }
                            itemStack.setItemMeta((ItemMeta)achievement);
                        }
                    }
                    achievement = new Achievement("achievements." + string + '.' + string2 + '.' + string3);
                    achievement.displayItem = itemStack;
                    this.achievementMap.put(String.valueOf(string) + '.' + string2 + '.' + string3, achievement);
                    this.achievementsList.add(achievement);
                    if (!this.file.contains("masteries." + string + '.' + string2 + '.' + string3) || !this.file.getBoolean("masteries." + string + '.' + string2 + '.' + string3 + ".enabled")) continue;
                    arrayList = new Mastery("masteries." + string + '.' + string2 + '.' + string3, achievement);
                    achievement.passMastery((Mastery)((Object)arrayList));
                    this.masteryMap.put(String.valueOf(string) + '.' + string2 + '.' + string3, (Mastery)((Object)arrayList));
                    this.masteriesList.add((Mastery)((Object)arrayList));
                }
            }
        }
        this.survivalChannel = new SurvivalChannel(main);
        this.weatherSurvivalChannel = new WeatherSurvivalChannel(main);
        this.startTwisterTimer();
    }

    public void openGUI(Player player, int n2) {
        UUID uUID = player.getUniqueId();
        Inventory inventory = Bukkit.createInventory(null, (int)54, (String)Utils.chat("&9DeadlyDisasters Achievements"));
        inventory.setItem(4, this.achievementInfo);
        HashMap<ItemStack, Achievement> hashMap = new HashMap<ItemStack, Achievement>();
        HashMap<ItemStack, Mastery> hashMap2 = new HashMap<ItemStack, Mastery>();
        int n3 = 0;
        while (n3 < 4) {
            if (n3 + (n2 - 1) * 4 >= this.achievementsList.size()) break;
            Achievement achievement = this.achievementsList.get(n3 + (n2 - 1) * 4);
            int n4 = 0;
            while (n4 < achievement.tiers.length) {
                Achievement achievement2 = achievement.tiers[n4];
                if (n4 > 0 && achievement2.hidden && !achievement2.hasAchieved(uUID) && !achievement.tiers[n4 - 1].hasAchieved(uUID)) {
                    inventory.setItem(n3 * 9 + 9 + n4, achievement.hiddenItem);
                } else {
                    boolean bl = achievement2.hasAchieved(uUID);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(achievement.series);
                    arrayList.add(achievement2.description);
                    arrayList.add(" ");
                    arrayList.add(Utils.chat("&b" + this.progress + ": " + achievement2.getProgress(uUID) + '/' + achievement2.goal));
                    arrayList.add(" ");
                    arrayList.add(Utils.chat("&3" + this.rewards + ":"));
                    achievement2.rewards.forEach((itemStack, n) -> {
                        if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName()) {
                            arrayList.add(Utils.chat("&d" + n + " &8x &6" + itemStack.getItemMeta().getDisplayName().toLowerCase()));
                        } else {
                            arrayList.add(Utils.chat("&d" + n + " &8x &6" + itemStack.getType().toString().toLowerCase().replace('_', ' ')));
                        }
                    });
                    arrayList.add(Utils.chat("&2XP: &a" + achievement2.xp));
                    if (bl && !achievement2.hasClaimed(uUID)) {
                        arrayList.add(" ");
                        arrayList.add(Utils.chat("&b&l" + Languages.getString("internal.claimAchievement")));
                    }
                    ItemStack itemStack2 = Utils.createItem(achievement2.item, achievement2.amount, achievement2.name, arrayList, bl ? !achievement2.hasClaimed(uUID) : false, true);
                    hashMap.put(itemStack2, achievement2);
                    inventory.setItem(n3 * 9 + 9 + n4, itemStack2);
                }
                ++n4;
            }
            n4 = achievement.tiers.length;
            while (n4 < 9) {
                inventory.setItem(n3 * 9 + 9 + n4, this.noAchievement);
                ++n4;
            }
            if (achievement.mastery != null) {
                ItemStack itemStack3 = achievement.mastery.build(uUID);
                hashMap2.put(itemStack3, achievement.mastery);
                inventory.setItem(n3 * 9 + 17, itemStack3);
            } else if (achievement.displayItem != null) {
                inventory.setItem(n3 * 9 + 17, achievement.displayItem);
            }
            ++n3;
        }
        if (n2 > 1) {
            inventory.setItem(45, Utils.createItem(Material.ARROW, n2 - 1, "&aPage " + (n2 - 1), null, false, true));
        }
        if (n2 * 4 < this.achievementsList.size()) {
            inventory.setItem(53, Utils.createItem(Material.ARROW, n2 + 1, "&aPage " + (n2 + 1), null, false, true));
        }
        this.guiAchievements.put(inventory, hashMap);
        this.guiMasteries.put(inventory, hashMap2);
        player.openInventory(inventory);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent playerJoinEvent) {
        if (this.notifyPlayers) {
            UUID uUID = playerJoinEvent.getPlayer().getUniqueId();
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                for (Achievement achievement : this.achievementsList) {
                    Achievement[] achievementArray = achievement.tiers;
                    int n = achievement.tiers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Achievement achievement2 = achievementArray[n2];
                        if (achievement2.hasAchieved(uUID) && !achievement2.hasClaimed(uUID)) {
                            if (playerJoinEvent.getPlayer() != null) {
                                playerJoinEvent.getPlayer().sendMessage(String.valueOf(Languages.prefix) + ChatColor.GREEN + Utils.chat(Languages.getString("internal.notifyUnclaimed")));
                            }
                            return;
                        }
                        ++n2;
                    }
                }
            }, 200L);
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent inventoryClickEvent) {
        if (inventoryClickEvent.getCurrentItem() == null || !this.guiAchievements.containsKey(inventoryClickEvent.getInventory())) {
            return;
        }
        inventoryClickEvent.setCancelled(true);
        if (inventoryClickEvent.getRawSlot() == 45 || inventoryClickEvent.getRawSlot() == 53) {
            String string = inventoryClickEvent.getCurrentItem().getItemMeta().getDisplayName();
            this.openGUI((Player)inventoryClickEvent.getWhoClicked(), Integer.parseInt(string.substring(string.indexOf(32) + 1)));
            return;
        }
        if (this.guiAchievements.get(inventoryClickEvent.getInventory()).containsKey(inventoryClickEvent.getCurrentItem())) {
            Achievement achievement = this.guiAchievements.get(inventoryClickEvent.getInventory()).get(inventoryClickEvent.getCurrentItem());
            if (achievement.hasAchieved(inventoryClickEvent.getWhoClicked().getUniqueId()) && !achievement.hasClaimed(inventoryClickEvent.getWhoClicked().getUniqueId())) {
                achievement.claimRewards((Player)inventoryClickEvent.getWhoClicked());
                ((Player)inventoryClickEvent.getWhoClicked()).playSound(inventoryClickEvent.getWhoClicked().getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.0f);
                ItemMeta itemMeta = inventoryClickEvent.getCurrentItem().getItemMeta();
                List list = itemMeta.getLore();
                list.remove(list.size() - 1);
                list.remove(list.size() - 1);
                itemMeta.setLore(list);
                itemMeta.removeEnchant(Enchantment.DURABILITY);
                inventoryClickEvent.getCurrentItem().setItemMeta(itemMeta);
                return;
            }
        } else if (this.guiMasteries.get(inventoryClickEvent.getInventory()).containsKey(inventoryClickEvent.getCurrentItem())) {
            UUID uUID;
            Mastery mastery = this.guiMasteries.get(inventoryClickEvent.getInventory()).get(inventoryClickEvent.getCurrentItem());
            if (mastery.hasActive(uUID = inventoryClickEvent.getWhoClicked().getUniqueId())) {
                mastery.activePlayers.remove(uUID);
                ((Player)inventoryClickEvent.getWhoClicked()).playSound(inventoryClickEvent.getWhoClicked().getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 0.5f);
                ItemMeta itemMeta = inventoryClickEvent.getCurrentItem().getItemMeta();
                List list = itemMeta.getLore();
                list.remove(list.size() - 1);
                list.add(Utils.chat("&a" + Languages.getString("internal.enableMastery")));
                itemMeta.setLore(list);
                itemMeta.removeEnchant(Enchantment.DURABILITY);
                inventoryClickEvent.getCurrentItem().setItemMeta(itemMeta);
                this.guiMasteries.get(inventoryClickEvent.getInventory()).put(inventoryClickEvent.getCurrentItem(), mastery);
                return;
            }
            if (mastery.canUse(uUID)) {
                Mastery mastery22;
                int n = 0;
                for (Mastery mastery22 : this.masteriesList) {
                    if (!mastery22.hasActive(uUID) || ++n < this.maxMasteries) continue;
                    return;
                }
                mastery.activePlayers.add(uUID);
                ((Player)inventoryClickEvent.getWhoClicked()).playSound(inventoryClickEvent.getWhoClicked().getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 2.0f);
                mastery22 = inventoryClickEvent.getCurrentItem().getItemMeta();
                List list = mastery22.getLore();
                list.remove(list.size() - 1);
                list.add(Utils.chat("&b" + Languages.getString("internal.deactivateMastery")));
                mastery22.setLore(list);
                mastery22.addEnchant(Enchantment.DURABILITY, 1, true);
                mastery22.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                inventoryClickEvent.getCurrentItem().setItemMeta((ItemMeta)mastery22);
                this.guiMasteries.get(inventoryClickEvent.getInventory()).put(inventoryClickEvent.getCurrentItem(), mastery);
                return;
            }
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent inventoryCloseEvent) {
        if (this.guiAchievements.containsKey(inventoryCloseEvent.getInventory())) {
            this.guiAchievements.remove(inventoryCloseEvent.getInventory());
            this.guiMasteries.remove(inventoryCloseEvent.getInventory());
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.isCancelled() || !(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        if (entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.FALL && this.isMasteryActive(entityDamageEvent.getEntity().getUniqueId(), "disasters.survival.sinkhole")) {
            Mastery mastery = this.masteryMap.get("disasters.survival.sinkhole");
            Player player = (Player)entityDamageEvent.getEntity();
            entityDamageEvent.setDamage(entityDamageEvent.getDamage() - entityDamageEvent.getDamage() / 100.0 * mastery.getAbilityPower(player.getUniqueId()));
            if (entityDamageEvent.getFinalDamage() >= player.getHealth() && player.getHealth() >= player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() / 100.0 * 80.0 && this.getMasteryTier(player.getUniqueId(), "disasters.survival.sinkhole") == 3) {
                entityDamageEvent.setCancelled(true);
                player.damage(1.0E-4);
                player.setHealth(0.5);
                player.getWorld().playSound(player.getLocation(), Sound.ITEM_TOTEM_USE, 0.1f, 2.0f);
            }
            return;
        }
        if ((entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION || entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) && this.isMasteryActive(entityDamageEvent.getEntity().getUniqueId(), "disasters.survival.supernova")) {
            Mastery mastery = this.masteryMap.get("disasters.survival.supernova");
            Player player = (Player)entityDamageEvent.getEntity();
            entityDamageEvent.setDamage(entityDamageEvent.getDamage() - entityDamageEvent.getDamage() / 100.0 * mastery.getAbilityPower(player.getUniqueId()));
            return;
        }
        if (entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.FALLING_BLOCK && this.isMasteryActive(entityDamageEvent.getEntity().getUniqueId(), "disasters.survival.cavein")) {
            Mastery mastery = this.masteryMap.get("disasters.survival.cavein");
            Player player = (Player)entityDamageEvent.getEntity();
            entityDamageEvent.setDamage(entityDamageEvent.getDamage() - entityDamageEvent.getDamage() / 100.0 * mastery.getAbilityPower(player.getUniqueId()));
            return;
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (entityDamageByEntityEvent.isCancelled() || !(entityDamageByEntityEvent.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (entityDamageByEntityEvent.getDamager() instanceof Player && this.isMasteryActive(entityDamageByEntityEvent.getDamager().getUniqueId(), "mobs.slayer.void_mobs") && (entityDamageByEntityEvent.getEntity().getType() == EntityType.ENDERMAN || entityDamageByEntityEvent.getEntity().getType() == EntityType.ENDERMITE || entityDamageByEntityEvent.getEntity().getPersistentDataContainer().has(CustomEntityType.ENDTOTEM.nameKey, PersistentDataType.BYTE) || entityDamageByEntityEvent.getEntity().getPersistentDataContainer().has(CustomEntityType.BABYENDTOTEM.nameKey, PersistentDataType.BYTE) || entityDamageByEntityEvent.getEntity().getPersistentDataContainer().has(CustomEntityType.VOIDARCHER.nameKey, PersistentDataType.BYTE) || entityDamageByEntityEvent.getEntity().getPersistentDataContainer().has(CustomEntityType.VOIDGUARDIAN.nameKey, PersistentDataType.BYTE) || entityDamageByEntityEvent.getEntity().getPersistentDataContainer().has(CustomEntityType.VOIDSTALKER.nameKey, PersistentDataType.BYTE))) {
            entityDamageByEntityEvent.setDamage(entityDamageByEntityEvent.getDamage() + entityDamageByEntityEvent.getDamage() / 100.0 * this.masteryMap.get("mobs.slayer.void_mobs").getAbilityPower(entityDamageByEntityEvent.getDamager().getUniqueId()));
        }
        if (entityDamageByEntityEvent.getFinalDamage() >= ((LivingEntity)entityDamageByEntityEvent.getEntity()).getHealth() && entityDamageByEntityEvent.getEntity().getPersistentDataContainer().has(CustomEntityType.ENDTOTEM.nameKey, PersistentDataType.BYTE) && entityDamageByEntityEvent.getDamager().getPersistentDataContainer().has(CustomEntityType.BABYENDTOTEM.nameKey, PersistentDataType.BYTE) && ((Tameable)entityDamageByEntityEvent.getDamager()).getOwner() != null) {
            this.awardProgress(((Tameable)entityDamageByEntityEvent.getDamager()).getOwner().getUniqueId(), "master.series.void_master", 1, 6);
        }
        if (entityDamageByEntityEvent.getEntity() instanceof Player && this.plugin.random.nextInt(10) == 0 && entityDamageByEntityEvent.getDamager().getLocation().getBlockY() < 50 && this.isMasteryActive(entityDamageByEntityEvent.getEntity().getUniqueId(), "disasters.survival.cavein") && this.getMasteryTier(entityDamageByEntityEvent.getEntity().getUniqueId(), "disasters.survival.cavein") == 3) {
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (entityDamageByEntityEvent.getEntity().getLocation().distanceSquared(entityDamageByEntityEvent.getDamager().getLocation()) >= 36.0 && entityDamageByEntityEvent.getDamager().getLocation().getBlockY() < 50) {
                    Block block = entityDamageByEntityEvent.getDamager().getLocation().add(0.0, 2.0, 0.0).getBlock();
                    int n = 0;
                    while (n < 10) {
                        if (!block.isPassable()) {
                            CaveIn caveIn = new CaveIn(1);
                            caveIn.setRadius(this.plugin.random.nextInt(2) + 2);
                            caveIn.setDepth(this.plugin.random.nextInt(3) + 1);
                            caveIn.start(block.getLocation(), (Player)entityDamageByEntityEvent.getEntity());
                            break;
                        }
                        block = block.getRelative(BlockFace.UP);
                        ++n;
                    }
                }
            }, (long)(this.plugin.random.nextInt(40) + 40));
        }
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent entityDeathEvent) {
        if (entityDeathEvent.getEntity().getKiller() == null || Utils.isPlayerImmune(entityDeathEvent.getEntity().getKiller())) {
            return;
        }
        LivingEntity livingEntity = entityDeathEvent.getEntity();
        if (livingEntity.getPersistentDataContainer().has(CustomEntityType.VOIDSTALKER.nameKey, PersistentDataType.BYTE)) {
            this.achievementMap.get("master.series.void_master").addProgress(livingEntity.getKiller().getUniqueId(), 1, 1);
            this.achievementMap.get("mobs.slayer.void_mobs").addProgress(livingEntity.getKiller().getUniqueId(), 1);
        } else if (livingEntity.getPersistentDataContainer().has(CustomEntityType.BABYENDTOTEM.nameKey, PersistentDataType.BYTE) || livingEntity.getPersistentDataContainer().has(CustomEntityType.ENDTOTEM.nameKey, PersistentDataType.BYTE) || livingEntity.getPersistentDataContainer().has(CustomEntityType.VOIDARCHER.nameKey, PersistentDataType.BYTE) || livingEntity.getPersistentDataContainer().has(CustomEntityType.VOIDGUARDIAN.nameKey, PersistentDataType.BYTE)) {
            this.achievementMap.get("mobs.slayer.void_mobs").addProgress(livingEntity.getKiller().getUniqueId(), 1);
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent playerDeathEvent) {
        if (this.isMasteryActive(playerDeathEvent.getEntity().getUniqueId(), "disasters.survival.supernova") && this.getMasteryTier(playerDeathEvent.getEntity().getUniqueId(), "disasters.survival.supernova") == 3) {
            final Location location = playerDeathEvent.getEntity().getLocation();
            location.getWorld().playSound(location, Sound.AMBIENT_NETHER_WASTES_MOOD, 2.0f, 0.5f);
            final BlockVector blockVector = new BlockVector(location.getX(), location.getY(), location.getZ());
            final World world = location.getWorld();
            final int[] nArray = new int[2];
            int n = 10;
            final Material[] materialArray = new Material[]{Material.OBSIDIAN, Material.BLACK_CONCRETE, Material.FIRE};
            new RepeatingTask(this.plugin, 0, 1){

                @Override
                public void run() {
                    nArray[0] = nArray[0] + 1;
                    if (nArray[0] < 60) {
                        location.getWorld().spawnParticle(Particle.FLASH, location, 1, 0.5, 0.5, 0.5, 0.001);
                        return;
                    }
                    if (nArray[1] > 10) {
                        this.cancel();
                        return;
                    }
                    int n = -nArray[1];
                    while (n < nArray[1]) {
                        int n2 = -nArray[1];
                        while (n2 < nArray[1]) {
                            int n3 = -nArray[1];
                            while (n3 < nArray[1]) {
                                Vector vector = blockVector.clone().add(new Vector(n, n2, n3));
                                if (blockVector.distance(vector) >= (double)(nArray[1] - 1) && blockVector.distance(vector) <= (double)nArray[1]) {
                                    Block block = world.getBlockAt(vector.toLocation(world));
                                    if (AchievementsHandler.this.plugin.random.nextInt(8) == 0) {
                                        world.spawnParticle(Particle.EXPLOSION_LARGE, block.getLocation(), 1, 0.0, 0.0, 0.0, 1.0, null, true);
                                    }
                                    if (block.getType() != Material.AIR && !Utils.isBlockImmune(block.getType()) && !Utils.isZoneProtected(block.getLocation())) {
                                        if (AchievementsHandler.this.plugin.CProtect) {
                                            Utils.getCoreProtect().logRemoval("Deadly-Disasters", block.getLocation(), block.getType(), block.getBlockData());
                                        }
                                        if (nArray[1] > 9 && AchievementsHandler.this.plugin.random.nextInt(8) == 0) {
                                            Material material = materialArray[AchievementsHandler.this.plugin.random.nextInt(materialArray.length)];
                                            if (AchievementsHandler.this.plugin.CProtect) {
                                                Utils.getCoreProtect().logPlacement("Deadly-Disasters", block.getLocation(), material, material.createBlockData());
                                            }
                                            block.setType(material);
                                        } else {
                                            block.setType(Material.AIR);
                                        }
                                    }
                                }
                                ++n3;
                            }
                            ++n2;
                        }
                        ++n;
                    }
                    nArray[1] = nArray[1] + 1;
                    if (nArray[0] % 10 == 0) {
                        for (Entity entity : world.getNearbyEntities(location, 25.0, 25.0, 25.0)) {
                            if (!(entity instanceof LivingEntity) || entity.isDead()) continue;
                            if (location.distance(entity.getLocation()) < (double)nArray[1]) {
                                if (Utils.isZoneProtected(entity.getLocation()) || entity instanceof Player && Utils.isPlayerImmune((Player)entity)) continue;
                                Utils.pureDamageEntity((LivingEntity)entity, 20.0, "dd-supernova", true, null);
                                continue;
                            }
                            if (!(entity instanceof Player)) continue;
                            Location location2 = entity.getLocation().add(Utils.getVectorTowards(entity.getLocation(), location).multiply(4.0));
                            float f = (float)((2.0 - (5.0E-4 * location.distance(entity.getLocation()) - (double)nArray[1])) * 0.5);
                            if (AchievementsHandler.this.plugin.mcVersion >= 1.16) {
                                ((Player)entity).playSound(location2, Sound.AMBIENT_WARPED_FOREST_MOOD, f, 0.5f);
                            }
                            ((Player)entity).playSound(location2, Sound.ENTITY_LIGHTNING_BOLT_THUNDER, f, 0.5f);
                            ((Player)entity).playSound(location2, Sound.ENTITY_DRAGON_FIREBALL_EXPLODE, f / 30.0f, 0.5f);
                        }
                    }
                }
            };
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onProjectileHit(ProjectileHitEvent projectileHitEvent) {
        if (projectileHitEvent.isCancelled() || projectileHitEvent.getHitEntity() == null || !this.twisterPlayers.contains(projectileHitEvent.getHitEntity())) {
            return;
        }
        projectileHitEvent.setCancelled(true);
        Vector vector = projectileHitEvent.getEntity().getVelocity();
        projectileHitEvent.getEntity().setVelocity(new Vector(-vector.getX() / 3.0, vector.getY(), -vector.getZ() / 3.0));
    }

    @EventHandler
    public void onTarget(EntityTargetLivingEntityEvent entityTargetLivingEntityEvent) {
        if (entityTargetLivingEntityEvent.isCancelled() || !(entityTargetLivingEntityEvent.getTarget() instanceof Player)) {
            return;
        }
        if (this.plugin.random.nextInt(10) == 0 && entityTargetLivingEntityEvent.getEntity().getLocation().getBlockY() < 50 && this.isMasteryActive(entityTargetLivingEntityEvent.getTarget().getUniqueId(), "disasters.survival.cavein") && this.getMasteryTier(entityTargetLivingEntityEvent.getTarget().getUniqueId(), "disasters.survival.cavein") == 3) {
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (entityTargetLivingEntityEvent.getEntity().getLocation().distanceSquared(entityTargetLivingEntityEvent.getTarget().getLocation()) >= 36.0 && entityTargetLivingEntityEvent.getEntity().getLocation().getBlockY() < 50) {
                    Block block = entityTargetLivingEntityEvent.getEntity().getLocation().add(0.0, 2.0, 0.0).getBlock();
                    int n = 0;
                    while (n < 10) {
                        if (!block.isPassable()) {
                            CaveIn caveIn = new CaveIn(1);
                            caveIn.setRadius(this.plugin.random.nextInt(2) + 2);
                            caveIn.setDepth(this.plugin.random.nextInt(3) + 1);
                            caveIn.start(block.getLocation(), (Player)entityTargetLivingEntityEvent.getTarget());
                            break;
                        }
                        block = block.getRelative(BlockFace.UP);
                        ++n;
                    }
                }
            }, (long)this.plugin.random.nextInt(80));
        }
    }

    public void startTwisterTimer() {
        final int[] nArray = new int[1];
        new AsyncRepeatingTask(this.plugin, 0, 1){

            @Override
            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    Location location;
                    Vector vector;
                    int n;
                    if (AchievementsHandler.this.twisterPlayers.contains(player)) {
                        if (player.isDead() || player.getHealth() > player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() / 100.0 * 25.0 || Utils.isPlayerImmune(player)) {
                            AchievementsHandler.this.twisterPlayers.remove(player);
                            continue;
                        }
                        n = 0;
                        while (n < 15) {
                            vector = new Vector(0.8 + AchievementsHandler.this.plugin.random.nextDouble() / 2.0, 0.0, 0.0).rotateAroundY(AchievementsHandler.this.plugin.random.nextDouble() * 6.0);
                            location = player.getLocation().add(vector);
                            location.setY(location.getY() + AchievementsHandler.this.plugin.random.nextDouble() * 3.0 - 0.2);
                            player.getWorld().spawnParticle(Particle.CLOUD, location, 0, vector.getZ() / 10.0, 0.0, -vector.getX() / 10.0, 1.0);
                            player.getWorld().spawnParticle(Particle.FALLING_WATER, location, 0, vector.getZ() / 10.0, 0.0, -vector.getX() / 10.0, 1.0);
                            ++n;
                        }
                        if (nArray[0] != 20) continue;
                        player.getWorld().playSound(player.getLocation().add(0.0, 1.0, 0.0), Sound.WEATHER_RAIN_ABOVE, 0.125f, 0.5f);
                        if (AchievementsHandler.this.plugin.random.nextInt(2) != 0) continue;
                        player.getWorld().spawnParticle(Particle.FLASH, player.getLocation().add(new Vector(0.8 + AchievementsHandler.this.plugin.random.nextDouble() / 2.0, 0.0, 0.0).rotateAroundY(AchievementsHandler.this.plugin.random.nextDouble() * 6.0).setY(2.3)), 1, 0.0, 0.0, 0.0);
                        player.getWorld().playSound(player.getLocation().add(0.0, 2.5, 0.0), Sound.ENTITY_LIGHTNING_BOLT_THUNDER, 0.15f, 1.0f);
                        continue;
                    }
                    if (Utils.isPlayerImmune(player) || !(player.getHealth() <= player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() / 100.0 * 25.0) || player.isDead() || !AchievementsHandler.this.isMasteryActive(player.getUniqueId(), "disasters.survival.tornado") || AchievementsHandler.this.getMasteryTier(player.getUniqueId(), "disasters.survival.tornado") != 3) continue;
                    AchievementsHandler.this.twisterPlayers.add(player);
                    n = 0;
                    while (n < 100) {
                        vector = new Vector(0.8 + AchievementsHandler.this.plugin.random.nextDouble() / 2.0, 0.0, 0.0).rotateAroundY(AchievementsHandler.this.plugin.random.nextDouble() * 6.0);
                        location = player.getLocation().add(vector);
                        location.setY(location.getY() + AchievementsHandler.this.plugin.random.nextDouble() * 3.0 - 0.2);
                        player.getWorld().spawnParticle(Particle.CLOUD, location, 0, vector.getZ() / 2.0, 0.0, -vector.getX() / 2.0, 1.0);
                        ++n;
                    }
                    player.getWorld().spawnParticle(Particle.FLASH, player.getLocation().add(new Vector(0.8 + AchievementsHandler.this.plugin.random.nextDouble() / 2.0, 0.0, 0.0).rotateAroundY(AchievementsHandler.this.plugin.random.nextDouble() * 6.0).setY(2.3)), 1, 0.0, 0.0, 0.0);
                    player.getWorld().playSound(player.getLocation().add(0.0, 2.5, 0.0), Sound.ENTITY_LIGHTNING_BOLT_THUNDER, 0.5f, 1.0f);
                    AchievementsHandler.this.plugin.getServer().getScheduler().runTask((Plugin)AchievementsHandler.this.plugin, () -> {
                        for (Entity entity : player.getNearbyEntities(4.0, 4.0, 4.0)) {
                            if (entity instanceof Player && Utils.isPlayerImmune((Player)entity) || entity instanceof Tameable && ((Tameable)entity).getOwner().equals(player)) continue;
                            entity.setVelocity(Utils.getVectorTowards(entity.getLocation().add(0.0, 0.5, 0.0), player.getLocation()).multiply(-1.0));
                        }
                    });
                }
                int n = nArray[0];
                nArray[0] = n + 1;
                if (n >= 20) {
                    nArray[0] = 0;
                }
            }
        };
    }

    public void awardProgress(UUID uUID, String string, int n) {
        if (this.isEnabled) {
            this.achievementMap.get(string).addProgress(uUID, n);
        }
    }

    public void awardProgress(UUID uUID, String string, int n, int n2) {
        if (this.isEnabled) {
            this.achievementMap.get(string).addProgress(uUID, n, n2);
        }
    }

    public boolean isMasteryActive(UUID uUID, String string) {
        return this.masteryMap.containsKey(string) ? this.masteryMap.get(string).hasActive(uUID) : false;
    }

    public double getMasteryPower(UUID uUID, String string) {
        return this.masteryMap.get(string).getAbilityPower(uUID);
    }

    public int getMasteryTier(UUID uUID, String string) {
        return this.masteryMap.get(string).getAbilityTier(uUID);
    }

    private void createFile() {
        this.plugin.getLogger().info("Could not find achievements file in plugin directory! Creating new achievements file...");
        try {
            FileUtils.copyInputStreamToFile(this.plugin.getResource("files/achievements.yml"), new File(this.plugin.getDataFolder().getAbsolutePath(), "achievements.yml"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void saveData() {
        this.achievementMap.forEach((string, achievement) -> achievement.save());
        this.masteryMap.forEach((string, mastery) -> mastery.save());
    }

    public void addToSurvivalChannel(ChannelDataHolder channelDataHolder) {
        this.survivalChannel.addToTrain(channelDataHolder);
    }

    public void awardToSurvivalChannel(ChannelDataHolder channelDataHolder, int n, String string) {
        this.survivalChannel.awardIfPresent(channelDataHolder, n, string);
    }

    public void awardToSurvivalChannel(ChannelDataHolder channelDataHolder, int n, String string, int n2) {
        this.survivalChannel.awardIfPresent(channelDataHolder, n, string, n2);
    }

    public void removeFromSurvivalChannel(ChannelDataHolder channelDataHolder) {
        this.survivalChannel.removeFromTrain(channelDataHolder);
    }

    public void addToWeatherSurvivalChannel(ChannelDataHolder channelDataHolder) {
        this.weatherSurvivalChannel.addToTrain(channelDataHolder);
    }

    public void awardToWeatherSurvivalChannel(ChannelDataHolder channelDataHolder, int n, String string) {
        this.weatherSurvivalChannel.awardIfPresent(channelDataHolder, n, string);
    }

    public void awardToWeatherSurvivalChannel(ChannelDataHolder channelDataHolder, int n, String string, int n2) {
        this.weatherSurvivalChannel.awardIfPresent(channelDataHolder, n, string, n2);
    }

    public void removeFromWeatherSurvivalChannel(ChannelDataHolder channelDataHolder) {
        this.weatherSurvivalChannel.removeFromTrain(channelDataHolder);
    }

    class Achievement {
        private Material item;
        private String name;
        private String description;
        private String series;
        private String pathName;
        private int goal;
        private int amount;
        private boolean hidden;
        private boolean locked;
        private Map<UUID, Integer> progress = new HashMap<UUID, Integer>();
        private Set<UUID> claimed = new HashSet<UUID>();
        private Achievement[] tiers;
        private Map<ItemStack, Integer> rewards = new LinkedHashMap<ItemStack, Integer>();
        private int xp;
        private Sound sound;
        private float[] soundSettings = new float[]{1.0f, 1.0f};
        private ItemStack hiddenItem;
        private Mastery mastery;
        private ItemStack displayItem;

        public Achievement(String string) {
            this.pathName = string;
            this.tiers = new Achievement[AchievementsHandler.this.file.getConfigurationSection(String.valueOf(string) + ".tiers").getKeys(false).size()];
            int n = 0;
            for (String string2 : AchievementsHandler.this.file.getConfigurationSection(String.valueOf(string) + ".tiers").getKeys(false)) {
                HashMap<UUID, Integer> hashMap = new HashMap<UUID, Integer>();
                HashSet<UUID> hashSet = new HashSet<UUID>();
                if (AchievementsHandler.this.plugin.dataFile.contains(String.valueOf(string) + ".tiers." + string2 + ".progress")) {
                    for (String string3 : AchievementsHandler.this.plugin.dataFile.getConfigurationSection(String.valueOf(string) + ".tiers." + string2 + ".progress").getKeys(false)) {
                        hashMap.put(UUID.fromString(string3), AchievementsHandler.this.plugin.dataFile.getInt(String.valueOf(string) + ".tiers." + string2 + ".progress." + string3));
                    }
                    if (AchievementsHandler.this.plugin.dataFile.contains(String.valueOf(string) + ".tiers." + string2 + ".claimed")) {
                        for (String string3 : AchievementsHandler.this.plugin.dataFile.getStringList(String.valueOf(string) + ".tiers." + string2 + ".claimed")) {
                            hashSet.add(UUID.fromString(string3));
                        }
                    }
                }
                this.tiers[n] = new Achievement(String.valueOf(string) + ".tiers." + string2, hashMap, hashSet);
                ++n;
            }
            this.series = Utils.chat(AchievementsHandler.this.file.getString(String.valueOf(string) + ".series"));
            if (AchievementsHandler.this.file.contains(String.valueOf(string) + ".hidden_slots")) {
                try {
                    this.hiddenItem = Utils.createItem(Material.valueOf((String)AchievementsHandler.this.file.getString(String.valueOf(string) + ".hidden_slots").toUpperCase()), 1, "&f???", null, false, true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Main.consoleSender.sendMessage(String.valueOf(Languages.prefix) + Utils.chat("&eCould not add hidden item to achievement &d'" + this.name + "&d' &eno such item &c" + AchievementsHandler.this.file.getString(String.valueOf(string) + ".hidden_slots") + " &eexists!"));
                    this.hiddenItem = Utils.createItem(Material.BLACK_STAINED_GLASS_PANE, 1, "&f???", null, false, true);
                }
            } else {
                this.hiddenItem = Utils.createItem(Material.BLACK_STAINED_GLASS_PANE, 1, "&f???", null, false, true);
            }
        }

        public Achievement(String string, Map<UUID, Integer> map, Set<UUID> set) {
            this.pathName = string;
            try {
                this.item = Material.valueOf((String)AchievementsHandler.this.file.getString(String.valueOf(string) + ".item").toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Main.consoleSender.sendMessage(String.valueOf(Languages.prefix) + Utils.chat("&eCould not set item icon for achievement &d'" + string + "' &eno such item named &c'" + AchievementsHandler.this.file.getString(String.valueOf(string) + ".item") + "'"));
                this.item = Material.BARRIER;
            }
            this.name = Utils.chat(AchievementsHandler.this.file.getString(String.valueOf(string) + ".name"));
            this.amount = AchievementsHandler.this.file.getInt(String.valueOf(string) + ".amount");
            this.description = Utils.chat(AchievementsHandler.this.file.getString(String.valueOf(string) + ".description"));
            this.goal = AchievementsHandler.this.file.getInt(String.valueOf(string) + ".goal");
            this.hidden = AchievementsHandler.this.file.getBoolean(String.valueOf(string) + ".hidden");
            if (AchievementsHandler.this.file.contains(String.valueOf(string) + ".locked")) {
                this.locked = AchievementsHandler.this.file.getBoolean(String.valueOf(string) + ".locked");
            }
            this.progress = map;
            this.claimed = set;
            this.xp = AchievementsHandler.this.file.getInt(String.valueOf(string) + ".xp");
            for (String string2 : AchievementsHandler.this.file.getStringList(String.valueOf(string) + ".rewards")) {
                String string3 = string2.replaceAll(" ", "");
                try {
                    if (ItemsHandler.allItems.containsKey(string3.substring(0, string3.indexOf(124)))) {
                        this.rewards.put(ItemsHandler.allItems.get(string3.substring(0, string3.indexOf(124))), Integer.parseInt(string3.substring(string3.indexOf(124) + 1)));
                        continue;
                    }
                    this.rewards.put(new ItemStack(Material.valueOf((String)string3.substring(0, string3.indexOf(124)).toUpperCase())), Integer.parseInt(string3.substring(string3.indexOf(124) + 1)));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Main.consoleSender.sendMessage(String.valueOf(Languages.prefix) + Utils.chat("&eCould not add reward item to achievement &d'" + this.name + "&d' &eimproper usage on line\n    &c-> " + string2));
                }
            }
            if (AchievementsHandler.this.file.contains(String.valueOf(string) + ".sound.type")) {
                try {
                    this.sound = Sound.valueOf((String)AchievementsHandler.this.file.getString(String.valueOf(string) + ".sound.type").toUpperCase());
                    if (AchievementsHandler.this.file.contains(String.valueOf(string) + ".sound.volume")) {
                        this.soundSettings[0] = (float)AchievementsHandler.this.file.getDouble(String.valueOf(string) + ".sound.volume");
                    }
                    if (AchievementsHandler.this.file.contains(String.valueOf(string) + ".sound.pitch")) {
                        this.soundSettings[1] = (float)AchievementsHandler.this.file.getDouble(String.valueOf(string) + ".sound.pitch");
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Main.consoleSender.sendMessage(String.valueOf(Languages.prefix) + Utils.chat("&eCould not add sound to achievement &d'" + this.name + "&d' &eno such sound &c" + AchievementsHandler.this.file.getString(String.valueOf(string) + ".sound.type") + " &eexists!"));
                }
            }
        }

        public void save() {
            Achievement[] achievementArray = this.tiers;
            int n = this.tiers.length;
            int n2 = 0;
            while (n2 < n) {
                Achievement achievement = achievementArray[n2];
                for (Map.Entry<UUID, Integer> entry : achievement.progress.entrySet()) {
                    AchievementsHandler.this.plugin.dataFile.set(String.valueOf(achievement.pathName) + ".progress." + entry.getKey(), (Object)entry.getValue());
                }
                ArrayList object2 = new ArrayList();
                achievement.claimed.forEach(uUID -> {
                    boolean bl = object2.add(uUID.toString());
                });
                AchievementsHandler.this.plugin.dataFile.set(String.valueOf(achievement.pathName) + ".claimed", object2);
                ++n2;
            }
        }

        public void passMastery(Mastery mastery) {
            this.mastery = mastery;
        }

        public void addProgress(UUID uUID, int n) {
            int n2 = 0;
            while (n2 < this.tiers.length) {
                Achievement achievement = this.tiers[n2];
                if (!achievement.hasAchieved(uUID)) {
                    if (n2 > 0 && achievement.locked && !this.tiers[n2 - 1].hasAchieved(uUID)) {
                        return;
                    }
                    if (!achievement.progress.containsKey(uUID)) {
                        achievement.progress.put(uUID, n);
                    } else {
                        achievement.progress.replace(uUID, Math.min(achievement.progress.get(uUID) + n, achievement.goal));
                    }
                    if (achievement.hasAchieved(uUID)) {
                        String string;
                        String string2;
                        Player player = (Player)Bukkit.getEntity((UUID)uUID);
                        if (achievement.sound != null) {
                            player.playSound(player.getLocation(), achievement.sound, achievement.soundSettings[0], achievement.soundSettings[1]);
                        }
                        if (Main.isSpigot()) {
                            string2 = new TextComponent(String.valueOf(Languages.getString("internal.earnAchievementLocal")) + ' ' + ChatColor.getLastColors((String)achievement.name) + '[' + achievement.name + ']');
                            string2.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(String.valueOf(ChatColor.getLastColors((String)achievement.name)) + achievement.description)}));
                            string = new TextComponent(String.valueOf(player.getName()) + ' ' + Languages.getString("internal.earnAchievement") + ' ' + ChatColor.getLastColors((String)achievement.name) + '[' + achievement.name + ']');
                            string.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(String.valueOf(ChatColor.getLastColors((String)achievement.name)) + achievement.description)}));
                            if (AchievementsHandler.this.announceToPlayers) {
                                player.spigot().sendMessage((BaseComponent)string2);
                            }
                            if (AchievementsHandler.this.broadcastToWorld) {
                                for (Player player2 : player.getWorld().getPlayers()) {
                                    if (player2.equals(player)) continue;
                                    player2.spigot().sendMessage((BaseComponent)string);
                                }
                            }
                        } else {
                            string2 = String.valueOf(Languages.getString("internal.earnAchievementLocal")) + ' ' + ChatColor.getLastColors((String)achievement.name) + '[' + achievement.name + ']';
                            string = String.valueOf(player.getName()) + ' ' + Languages.getString("internal.earnAchievement") + ' ' + ChatColor.getLastColors((String)achievement.name) + '[' + achievement.name + ']';
                            if (AchievementsHandler.this.announceToPlayers) {
                                player.sendMessage(string2);
                            }
                            if (AchievementsHandler.this.broadcastToWorld) {
                                for (Player player2 : player.getWorld().getPlayers()) {
                                    if (player2.equals(player)) continue;
                                    player2.sendMessage(string);
                                }
                            }
                        }
                    }
                }
                ++n2;
            }
        }

        public void addProgress(UUID uUID, int n, int n2) {
            block10: {
                Player player;
                Achievement achievement;
                block11: {
                    if (n2 < 0 || n2 > this.tiers.length) {
                        return;
                    }
                    achievement = this.tiers[n2];
                    if (achievement.hasAchieved(uUID) || n2 > 0 && achievement.locked && !this.tiers[n2 - 1].hasAchieved(uUID)) {
                        return;
                    }
                    if (!achievement.progress.containsKey(uUID)) {
                        achievement.progress.put(uUID, n);
                    } else {
                        achievement.progress.replace(uUID, Math.min(achievement.progress.get(uUID) + n, achievement.goal));
                    }
                    if (!achievement.hasAchieved(uUID)) break block10;
                    player = (Player)Bukkit.getEntity((UUID)uUID);
                    if (achievement.sound != null) {
                        player.playSound(player.getLocation(), achievement.sound, achievement.soundSettings[0], achievement.soundSettings[1]);
                    }
                    if (!Main.isSpigot()) break block11;
                    TextComponent textComponent = new TextComponent(String.valueOf(Languages.getString("internal.earnAchievementLocal")) + ' ' + ChatColor.getLastColors((String)achievement.name) + '[' + achievement.name + ']');
                    textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(String.valueOf(ChatColor.getLastColors((String)achievement.name)) + achievement.description)}));
                    TextComponent textComponent2 = new TextComponent(String.valueOf(player.getName()) + ' ' + Languages.getString("internal.earnAchievement") + ' ' + ChatColor.getLastColors((String)achievement.name) + '[' + achievement.name + ']');
                    textComponent2.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(String.valueOf(ChatColor.getLastColors((String)achievement.name)) + achievement.description)}));
                    if (AchievementsHandler.this.announceToPlayers) {
                        player.spigot().sendMessage((BaseComponent)textComponent);
                    }
                    if (!AchievementsHandler.this.broadcastToWorld) break block10;
                    for (Player player2 : player.getWorld().getPlayers()) {
                        if (player2.equals(player)) continue;
                        player2.spigot().sendMessage((BaseComponent)textComponent2);
                    }
                    break block10;
                }
                String string = String.valueOf(Languages.getString("internal.earnAchievementLocal")) + ' ' + ChatColor.getLastColors((String)achievement.name) + '[' + achievement.name + ']';
                String string2 = String.valueOf(player.getName()) + ' ' + Languages.getString("internal.earnAchievement") + ' ' + ChatColor.getLastColors((String)achievement.name) + '[' + achievement.name + ']';
                if (AchievementsHandler.this.announceToPlayers) {
                    player.sendMessage(string);
                }
                if (AchievementsHandler.this.broadcastToWorld) {
                    for (Player player3 : player.getWorld().getPlayers()) {
                        if (player3.equals(player)) continue;
                        player3.sendMessage(string2);
                    }
                }
            }
        }

        public void claimRewards(Player player) {
            for (Map.Entry<ItemStack, Integer> entry : this.rewards.entrySet()) {
                int n = 0;
                while (n < entry.getValue()) {
                    if (player.getInventory().firstEmpty() != -1) {
                        player.getInventory().addItem(new ItemStack[]{entry.getKey()});
                    } else {
                        player.getWorld().dropItemNaturally(player.getLocation(), entry.getKey());
                    }
                    ++n;
                }
            }
            player.giveExp(this.xp);
            this.claimed.add(player.getUniqueId());
        }

        public int getProgress(UUID uUID) {
            return this.progress.containsKey(uUID) ? this.progress.get(uUID) : 0;
        }

        public boolean hasAchieved(UUID uUID) {
            return this.progress.containsKey(uUID) && this.progress.get(uUID) >= this.goal;
        }

        public boolean hasClaimed(UUID uUID) {
            return this.claimed.contains(uUID);
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getSeries() {
            return this.series;
        }

        public int getGoal() {
            return this.goal;
        }
    }

    class Mastery {
        private Set<UUID> activePlayers = new HashSet<UUID>();
        private Achievement achievement;
        private Material material;
        private String pathName;
        private String name;
        private String description;
        private int requiredTier;
        private int modelData;
        private String abilityDescription;
        private double abilityPower;
        private Mastery[] tiers;

        public Mastery(String string, Achievement achievement) {
            this.pathName = string;
            this.achievement = achievement;
            this.tiers = new Mastery[AchievementsHandler.this.file.getConfigurationSection(String.valueOf(string) + ".tiers").getKeys(false).size()];
            int n = 0;
            for (String string2 : AchievementsHandler.this.file.getConfigurationSection(String.valueOf(string) + ".tiers").getKeys(false)) {
                this.tiers[n] = new Mastery(String.valueOf(string) + ".tiers." + string2, Integer.parseInt(string2.substring(string2.indexOf(32) + 1)));
                ++n;
            }
            if (AchievementsHandler.this.plugin.dataFile.contains(String.valueOf(string) + ".active")) {
                for (String string2 : AchievementsHandler.this.plugin.dataFile.getStringList(String.valueOf(string) + ".active")) {
                    this.activePlayers.add(UUID.fromString(string2));
                }
            }
        }

        public Mastery(String string, int n) {
            this.pathName = string;
            this.requiredTier = n;
            try {
                this.material = Material.valueOf((String)AchievementsHandler.this.file.getString(String.valueOf(string) + ".item").toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Main.consoleSender.sendMessage(String.valueOf(Languages.prefix) + Utils.chat("&eCould not add item to mastery &d'" + this.name + "&d' &eno such item &c" + AchievementsHandler.this.file.getString(String.valueOf(string) + ".item") + " &eexists!"));
                this.material = Material.BARRIER;
            }
            this.name = Utils.chat(AchievementsHandler.this.file.getString(String.valueOf(string) + ".name"));
            this.description = Utils.chat(AchievementsHandler.this.file.getString(String.valueOf(string) + ".description"));
            this.abilityDescription = Utils.chat(AchievementsHandler.this.file.getString(String.valueOf(string) + ".ability_description"));
            this.abilityPower = AchievementsHandler.this.file.getDouble(String.valueOf(string) + ".ability_power");
            this.modelData = AchievementsHandler.this.file.getInt(String.valueOf(string) + ".data");
        }

        public void save() {
            ArrayList arrayList = new ArrayList();
            this.activePlayers.forEach(uUID -> {
                boolean bl = arrayList.add(uUID.toString());
            });
            AchievementsHandler.this.plugin.dataFile.set(String.valueOf(this.pathName) + ".active", arrayList);
        }

        public boolean hasActive(UUID uUID) {
            return this.activePlayers.contains(uUID);
        }

        public boolean canUse(UUID uUID) {
            return this.achievement.tiers[this.tiers[0].requiredTier - 1].hasAchieved(uUID);
        }

        public ItemStack build(UUID uUID) {
            Object object;
            Material material = this.tiers[0].material;
            String string = this.tiers[0].name;
            String string2 = this.tiers[0].description;
            int n = this.tiers[0].modelData;
            ArrayList<String> arrayList = new ArrayList<String>();
            Mastery[] masteryArray = this.tiers;
            int n2 = this.tiers.length;
            int n3 = 0;
            while (n3 < n2) {
                object = masteryArray[n3];
                arrayList.add(" ");
                if (this.achievement.tiers[((Mastery)object).requiredTier - 1].hasAchieved(uUID)) {
                    material = ((Mastery)object).material;
                    string = ((Mastery)object).name;
                    string2 = ((Mastery)object).description;
                    n = ((Mastery)object).modelData;
                    arrayList.add("&fTier " + Utils.getNumerical(((Mastery)object).requiredTier) + ": " + ((Mastery)object).abilityDescription);
                } else {
                    arrayList.add(Utils.chat("&8Tier " + Utils.getNumerical(((Mastery)object).requiredTier) + ": " + ChatColor.stripColor((String)((Mastery)object).abilityDescription)));
                }
                ++n3;
            }
            object = new ArrayList();
            object.add(string2);
            object.addAll(arrayList);
            if (this.activePlayers.contains(uUID)) {
                object.addAll(Arrays.asList(" ", Utils.chat("&b" + Languages.getString("internal.deactivateMastery"))));
            } else if (this.achievement.tiers[this.tiers[0].requiredTier - 1].hasAchieved(uUID)) {
                object.addAll(Arrays.asList(" ", Utils.chat("&a" + Languages.getString("internal.enableMastery"))));
            }
            ItemStack itemStack = Utils.createItem(material, 1, string, (List<String>)object, this.activePlayers.contains(uUID), true);
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.setCustomModelData(Integer.valueOf(n));
            itemStack.setItemMeta(itemMeta);
            return itemStack;
        }

        public double getAbilityPower(UUID uUID) {
            double d = 0.0;
            Mastery[] masteryArray = this.tiers;
            int n = this.tiers.length;
            int n2 = 0;
            while (n2 < n) {
                Mastery mastery = masteryArray[n2];
                if (this.achievement.tiers[mastery.requiredTier - 1].hasAchieved(uUID)) {
                    d = mastery.abilityPower;
                }
                ++n2;
            }
            return d;
        }

        public int getAbilityTier(UUID uUID) {
            int n = 0;
            Mastery[] masteryArray = this.tiers;
            int n2 = this.tiers.length;
            int n3 = 0;
            while (n3 < n2) {
                Mastery mastery = masteryArray[n3];
                if (this.achievement.tiers[mastery.requiredTier - 1].hasAchieved(uUID)) {
                    ++n;
                }
                ++n3;
            }
            return n;
        }
    }

    class SurvivalChannel {
        private Set<ChannelDataHolder> data = ConcurrentHashMap.newKeySet();

        public SurvivalChannel(Main main) {
            main.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)main, () -> {
                Iterator<ChannelDataHolder> iterator = this.data.iterator();
                while (iterator.hasNext()) {
                    Player player = iterator.next().getPlayer();
                    if (player != null && player.isOnline() && !Utils.isPlayerImmune(player)) continue;
                    iterator.remove();
                }
            }, 0L, 10L);
        }

        public void addToTrain(ChannelDataHolder channelDataHolder) {
            this.data.add(channelDataHolder);
        }

        public void removeFromTrain(ChannelDataHolder channelDataHolder) {
            this.data.remove(channelDataHolder);
        }

        public void awardIfPresent(ChannelDataHolder channelDataHolder, int n, String string) {
            if (this.data.contains(channelDataHolder) && channelDataHolder.getPlayer() != null && AchievementsHandler.this.achievementMap.containsKey(string)) {
                AchievementsHandler.this.achievementMap.get(string).addProgress(channelDataHolder.getPlayer().getUniqueId(), n);
            }
        }

        public void awardIfPresent(ChannelDataHolder channelDataHolder, int n, String string, int n2) {
            if (this.data.contains(channelDataHolder) && channelDataHolder.getPlayer() != null && AchievementsHandler.this.achievementMap.containsKey(string)) {
                AchievementsHandler.this.achievementMap.get(string).addProgress(channelDataHolder.getPlayer().getUniqueId(), n, n2);
            }
        }
    }

    class WeatherSurvivalChannel {
        private Set<ChannelDataHolder> data = ConcurrentHashMap.newKeySet();

        public WeatherSurvivalChannel(Main main) {
            main.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)main, () -> {
                Iterator<ChannelDataHolder> iterator = this.data.iterator();
                while (iterator.hasNext()) {
                    ChannelDataHolder channelDataHolder = iterator.next();
                    if (channelDataHolder.getPlayer() != null && channelDataHolder.getPlayer().isOnline() && !Utils.isPlayerImmune(channelDataHolder.getPlayer()) && channelDataHolder.getPlayer().getWorld().equals(channelDataHolder.getWorld())) continue;
                    iterator.remove();
                }
            }, 0L, 10L);
        }

        public void addToTrain(ChannelDataHolder channelDataHolder) {
            this.data.add(channelDataHolder);
        }

        public void removeFromTrain(ChannelDataHolder channelDataHolder) {
            this.data.remove(channelDataHolder);
        }

        public void awardIfPresent(ChannelDataHolder channelDataHolder, int n, String string) {
            if (this.data.contains(channelDataHolder) && channelDataHolder.getPlayer() != null && AchievementsHandler.this.achievementMap.containsKey(string)) {
                AchievementsHandler.this.achievementMap.get(string).addProgress(channelDataHolder.getPlayer().getUniqueId(), n);
            }
        }

        public void awardIfPresent(ChannelDataHolder channelDataHolder, int n, String string, int n2) {
            if (this.data.contains(channelDataHolder) && channelDataHolder.getPlayer() != null && AchievementsHandler.this.achievementMap.containsKey(string)) {
                AchievementsHandler.this.achievementMap.get(string).addProgress(channelDataHolder.getPlayer().getUniqueId(), n, n2);
            }
        }
    }
}

