/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.handlers;

import deadlydisasters.Main;
import deadlydisasters.handlers.Catalog;
import deadlydisasters.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

class InventoryItem {
    public ItemStack item;
    public double gameVersion;
    public double pluginVersion;
    public boolean downloadable = true;
    public String name;
    public int id;
    public String url;
    public String fileName;

    public InventoryItem(String string, YamlConfiguration yamlConfiguration, Main main) {
        if (yamlConfiguration.contains(String.valueOf(string) + "id")) {
            this.id = yamlConfiguration.getInt(String.valueOf(string) + "id");
        }
        this.name = yamlConfiguration.getString(String.valueOf(string) + "name");
        this.url = yamlConfiguration.getString(String.valueOf(string) + "link");
        this.fileName = yamlConfiguration.getString(String.valueOf(string) + "file");
        this.item = new ItemStack(Material.valueOf((String)yamlConfiguration.getString(String.valueOf(string) + "item").toUpperCase()));
        ItemMeta itemMeta = this.item.getItemMeta();
        itemMeta.setDisplayName(Utils.chat(String.valueOf(yamlConfiguration.getString(String.valueOf(string) + "name")) + " &8| Version: " + yamlConfiguration.getString(String.valueOf(string) + "version")));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(Utils.chat(yamlConfiguration.getString(String.valueOf(string) + "description")));
        arrayList.add(Utils.chat("&8Author: " + yamlConfiguration.getString(String.valueOf(string) + "author")));
        arrayList.add(" ");
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(string));
        if (yamlConfiguration.getDouble(stringBuilder.append("game_version").toString()) <= main.mcVersion) {
            arrayList.add(Utils.chat("&7MC Version: &a" + yamlConfiguration.getDouble(String.valueOf(string) + "game_version")));
        } else {
            arrayList.add(Utils.chat("&7MC Version: &c" + yamlConfiguration.getDouble(String.valueOf(string) + "game_version")));
            this.downloadable = false;
        }
        StringBuilder stringBuilder2 = new StringBuilder(String.valueOf(string));
        if (yamlConfiguration.getDouble(stringBuilder2.append("plugin_version").toString()) <= Double.parseDouble(main.getDescription().getVersion())) {
            arrayList.add(Utils.chat("&7Plugin Version: &a" + yamlConfiguration.getDouble(String.valueOf(string) + "plugin_version")));
        } else if (yamlConfiguration.contains(String.valueOf(string) + "pro_version") && yamlConfiguration.getBoolean(String.valueOf(string) + "pro_version")) {
            arrayList.add(Utils.chat("&7Plugin Version: &e" + yamlConfiguration.getDouble(String.valueOf(string) + "plugin_version")));
            arrayList.add(Utils.chat("&eThis disasters was developed in the pro version and may not work!"));
        } else {
            arrayList.add(Utils.chat("&7Plugin Version: &c" + yamlConfiguration.getDouble(String.valueOf(string) + "plugin_version")));
            this.downloadable = false;
        }
        if (this.downloadable) {
            if (Catalog.downloadedDisasters.containsKey(this.id)) {
                arrayList.add(Utils.chat("&bInstalled!"));
                itemMeta.addEnchant(Enchantment.DURABILITY, 1, false);
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            } else {
                arrayList.add(Utils.chat("&aCLICK to download and install!!"));
            }
        }
        itemMeta.setLore(arrayList);
        this.item.setItemMeta(itemMeta);
    }

    public ItemStack getItem() {
        return this.item;
    }

    public ItemStack getInstalledItem() {
        ItemStack itemStack = this.item.clone();
        ItemMeta itemMeta = itemStack.getItemMeta();
        List list = itemMeta.getLore();
        list.remove(list.get(list.size() - 1));
        list.add(Utils.chat("&cCLICK to delete"));
        itemMeta.setLore(list);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public void uninstallItem() {
        ItemMeta itemMeta = this.item.getItemMeta();
        itemMeta.removeEnchant(Enchantment.DURABILITY);
        List list = itemMeta.getLore();
        list.remove(list.get(list.size() - 1));
        list.add(Utils.chat("&aCLICK to download and install!!"));
        itemMeta.setLore(list);
        this.item.setItemMeta(itemMeta);
    }

    public void installItem() {
        ItemMeta itemMeta = this.item.getItemMeta();
        itemMeta.addEnchant(Enchantment.DURABILITY, 1, false);
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        List list = itemMeta.getLore();
        list.remove(list.get(list.size() - 1));
        list.add(Utils.chat("&bInstalled!"));
        itemMeta.setLore(list);
        this.item.setItemMeta(itemMeta);
    }
}

