/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.handlers;

import deadlydisasters.Main;
import deadlydisasters.events.Disaster;
import deadlydisasters.handlers.DifficultyLevel;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.IntStream;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class WorldObject {
    public static Queue<WorldObject> worlds = new ArrayDeque<WorldObject>();
    public static FileConfiguration yamlFile;
    private World world;
    public Set<Disaster> allowed = new HashSet<Disaster>();
    public Map<String, Object> settings;
    public int timer;
    public int offset;
    public int[] table = new int[6];
    public boolean naturalAllowed;
    public DifficultyLevel difficulty;
    public int maxRadius;
    public boolean protectRegions;
    public Set<UUID> whitelist = new HashSet<UUID>();
    public boolean curePlagueInRegions;
    public FileConfiguration configFile;

    public WorldObject(World world, Main main) {
        this.world = world;
        this.reload(main);
    }

    public void reload(Main main) {
        this.allowed.clear();
        this.settings = yamlFile.getConfigurationSection(String.valueOf(this.world.getName()) + ".general").getValues(false);
        this.configFile = main.cfgSwapper.getConfiguration((String)this.settings.get("config"));
        if (this.configFile == null) {
            Main.consoleSender.sendMessage(Utils.chat("&e[DeadlyDisasters]: Could not set config for world &d'" + this.world.getName() + "' &e as the config &c'" + (String)this.settings.get("config") + "' &edoes not exist in the config folder!"));
            this.configFile = main.getConfig();
        }
        this.settings.put("region_protection", yamlFile.get(String.valueOf(this.world.getName()) + ".external.region_plugins.region_protection"));
        this.settings.put("ignore_weather_effects_in_regions", yamlFile.get(String.valueOf(this.world.getName()) + ".external.region_plugins.ignore_weather_effects_in_regions"));
        this.curePlagueInRegions = (Boolean)yamlFile.get(String.valueOf(this.world.getName()) + ".external.region_plugins.cure_plague_in_regions");
        this.protectRegions = (Boolean)yamlFile.get(String.valueOf(this.world.getName()) + ".external.region_plugins.region_protection");
        DifficultyLevel difficultyLevel = DifficultyLevel.NORMAL;
        if (DifficultyLevel.forName(((String)yamlFile.get(String.valueOf(this.world.getName()) + ".general.difficulty")).toUpperCase()) == null) {
            Main.consoleSender.sendMessage(Utils.chat(String.valueOf(Languages.prefix) + "&c'" + (String)yamlFile.get(String.valueOf(this.world.getName()) + ".general.difficulty") + "' is not a real difficulty level! &eSetting disaster difficulty for '" + this.world.getName() + "' to NORMAL until you use '/disasters difficulty " + this.world.getName() + " <difficulty>' or fix this line in worlds.yml:&c\n" + this.world.getName() + "\n  -> general\n    -> difficulty: " + (String)yamlFile.get(String.valueOf(this.world.getName()) + ".general.difficulty")));
        } else {
            difficultyLevel = DifficultyLevel.valueOf(((String)yamlFile.get(String.valueOf(this.world.getName()) + ".general.difficulty")).toUpperCase());
        }
        this.settings.put("difficulty", (Object)difficultyLevel);
        if (difficultyLevel == DifficultyLevel.CUSTOM) {
            this.table[0] = (Integer)yamlFile.get(String.valueOf(this.world.getName()) + ".custom_table.level_1");
            this.table[1] = (Integer)yamlFile.get(String.valueOf(this.world.getName()) + ".custom_table.level_2");
            this.table[2] = (Integer)yamlFile.get(String.valueOf(this.world.getName()) + ".custom_table.level_3");
            this.table[3] = (Integer)yamlFile.get(String.valueOf(this.world.getName()) + ".custom_table.level_4");
            this.table[4] = (Integer)yamlFile.get(String.valueOf(this.world.getName()) + ".custom_table.level_5");
            this.table[5] = (Integer)yamlFile.get(String.valueOf(this.world.getName()) + ".custom_table.level_6");
            this.timer = (Integer)this.settings.get("min_timer");
            this.offset = (Integer)this.settings.get("disaster_offset");
        } else {
            this.table = difficultyLevel.getTable();
            this.timer = difficultyLevel.getTimer();
            this.offset = difficultyLevel.getOffset();
        }
        Map map = yamlFile.getConfigurationSection(String.valueOf(this.world.getName()) + ".disasters").getValues(false);
        for (Map.Entry entry : map.entrySet()) {
            if (Boolean.valueOf((Boolean)entry.getValue()) == null || Disaster.forName((String)entry.getKey()) == null) {
                Main.consoleSender.sendMessage(Utils.chat(String.valueOf(Languages.prefix) + "&cWhy did you change this? Only change the true/false field! Something won't work right until you fix this line in worlds.yml:\n" + this.world.getName() + "\n  -> disasters\n    -> " + (String)entry.getKey() + ": " + entry.getValue()));
                continue;
            }
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            this.allowed.add(Disaster.valueOf((String)entry.getKey()));
        }
        this.whitelist.clear();
        for (Map.Entry entry : yamlFile.getStringList(String.valueOf(this.world.getName()) + ".whitelist")) {
            this.whitelist.add(UUID.fromString((String)((Object)entry)));
        }
        this.naturalAllowed = (Boolean)this.settings.get("natural_disasters");
        this.difficulty = difficultyLevel;
        this.maxRadius = (Integer)this.settings.get("minDistanceRadius");
    }

    public World getWorld() {
        return this.world;
    }

    public static void reloadWorlds(Main main) {
        yamlFile = YamlConfiguration.loadConfiguration((File)new File(main.getDataFolder().getAbsolutePath(), "worlds.yml"));
        for (WorldObject worldObject : worlds) {
            worldObject.reload(main);
        }
    }

    public static void saveYamlFile(Main main) {
        try {
            yamlFile.save(new File(main.getDataFolder().getAbsolutePath(), "worlds.yml"));
        }
        catch (IOException iOException) {
            Main.consoleSender.sendMessage(Utils.chat("&c[DeadlyDisasters]: Error #00 Unable to save worlds file!"));
        }
    }

    public static WorldObject findWorldObject(World world) {
        for (WorldObject worldObject : worlds) {
            if (!worldObject.getWorld().equals(world)) continue;
            return worldObject;
        }
        return null;
    }

    public static void changeAllField(String string, Object object, Main main) {
        for (WorldObject worldObject : worlds) {
            worldObject.settings.replace(string, object);
            yamlFile.set(String.valueOf(worldObject.getWorld().getName()) + ".general." + string, object);
            if (!string.equals("natural_disasters")) continue;
            worldObject.naturalAllowed = (Boolean)object;
        }
        WorldObject.saveYamlFile(main);
    }

    public static void changeDifficulty(WorldObject worldObject, DifficultyLevel difficultyLevel) {
        if (difficultyLevel == DifficultyLevel.CUSTOM) {
            String string = worldObject.getWorld().getName();
            int[] nArray = new int[]{(Integer)yamlFile.get(String.valueOf(string) + ".custom_table.level_1"), (Integer)yamlFile.get(String.valueOf(string) + ".custom_table.level_2"), (Integer)yamlFile.get(String.valueOf(string) + ".custom_table.level_3"), (Integer)yamlFile.get(String.valueOf(string) + ".custom_table.level_4"), (Integer)yamlFile.get(String.valueOf(string) + ".custom_table.level_5"), (Integer)yamlFile.get(String.valueOf(string) + ".custom_table.level_6")};
            worldObject.table = nArray;
            worldObject.timer = (Integer)worldObject.settings.get("min_timer");
            worldObject.offset = (Integer)worldObject.settings.get("disaster_offset");
        } else {
            worldObject.table = difficultyLevel.getTable();
            worldObject.timer = difficultyLevel.getTimer();
            worldObject.offset = difficultyLevel.getOffset();
        }
        worldObject.difficulty = difficultyLevel;
        yamlFile.set(String.valueOf(worldObject.getWorld().getName()) + ".general.difficulty", (Object)difficultyLevel.name());
    }

    public static void updateGlobalDisaster(Disaster disaster, boolean bl, Main main) {
        for (WorldObject worldObject : worlds) {
            if (bl) {
                if (!worldObject.allowed.contains((Object)disaster)) {
                    worldObject.allowed.add(disaster);
                }
            } else if (worldObject.allowed.contains((Object)disaster)) {
                worldObject.allowed.remove((Object)disaster);
            }
            yamlFile.set(String.valueOf(worldObject.getWorld().getName()) + ".disasters." + disaster.name(), (Object)bl);
        }
        WorldObject.saveYamlFile(main);
    }

    public int simulateLevel(Random random) {
        int n = 0;
        int n2 = random.nextInt(IntStream.of(this.table).sum()) + 1;
        int n3 = this.table[0];
        int n4 = 0;
        while (n4 < 6) {
            if (n2 <= n3) {
                n = n4 + 1;
                break;
            }
            if (n4 > 5) {
                n = 1;
                break;
            }
            n3 += this.table[n4 + 1];
            ++n4;
        }
        return n;
    }

    public int generateTimerValue(Random random) {
        return random.nextInt(this.timer / 2) + this.timer;
    }
}

