/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.handlers.specialevents;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.easterentities.KillerChicken;
import deadlydisasters.handlers.ItemsHandler;
import deadlydisasters.handlers.Languages;
import deadlydisasters.handlers.specialevents.SpecialEvent;
import deadlydisasters.listeners.spawners.GlobalSpawner;
import deadlydisasters.utils.Utils;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Chest;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.world.LootGenerateEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantInventory;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class EasterEventHandler
extends SpecialEvent
implements Listener {
    private Main plugin;
    private int year;
    public EggGoal[] eggs = new EggGoal[5];
    private String progress;
    private Set<Inventory> invs = new HashSet<Inventory>();
    private boolean notify;
    private Set<UUID> modifiedTrades = new HashSet<UUID>();
    private Map<UUID, Set<UUID>> droppedEggs = new HashMap<UUID, Set<UUID>>();

    public EasterEventHandler(Main main) {
        this.plugin = main;
        if (main.mcVersion < 1.17 || !main.getConfig().getBoolean("general.special_events")) {
            return;
        }
        LocalDate localDate = LocalDate.now();
        this.year = localDate.getYear();
        switch (this.year) {
            case 2023: {
                if (localDate.getMonth() != Month.APRIL || localDate.getDayOfMonth() < 2 || localDate.getDayOfMonth() > 16) break;
                this.isEnabled = true;
                break;
            }
            case 2024: {
                if ((localDate.getMonth() != Month.MARCH || localDate.getDayOfMonth() < 24) && (localDate.getMonth() != Month.APRIL || localDate.getDayOfMonth() > 1)) break;
                this.isEnabled = true;
                break;
            }
            case 2025: {
                if (localDate.getMonth() != Month.APRIL || localDate.getDayOfMonth() < 13 || localDate.getDayOfMonth() > 21) break;
                this.isEnabled = true;
                break;
            }
            case 2026: {
                if ((localDate.getMonth() != Month.MARCH || localDate.getDayOfMonth() < 29) && (localDate.getMonth() != Month.APRIL || localDate.getDayOfMonth() > 6)) break;
                this.isEnabled = true;
                break;
            }
            default: {
                if (localDate.getMonth() != Month.APRIL || localDate.getDayOfMonth() < 1 || localDate.getDayOfMonth() > 9) break;
                this.isEnabled = true;
            }
        }
        if (this.isEnabled) {
            this.progress = Languages.getString("words.progress");
            this.notify = main.getConfig().getBoolean("messages.event_notifications");
            main.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)main);
            int n = 0;
            while (n < 5) {
                this.eggs[n] = new EggGoal(n);
                ++n;
            }
        }
    }

    @Override
    public void openGUI(Player player) {
        Inventory inventory = Bukkit.createInventory(null, (int)18, (String)Utils.chat("&9DeadlyDisasters Easter Event"));
        inventory.setItem(4, Utils.createItem(Material.NETHER_STAR, 1, Utils.chat("&6" + Languages.getString("easter.infoItem")), Arrays.asList(Utils.chat("&a" + Languages.getString("easter.infoItemLore"))), false, true));
        int n = 0;
        while (n < 5) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.eggs[n].description);
            arrayList.add(" ");
            arrayList.add(Utils.chat("&b" + this.progress + ": " + this.eggs[n].getProgress(player.getUniqueId()) + '/' + this.eggs[n].goal));
            ItemStack itemStack = Utils.createItem(Material.TURTLE_EGG, 1, this.eggs[n].name, arrayList, false, true);
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.setCustomModelData(Integer.valueOf(this.eggs[n].cmd));
            itemStack.setItemMeta(itemMeta);
            inventory.setItem(n + 11, itemStack);
            ++n;
        }
        this.invs.add(inventory);
        player.openInventory(inventory);
    }

    @Override
    public void saveData() {
        EggGoal[] eggGoalArray = this.eggs;
        int n = this.eggs.length;
        int n2 = 0;
        while (n2 < n) {
            EggGoal eggGoal = eggGoalArray[n2];
            eggGoal.save();
            ++n2;
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent playerJoinEvent) {
        if (this.notify) {
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> playerJoinEvent.getPlayer().sendMessage(String.valueOf(Languages.prefix) + Utils.chat("&a" + Languages.getString("easter.eventMessage"))), 20L);
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent inventoryClickEvent) {
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        if (this.invs.contains(inventoryClickEvent.getInventory())) {
            inventoryClickEvent.setCancelled(true);
            return;
        }
        if (inventoryClickEvent.getClickedInventory() instanceof MerchantInventory && inventoryClickEvent.getCurrentItem().hasItemMeta() && inventoryClickEvent.getCurrentItem().getItemMeta().getPersistentDataContainer().has(ItemsHandler.purpleEasterEggKey, PersistentDataType.BYTE)) {
            if (this.eggs[4].hasAchieved(inventoryClickEvent.getWhoClicked().getUniqueId())) {
                inventoryClickEvent.getWhoClicked().sendMessage(Utils.chat("&c" + Languages.getString("easter.restrictAction")));
                inventoryClickEvent.setCancelled(true);
                return;
            }
            this.eggs[4].addProgress(inventoryClickEvent.getWhoClicked().getUniqueId(), 1);
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent inventoryCloseEvent) {
        this.invs.remove(inventoryCloseEvent.getInventory());
    }

    @EventHandler
    public void onFish(PlayerFishEvent playerFishEvent) {
        if (playerFishEvent.getCaught() != null && playerFishEvent.getCaught() instanceof Item && !this.eggs[1].hasAchieved(playerFishEvent.getPlayer().getUniqueId()) && this.plugin.random.nextDouble() * 100.0 < 10.0) {
            ItemStack itemStack = ((Item)playerFishEvent.getCaught()).getItemStack();
            itemStack.setType(Material.TURTLE_EGG);
            itemStack = Utils.createItem(itemStack, 1, ChatColor.BLUE + Languages.getString("easter.blueEgg"), Arrays.asList(ChatColor.YELLOW + Languages.getString("easter.blueEggLore")), false, true);
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.getPersistentDataContainer().set(ItemsHandler.blueEasterEggKey, PersistentDataType.BYTE, (Object)1);
            itemMeta.setCustomModelData(Integer.valueOf(100024));
            itemStack.setItemMeta(itemMeta);
            this.eggs[1].addProgress(playerFishEvent.getPlayer().getUniqueId(), 1);
            return;
        }
    }

    @EventHandler
    public void onTradeAquire(VillagerAcquireTradeEvent villagerAcquireTradeEvent) {
        if (villagerAcquireTradeEvent.getEntity() instanceof WanderingTrader && !this.modifiedTrades.contains(villagerAcquireTradeEvent.getEntity().getUniqueId()) && this.plugin.random.nextDouble() * 100.0 < 20.0) {
            MerchantRecipe merchantRecipe = new MerchantRecipe(ItemsHandler.purpleEasterEgg, 1);
            merchantRecipe.addIngredient(new ItemStack(Material.EMERALD, this.plugin.random.nextInt(5) + 9));
            merchantRecipe.setVillagerExperience(20);
            villagerAcquireTradeEvent.setRecipe(merchantRecipe);
            this.modifiedTrades.add(villagerAcquireTradeEvent.getEntity().getUniqueId());
            return;
        }
    }

    @EventHandler
    public void onItemSpawn(ItemSpawnEvent itemSpawnEvent) {
        if (itemSpawnEvent.getEntity().getItemStack().getType() == Material.EGG && itemSpawnEvent.getEntity().getVelocity().getY() == 0.2 && this.plugin.random.nextDouble() * 100.0 < 5.0) {
            ItemStack itemStack = itemSpawnEvent.getEntity().getItemStack();
            itemStack.setType(Material.TURTLE_EGG);
            itemStack = Utils.createItem(itemStack, 1, ChatColor.GREEN + Languages.getString("easter.greenEgg"), Arrays.asList(ChatColor.YELLOW + Languages.getString("easter.greenEggLore")), false, true);
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.getPersistentDataContainer().set(ItemsHandler.greenEasterEggKey, PersistentDataType.BYTE, (Object)1);
            itemMeta.setCustomModelData(Integer.valueOf(100023));
            itemStack.setItemMeta(itemMeta);
            this.droppedEggs.put(itemSpawnEvent.getEntity().getUniqueId(), new HashSet());
            return;
        }
    }

    @EventHandler
    public void onItemPickup(EntityPickupItemEvent entityPickupItemEvent) {
        if (entityPickupItemEvent.getEntity() instanceof Player && this.droppedEggs.containsKey(entityPickupItemEvent.getItem().getUniqueId())) {
            if (this.eggs[0].hasAchieved(entityPickupItemEvent.getEntity().getUniqueId())) {
                if (!this.droppedEggs.get(entityPickupItemEvent.getItem().getUniqueId()).contains(entityPickupItemEvent.getEntity().getUniqueId())) {
                    entityPickupItemEvent.getEntity().sendMessage(Utils.chat("&c" + Languages.getString("easter.restrictAction")));
                    this.droppedEggs.get(entityPickupItemEvent.getItem().getUniqueId()).add(entityPickupItemEvent.getEntity().getUniqueId());
                }
                entityPickupItemEvent.setCancelled(true);
                return;
            }
            this.eggs[0].addProgress(entityPickupItemEvent.getEntity().getUniqueId(), 1);
        }
    }

    @EventHandler
    public void onLootGen(LootGenerateEvent lootGenerateEvent) {
        if (lootGenerateEvent.getInventoryHolder() instanceof Chest && ((Chest)lootGenerateEvent.getInventoryHolder()).getBlock().getLocation().getBlockY() < 30 && this.plugin.random.nextDouble() * 100.0 < 10.0) {
            lootGenerateEvent.getLoot().add(ItemsHandler.orangeEasterEgg);
            if (lootGenerateEvent.getEntity() instanceof Player) {
                this.eggs[3].addProgress(lootGenerateEvent.getEntity().getUniqueId(), 1);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCreatureSpawn(CreatureSpawnEvent creatureSpawnEvent) {
        if (creatureSpawnEvent.isCancelled() || creatureSpawnEvent.getEntityType() != EntityType.CHICKEN || creatureSpawnEvent.getSpawnReason() != CreatureSpawnEvent.SpawnReason.NATURAL && creatureSpawnEvent.getSpawnReason() != CreatureSpawnEvent.SpawnReason.BREEDING && creatureSpawnEvent.getSpawnReason() != CreatureSpawnEvent.SpawnReason.EGG || GlobalSpawner.noSpawnWorlds.contains(creatureSpawnEvent.getLocation().getWorld()) || this.plugin.random.nextDouble() * 100.0 >= CustomEntityType.KILLERCHICKEN.getSpawnRate()) {
            return;
        }
        Zombie zombie = (Zombie)creatureSpawnEvent.getEntity().getWorld().spawnEntity(creatureSpawnEvent.getLocation(), EntityType.ZOMBIE, false);
        this.plugin.handler.addEntity(new KillerChicken(zombie, this.plugin));
        creatureSpawnEvent.getEntity().remove();
    }

    public class EggGoal {
        private Map<UUID, Integer> progress = new HashMap<UUID, Integer>();
        private int cmd;
        private int goal = 1;
        private String name;
        private String description;
        private String path;

        public EggGoal(int n) {
            this.path = "easterevent." + EasterEventHandler.this.year + ".egg" + n;
            switch (n) {
                case 0: {
                    this.name = Utils.chat(ChatColor.GREEN + Languages.getString("easter.greenEgg"));
                    this.description = Utils.chat(ChatColor.YELLOW + Languages.getString("easter.greenEggGoal"));
                    this.cmd = 100023;
                    break;
                }
                case 1: {
                    this.name = Utils.chat(ChatColor.BLUE + Languages.getString("easter.blueEgg"));
                    this.description = Utils.chat(ChatColor.YELLOW + Languages.getString("easter.blueEggGoal"));
                    this.cmd = 100024;
                    break;
                }
                case 2: {
                    this.name = Utils.chat(ChatColor.RED + Languages.getString("easter.redEgg"));
                    this.description = Utils.chat(ChatColor.YELLOW + Languages.getString("easter.redEggGoal"));
                    this.cmd = 100025;
                    break;
                }
                case 3: {
                    this.name = Utils.chat(ChatColor.GOLD + Languages.getString("easter.orangeEgg"));
                    this.description = Utils.chat(ChatColor.YELLOW + Languages.getString("easter.orangeEggGoal"));
                    this.cmd = 100026;
                    break;
                }
                case 4: {
                    this.name = Utils.chat(ChatColor.LIGHT_PURPLE + Languages.getString("easter.purpleEgg"));
                    this.description = Utils.chat(ChatColor.YELLOW + Languages.getString("easter.purpleEggGoal"));
                    this.cmd = 100027;
                }
            }
            if (EasterEventHandler.this.plugin.dataFile.contains(this.path)) {
                for (String string : EasterEventHandler.this.plugin.dataFile.getConfigurationSection(this.path).getKeys(false)) {
                    this.progress.put(UUID.fromString(string), EasterEventHandler.this.plugin.dataFile.getInt(String.valueOf(this.path) + '.' + string));
                }
            }
        }

        public void save() {
            for (Map.Entry<UUID, Integer> entry : this.progress.entrySet()) {
                EasterEventHandler.this.plugin.dataFile.set(String.valueOf(this.path) + '.' + entry.getKey(), (Object)entry.getValue());
            }
        }

        public void addProgress(UUID uUID, int n) {
            if (this.hasAchieved(uUID)) {
                return;
            }
            if (this.progress.containsKey(uUID)) {
                this.progress.replace(uUID, Math.min(this.goal, this.progress.get(uUID) + n));
            } else {
                this.progress.put(uUID, Math.min(this.goal, n));
            }
            if (this.hasAchieved(uUID) && Bukkit.getPlayer((UUID)uUID) != null) {
                Bukkit.getPlayer((UUID)uUID).sendMessage(String.valueOf(Languages.prefix) + Utils.chat("&a" + Languages.getString("easter.discoverEgg") + " " + this.name + "!"));
            }
        }

        public int getProgress(UUID uUID) {
            return this.progress.containsKey(uUID) ? this.progress.get(uUID) : 0;
        }

        public boolean hasAchieved(UUID uUID) {
            return this.progress.containsKey(uUID) && this.progress.get(uUID) >= this.goal;
        }
    }
}

