/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.listeners.spawners;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.EntityHandler;
import deadlydisasters.entities.infestedcavesentities.InfestedCreeper;
import deadlydisasters.entities.infestedcavesentities.InfestedDevourer;
import deadlydisasters.entities.infestedcavesentities.InfestedEnderman;
import deadlydisasters.entities.infestedcavesentities.InfestedHowler;
import deadlydisasters.entities.infestedcavesentities.InfestedSkeleton;
import deadlydisasters.entities.infestedcavesentities.InfestedSpirit;
import deadlydisasters.entities.infestedcavesentities.InfestedTribesman;
import deadlydisasters.entities.infestedcavesentities.InfestedWorm;
import deadlydisasters.entities.infestedcavesentities.InfestedZombie;
import deadlydisasters.listeners.spawners.GlobalSpawner;
import deadlydisasters.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.plugin.Plugin;

public class InfestedSpawner
implements Listener {
    private Main plugin;
    private Random rand;
    private EntityHandler handler;
    private InfestedSpawner instance;
    private Set<Chunk> handledChunks = new HashSet<Chunk>();

    public InfestedSpawner(Main main, EntityHandler entityHandler) {
        this.plugin = main;
        this.handler = entityHandler;
        this.rand = main.random;
        this.instance = this;
        main.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)main);
    }

    @EventHandler
    public void onChunkLoad(final ChunkLoadEvent chunkLoadEvent) {
        try {
            if (this.rand.nextInt(4) != 0 || GlobalSpawner.noSpawnWorlds.contains(chunkLoadEvent.getWorld()) || this.handledChunks.contains(chunkLoadEvent.getChunk()) || chunkLoadEvent.getChunk().getBlock(0, -32, 0).getBiome() != Biome.DEEP_DARK) {
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Main.consoleSender.sendMessage(Utils.chat("&e[DeadlyDisasters]: You are most likely using a bugged version of paper that does not support getting chunks below Y=0! The plugin will disable natural spawning of infested mobs."));
            HandlerList.unregisterAll((Listener)this.instance);
            return;
        }
        this.handledChunks.add(chunkLoadEvent.getChunk());
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                Location location = null;
                try {
                    location = Utils.findSmartYSpawn(chunkLoadEvent.getChunk().getBlock(0, -32, 0).getLocation(), chunkLoadEvent.getChunk().getBlock(0, -32, 0).getLocation(), 3, 28);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                    Main.consoleSender.sendMessage(Utils.chat("&e[DeadlyDisasters]: You are most likely using a bugged version of paper that does not support getting chunks below Y=0! The plugin will disable natural spawning of infested mobs."));
                    HandlerList.unregisterAll((Listener)InfestedSpawner.this.instance);
                    return;
                }
                if (location == null) {
                    return;
                }
                final CustomEntityType[] customEntityTypeArray = new CustomEntityType[1];
                ArrayList<Integer> arrayList = new ArrayList<Integer>(Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9));
                Collections.shuffle(arrayList);
                Iterator iterator = arrayList.iterator();
                block13: while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    switch (n) {
                        case 1: {
                            if (!(InfestedSpawner.this.rand.nextDouble() * 100.0 < CustomEntityType.INFESTEDCREEPER.getSpawnRate())) break;
                            customEntityTypeArray[0] = CustomEntityType.INFESTEDCREEPER;
                            break block13;
                        }
                        case 2: {
                            if (!(InfestedSpawner.this.rand.nextDouble() * 100.0 < CustomEntityType.INFESTEDDEVOURER.getSpawnRate())) break;
                            customEntityTypeArray[0] = CustomEntityType.INFESTEDDEVOURER;
                            break block13;
                        }
                        case 3: {
                            if (!(InfestedSpawner.this.rand.nextDouble() * 100.0 < CustomEntityType.INFESTEDENDERMAN.getSpawnRate())) break;
                            customEntityTypeArray[0] = CustomEntityType.INFESTEDENDERMAN;
                            break block13;
                        }
                        case 4: {
                            if (!(InfestedSpawner.this.rand.nextDouble() * 100.0 < CustomEntityType.INFESTEDHOWLER.getSpawnRate())) break;
                            customEntityTypeArray[0] = CustomEntityType.INFESTEDHOWLER;
                            break block13;
                        }
                        case 5: {
                            if (!(InfestedSpawner.this.rand.nextDouble() * 100.0 < CustomEntityType.INFESTEDSKELETON.getSpawnRate())) break;
                            customEntityTypeArray[0] = CustomEntityType.INFESTEDSKELETON;
                            break block13;
                        }
                        case 6: {
                            if (!(InfestedSpawner.this.rand.nextDouble() * 100.0 < CustomEntityType.INFESTEDSPIRIT.getSpawnRate())) break;
                            customEntityTypeArray[0] = CustomEntityType.INFESTEDSPIRIT;
                            break block13;
                        }
                        case 7: {
                            if (!(InfestedSpawner.this.rand.nextDouble() * 100.0 < CustomEntityType.INFESTEDTRIBESMAN.getSpawnRate())) break;
                            customEntityTypeArray[0] = CustomEntityType.INFESTEDTRIBESMAN;
                            break block13;
                        }
                        case 8: {
                            if (!(InfestedSpawner.this.rand.nextDouble() * 100.0 < CustomEntityType.INFESTEDWORM.getSpawnRate())) break;
                            customEntityTypeArray[0] = CustomEntityType.INFESTEDWORM;
                            break block13;
                        }
                        case 9: {
                            if (!(InfestedSpawner.this.rand.nextDouble() * 100.0 < CustomEntityType.INFESTEDZOMBIE.getSpawnRate())) break;
                            customEntityTypeArray[0] = CustomEntityType.INFESTEDZOMBIE;
                            break block13;
                        }
                    }
                }
                if (customEntityTypeArray[0] != null) {
                    final Location location2 = location;
                    InfestedSpawner.this.plugin.getServer().getScheduler().runTask((Plugin)InfestedSpawner.this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            switch (customEntityTypeArray[0]) {
                                case INFESTEDCREEPER: {
                                    Mob mob = (Mob)location2.getWorld().spawnEntity(location2, EntityType.CREEPER);
                                    (this).InfestedSpawner.this.handler.addEntity(new InfestedCreeper((Creeper)mob, (this).InfestedSpawner.this.plugin));
                                    return;
                                }
                                case INFESTEDDEVOURER: {
                                    Mob mob = (Mob)location2.getWorld().spawnEntity(location2, EntityType.ZOMBIE);
                                    (this).InfestedSpawner.this.handler.addEntity(new InfestedDevourer((Zombie)mob, (this).InfestedSpawner.this.plugin, (this).InfestedSpawner.this.rand));
                                    return;
                                }
                                case INFESTEDENDERMAN: {
                                    Mob mob = (Mob)location2.getWorld().spawnEntity(location2, EntityType.ENDERMAN);
                                    (this).InfestedSpawner.this.handler.addEntity(new InfestedEnderman(mob, (this).InfestedSpawner.this.plugin));
                                    return;
                                }
                                case INFESTEDHOWLER: {
                                    Mob mob = (Mob)location2.getWorld().spawnEntity(location2, EntityType.ZOMBIE);
                                    (this).InfestedSpawner.this.handler.addEntity(new InfestedHowler((Zombie)mob, (this).InfestedSpawner.this.plugin, (this).InfestedSpawner.this.rand));
                                    return;
                                }
                                case INFESTEDSKELETON: {
                                    Mob mob = (Mob)location2.getWorld().spawnEntity(location2, EntityType.WITHER_SKELETON);
                                    (this).InfestedSpawner.this.handler.addEntity(new InfestedSkeleton(mob, (this).InfestedSpawner.this.plugin));
                                    return;
                                }
                                case INFESTEDSPIRIT: {
                                    Mob mob = (Mob)location2.getWorld().spawnEntity(location2, EntityType.VEX);
                                    (this).InfestedSpawner.this.handler.addEntity(new InfestedSpirit(mob, (this).InfestedSpawner.this.plugin, (this).InfestedSpawner.this.rand));
                                    return;
                                }
                                case INFESTEDTRIBESMAN: {
                                    int n = 0;
                                    while (n < 4) {
                                        Mob mob = (Mob)location2.getWorld().spawnEntity(location2, EntityType.ZOMBIE);
                                        (this).InfestedSpawner.this.handler.addEntity(new InfestedTribesman((Zombie)mob, (this).InfestedSpawner.this.plugin, (this).InfestedSpawner.this.rand));
                                        ++n;
                                    }
                                    return;
                                }
                                case INFESTEDWORM: {
                                    ArrayList<BlockFace> arrayList = new ArrayList<BlockFace>(Arrays.asList(BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST));
                                    Collections.shuffle(arrayList);
                                    for (BlockFace blockFace : arrayList) {
                                        if (location2.getBlock().getRelative(blockFace).isPassable()) continue;
                                        BlockFace blockFace2 = null;
                                        switch (blockFace) {
                                            default: {
                                                blockFace2 = BlockFace.DOWN;
                                                break;
                                            }
                                            case DOWN: {
                                                blockFace2 = BlockFace.UP;
                                                break;
                                            }
                                            case NORTH: {
                                                blockFace2 = BlockFace.SOUTH;
                                                break;
                                            }
                                            case EAST: {
                                                blockFace2 = BlockFace.WEST;
                                                break;
                                            }
                                            case SOUTH: {
                                                blockFace2 = BlockFace.NORTH;
                                                break;
                                            }
                                            case WEST: {
                                                blockFace2 = BlockFace.EAST;
                                            }
                                        }
                                        (this).InfestedSpawner.this.handler.addFalseEntity(new InfestedWorm(location2.getBlock().getRelative(blockFace), blockFace2, (this).InfestedSpawner.this.plugin, (this).InfestedSpawner.this.rand));
                                        return;
                                    }
                                    return;
                                }
                                case INFESTEDZOMBIE: {
                                    Mob mob = (Mob)location2.getWorld().spawnEntity(location2, EntityType.ZOMBIE);
                                    (this).InfestedSpawner.this.handler.addEntity(new InfestedZombie(mob, (this).InfestedSpawner.this.plugin));
                                    return;
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent chunkUnloadEvent) {
        if (this.handledChunks.contains(chunkUnloadEvent.getChunk())) {
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                boolean bl = this.handledChunks.remove(chunkUnloadEvent.getChunk());
            }, 200L);
        }
    }
}

