/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class RegexFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = 4269646126155225062L;
    private final Pattern pattern;
    private final Function<Path, String> pathToString;

    private static Pattern compile(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("Pattern is missing");
        }
        return Pattern.compile(string, n);
    }

    private static int toFlags(IOCase iOCase) {
        return IOCase.isCaseSensitive(iOCase) ? 2 : 0;
    }

    public RegexFileFilter(Pattern pattern) {
        this(pattern, (Path path) -> path.getFileName().toString());
    }

    public RegexFileFilter(Pattern pattern, Function<Path, String> function) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern is missing");
        }
        this.pattern = pattern;
        this.pathToString = function;
    }

    public RegexFileFilter(String string) {
        this(string, 0);
    }

    public RegexFileFilter(String string, int n) {
        this(RegexFileFilter.compile(string, n));
    }

    public RegexFileFilter(String string, IOCase iOCase) {
        this(RegexFileFilter.compile(string, RegexFileFilter.toFlags(iOCase)));
    }

    @Override
    public boolean accept(File file, String string) {
        return this.pattern.matcher(string).matches();
    }

    @Override
    public FileVisitResult accept(Path path, BasicFileAttributes basicFileAttributes) {
        return RegexFileFilter.toFileVisitResult(this.pattern.matcher(this.pathToString.apply(path)).matches(), path);
    }

    @Override
    public String toString() {
        return "RegexFileFilter [pattern=" + this.pattern + "]";
    }
}

