/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablehoppers.hikari;

import com.codahale.metrics.health.HealthCheckRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import me.angeschossen.upgradeablehoppers.hikari.HikariConfigMXBean;
import me.angeschossen.upgradeablehoppers.hikari.metrics.MetricsTrackerFactory;
import me.angeschossen.upgradeablehoppers.hikari.util.PropertyElf;
import me.angeschossen.upgradeablehoppers.hikari.util.UtilityElf;
import me.angeschossen.upgradeablehoppers.slf4j.Logger;
import me.angeschossen.upgradeablehoppers.slf4j.LoggerFactory;

public class HikariConfig
implements HikariConfigMXBean {
    private static final Logger GAGFH = LoggerFactory.getLogger(HikariConfig.class);
    private static final char[] Srqvu = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final long qGVpb = TimeUnit.SECONDS.toMillis(30L);
    private static final long Lqpzc = TimeUnit.SECONDS.toMillis(5L);
    private static final long lwJV = Long.getLong("me.angeschossen.upgradeablehoppers.hikari.timeoutMs.floor", 250L);
    private static final long EMqEv = TimeUnit.MINUTES.toMillis(10L);
    private static final long mToYg = TimeUnit.MINUTES.toMillis(30L);
    private static final long aazaq = 0L;
    private static final int gXWTv = 10;
    private static boolean nzWuu = false;
    private volatile String TqFJL;
    private volatile long WAGHG;
    private volatile long UyMP;
    private volatile long yfrbP;
    private volatile long VyMXK;
    private volatile long hPPy;
    private volatile int UQQfL = -1;
    private volatile int antrD = -1;
    private volatile String NIzf;
    private volatile String XiKV;
    private long knAZu = 1L;
    private String Yhbnj;
    private String fDxZ;
    private String QdTwu;
    private String EFrOo;
    private String mkptn;
    private String bPIRy;
    private String fOAER;
    private String EtuWp;
    private String xHXmb;
    private String hWxIr;
    private boolean SPBBG = true;
    private boolean jbtU;
    private boolean vgowl;
    private boolean KATlH;
    private boolean almnh;
    private DataSource SjHa;
    private Properties Bjrjy = new Properties();
    private ThreadFactory RVUGY;
    private ScheduledExecutorService IWCJf;
    private MetricsTrackerFactory vPxJw;
    private Object jUFqH;
    private Object sSpj;
    private Properties pjQMQ = new Properties();
    private long CoLza = 0L;
    private volatile boolean jDJCa;

    public HikariConfig() {
        this.hPPy = mToYg;
        this.WAGHG = qGVpb;
        this.UyMP = Lqpzc;
        this.yfrbP = EMqEv;
        String string = System.getProperty("hikaricp.configurationFile");
        if (string != null) {
            this.Srqvu(string);
        }
    }

    public HikariConfig(Properties properties) {
        this();
        PropertyElf.setTargetFromProperties(this, properties);
    }

    public HikariConfig(String string) {
        this();
        this.Srqvu(string);
    }

    @Override
    public String getCatalog() {
        return this.TqFJL;
    }

    @Override
    public void setCatalog(String string) {
        this.TqFJL = string;
    }

    @Override
    public long getConnectionTimeout() {
        return this.WAGHG;
    }

    @Override
    public void setConnectionTimeout(long l) {
        if (l == 0L) {
            this.WAGHG = Integer.MAX_VALUE;
        } else {
            if (l < lwJV) {
                throw new IllegalArgumentException("connectionTimeout cannot be less than " + lwJV + "ms");
            }
            this.WAGHG = l;
        }
    }

    @Override
    public long getIdleTimeout() {
        return this.yfrbP;
    }

    @Override
    public void setIdleTimeout(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("idleTimeout cannot be negative");
        }
        this.yfrbP = l;
    }

    @Override
    public long getLeakDetectionThreshold() {
        return this.VyMXK;
    }

    @Override
    public void setLeakDetectionThreshold(long l) {
        this.VyMXK = l;
    }

    @Override
    public long getMaxLifetime() {
        return this.hPPy;
    }

    @Override
    public void setMaxLifetime(long l) {
        this.hPPy = l;
    }

    @Override
    public int getMaximumPoolSize() {
        return this.UQQfL;
    }

    @Override
    public void setMaximumPoolSize(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("maxPoolSize cannot be less than 1");
        }
        this.UQQfL = n;
    }

    @Override
    public int getMinimumIdle() {
        return this.antrD;
    }

    @Override
    public void setMinimumIdle(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("minimumIdle cannot be negative");
        }
        this.antrD = n;
    }

    public String getPassword() {
        return this.XiKV;
    }

    @Override
    public void setPassword(String string) {
        this.XiKV = string;
    }

    public String getUsername() {
        return this.NIzf;
    }

    @Override
    public void setUsername(String string) {
        this.NIzf = string;
    }

    @Override
    public long getValidationTimeout() {
        return this.UyMP;
    }

    @Override
    public void setValidationTimeout(long l) {
        if (l < lwJV) {
            throw new IllegalArgumentException("validationTimeout cannot be less than " + lwJV + "ms");
        }
        this.UyMP = l;
    }

    public String getConnectionTestQuery() {
        return this.fDxZ;
    }

    public void setConnectionTestQuery(String string) {
        this.qGVpb();
        this.fDxZ = string;
    }

    public String getConnectionInitSql() {
        return this.Yhbnj;
    }

    public void setConnectionInitSql(String string) {
        this.qGVpb();
        this.Yhbnj = string;
    }

    public DataSource getDataSource() {
        return this.SjHa;
    }

    public void setDataSource(DataSource dataSource) {
        this.qGVpb();
        this.SjHa = dataSource;
    }

    public String getDataSourceClassName() {
        return this.QdTwu;
    }

    public void setDataSourceClassName(String string) {
        this.qGVpb();
        this.QdTwu = string;
    }

    public void addDataSourceProperty(String string, Object object) {
        this.qGVpb();
        this.Bjrjy.put(string, object);
    }

    public String getDataSourceJNDI() {
        return this.EFrOo;
    }

    public void setDataSourceJNDI(String string) {
        this.qGVpb();
        this.EFrOo = string;
    }

    public Properties getDataSourceProperties() {
        return this.Bjrjy;
    }

    public void setDataSourceProperties(Properties properties) {
        this.qGVpb();
        this.Bjrjy.putAll((Map<?, ?>)properties);
    }

    public String getDriverClassName() {
        return this.mkptn;
    }

    public void setDriverClassName(String string) {
        this.qGVpb();
        Class<?> clazz = this.GAGFH(string);
        try {
            if (clazz == null) {
                clazz = this.getClass().getClassLoader().loadClass(string);
                GAGFH.debug("Driver class {} found in the HikariConfig class classloader {}", (Object)string, (Object)this.getClass().getClassLoader());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            GAGFH.error("Failed to load driver class {} from HikariConfig class classloader {}", (Object)string, (Object)this.getClass().getClassLoader());
        }
        if (clazz == null) {
            throw new RuntimeException("Failed to load driver class " + string + " in either of HikariConfig class loader or Thread context classloader");
        }
        try {
            clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.mkptn = string;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to instantiate class " + string, exception);
        }
    }

    public String getJdbcUrl() {
        return this.fOAER;
    }

    public void setJdbcUrl(String string) {
        this.qGVpb();
        this.fOAER = string;
    }

    public boolean isAutoCommit() {
        return this.SPBBG;
    }

    public void setAutoCommit(boolean bl) {
        this.qGVpb();
        this.SPBBG = bl;
    }

    public boolean isAllowPoolSuspension() {
        return this.almnh;
    }

    public void setAllowPoolSuspension(boolean bl) {
        this.qGVpb();
        this.almnh = bl;
    }

    public long getInitializationFailTimeout() {
        return this.knAZu;
    }

    public void setInitializationFailTimeout(long l) {
        this.qGVpb();
        this.knAZu = l;
    }

    public boolean isIsolateInternalQueries() {
        return this.vgowl;
    }

    public void setIsolateInternalQueries(boolean bl) {
        this.qGVpb();
        this.vgowl = bl;
    }

    public MetricsTrackerFactory getMetricsTrackerFactory() {
        return this.vPxJw;
    }

    public void setMetricsTrackerFactory(MetricsTrackerFactory metricsTrackerFactory) {
        if (this.jUFqH != null) {
            throw new IllegalStateException("cannot use setMetricsTrackerFactory() and setMetricRegistry() together");
        }
        this.vPxJw = metricsTrackerFactory;
    }

    public Object getMetricRegistry() {
        return this.jUFqH;
    }

    public void setMetricRegistry(Object object) {
        if (this.vPxJw != null) {
            throw new IllegalStateException("cannot use setMetricRegistry() and setMetricsTrackerFactory() together");
        }
        if (object != null && !UtilityElf.safeIsAssignableFrom(object = this.GAGFH(object), "com.codahale.metrics.MetricRegistry") && !UtilityElf.safeIsAssignableFrom(object, "io.micrometer.core.instrument.MeterRegistry")) {
            throw new IllegalArgumentException("Class must be instance of com.codahale.metrics.MetricRegistry or io.micrometer.core.instrument.MeterRegistry");
        }
        this.jUFqH = object;
    }

    public Object getHealthCheckRegistry() {
        return this.sSpj;
    }

    public void setHealthCheckRegistry(Object object) {
        this.qGVpb();
        if (object != null && !((object = this.GAGFH(object)) instanceof HealthCheckRegistry)) {
            throw new IllegalArgumentException("Class must be an instance of com.codahale.metrics.health.HealthCheckRegistry");
        }
        this.sSpj = object;
    }

    public Properties getHealthCheckProperties() {
        return this.pjQMQ;
    }

    public void setHealthCheckProperties(Properties properties) {
        this.qGVpb();
        this.pjQMQ.putAll((Map<?, ?>)properties);
    }

    public void addHealthCheckProperty(String string, String string2) {
        this.qGVpb();
        this.pjQMQ.setProperty(string, string2);
    }

    public long getKeepaliveTime() {
        return this.CoLza;
    }

    public void setKeepaliveTime(long l) {
        this.CoLza = l;
    }

    public boolean isReadOnly() {
        return this.jbtU;
    }

    public void setReadOnly(boolean bl) {
        this.qGVpb();
        this.jbtU = bl;
    }

    public boolean isRegisterMbeans() {
        return this.KATlH;
    }

    public void setRegisterMbeans(boolean bl) {
        this.qGVpb();
        this.KATlH = bl;
    }

    @Override
    public String getPoolName() {
        return this.EtuWp;
    }

    public void setPoolName(String string) {
        this.qGVpb();
        this.EtuWp = string;
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this.IWCJf;
    }

    public void setScheduledExecutor(ScheduledExecutorService scheduledExecutorService) {
        this.qGVpb();
        this.IWCJf = scheduledExecutorService;
    }

    public String getTransactionIsolation() {
        return this.hWxIr;
    }

    public String getSchema() {
        return this.xHXmb;
    }

    public void setSchema(String string) {
        this.qGVpb();
        this.xHXmb = string;
    }

    public String getExceptionOverrideClassName() {
        return this.bPIRy;
    }

    public void setExceptionOverrideClassName(String string) {
        this.qGVpb();
        Class<?> clazz = this.GAGFH(string);
        try {
            if (clazz == null) {
                clazz = this.getClass().getClassLoader().loadClass(string);
                GAGFH.debug("SQLExceptionOverride class {} found in the HikariConfig class classloader {}", (Object)string, (Object)this.getClass().getClassLoader());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            GAGFH.error("Failed to load SQLExceptionOverride class {} from HikariConfig class classloader {}", (Object)string, (Object)this.getClass().getClassLoader());
        }
        if (clazz == null) {
            throw new RuntimeException("Failed to load SQLExceptionOverride class " + string + " in either of HikariConfig class loader or Thread context classloader");
        }
        try {
            clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.bPIRy = string;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to instantiate class " + string, exception);
        }
    }

    public void setTransactionIsolation(String string) {
        this.qGVpb();
        this.hWxIr = string;
    }

    public ThreadFactory getThreadFactory() {
        return this.RVUGY;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.qGVpb();
        this.RVUGY = threadFactory;
    }

    void GAGFH() {
        this.jDJCa = true;
    }

    public void copyStateTo(HikariConfig hikariConfig) {
        for (Field field : HikariConfig.class.getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                field.set(hikariConfig, field.get(this));
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to copy HikariConfig state: " + exception.getMessage(), exception);
            }
        }
        hikariConfig.jDJCa = false;
    }

    private Class<?> GAGFH(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                Class<?> clazz = classLoader.loadClass(string);
                GAGFH.debug("Driver class {} found in Thread context class loader {}", (Object)string, (Object)classLoader);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                GAGFH.debug("Driver class {} not found in Thread context class loader {}, trying classloader {}", string, classLoader, this.getClass().getClassLoader());
            }
        }
        return null;
    }

    public void validate() {
        if (this.EtuWp == null) {
            this.EtuWp = this.lwJV();
        } else if (this.KATlH && this.EtuWp.contains(":")) {
            throw new IllegalArgumentException("poolName cannot contain ':' when used with JMX");
        }
        this.TqFJL = UtilityElf.getNullIfEmpty(this.TqFJL);
        this.Yhbnj = UtilityElf.getNullIfEmpty(this.Yhbnj);
        this.fDxZ = UtilityElf.getNullIfEmpty(this.fDxZ);
        this.hWxIr = UtilityElf.getNullIfEmpty(this.hWxIr);
        this.QdTwu = UtilityElf.getNullIfEmpty(this.QdTwu);
        this.EFrOo = UtilityElf.getNullIfEmpty(this.EFrOo);
        this.mkptn = UtilityElf.getNullIfEmpty(this.mkptn);
        this.fOAER = UtilityElf.getNullIfEmpty(this.fOAER);
        if (this.SjHa != null) {
            if (this.QdTwu != null) {
                GAGFH.warn("{} - using dataSource and ignoring dataSourceClassName.", (Object)this.EtuWp);
            }
        } else if (this.QdTwu != null) {
            if (this.mkptn != null) {
                GAGFH.error("{} - cannot use driverClassName and dataSourceClassName together.", (Object)this.EtuWp);
                throw new IllegalStateException("cannot use driverClassName and dataSourceClassName together.");
            }
            if (this.fOAER != null) {
                GAGFH.warn("{} - using dataSourceClassName and ignoring jdbcUrl.", (Object)this.EtuWp);
            }
        } else if (this.fOAER == null && this.EFrOo == null) {
            if (this.mkptn != null) {
                GAGFH.error("{} - jdbcUrl is required with driverClassName.", (Object)this.EtuWp);
                throw new IllegalArgumentException("jdbcUrl is required with driverClassName.");
            }
            GAGFH.error("{} - dataSource or dataSourceClassName or jdbcUrl is required.", (Object)this.EtuWp);
            throw new IllegalArgumentException("dataSource or dataSourceClassName or jdbcUrl is required.");
        }
        this.Srqvu();
        if (GAGFH.isDebugEnabled() || nzWuu) {
            this.Lqpzc();
        }
    }

    private void Srqvu() {
        if (this.hPPy != 0L && this.hPPy < TimeUnit.SECONDS.toMillis(30L)) {
            GAGFH.warn("{} - maxLifetime is less than 30000ms, setting to default {}ms.", (Object)this.EtuWp, (Object)mToYg);
            this.hPPy = mToYg;
        }
        if (this.CoLza != 0L && this.CoLza < TimeUnit.SECONDS.toMillis(30L)) {
            GAGFH.warn("{} - keepaliveTime is less than 30000ms, disabling it.", (Object)this.EtuWp);
            this.CoLza = 0L;
        }
        if (this.CoLza != 0L && this.hPPy != 0L && this.CoLza >= this.hPPy) {
            GAGFH.warn("{} - keepaliveTime is greater than or equal to maxLifetime, disabling it.", (Object)this.EtuWp);
            this.CoLza = 0L;
        }
        if (this.VyMXK > 0L && !nzWuu && (this.VyMXK < TimeUnit.SECONDS.toMillis(2L) || this.VyMXK > this.hPPy && this.hPPy > 0L)) {
            GAGFH.warn("{} - leakDetectionThreshold is less than 2000ms or more than maxLifetime, disabling it.", (Object)this.EtuWp);
            this.VyMXK = 0L;
        }
        if (this.WAGHG < lwJV) {
            GAGFH.warn("{} - connectionTimeout is less than {}ms, setting to {}ms.", this.EtuWp, lwJV, qGVpb);
            this.WAGHG = qGVpb;
        }
        if (this.UyMP < lwJV) {
            GAGFH.warn("{} - validationTimeout is less than {}ms, setting to {}ms.", this.EtuWp, lwJV, Lqpzc);
            this.UyMP = Lqpzc;
        }
        if (this.UQQfL < 1) {
            this.UQQfL = 10;
        }
        if (this.antrD < 0 || this.antrD > this.UQQfL) {
            this.antrD = this.UQQfL;
        }
        if (this.yfrbP + TimeUnit.SECONDS.toMillis(1L) > this.hPPy && this.hPPy > 0L && this.antrD < this.UQQfL) {
            GAGFH.warn("{} - idleTimeout is close to or more than maxLifetime, disabling it.", (Object)this.EtuWp);
            this.yfrbP = 0L;
        } else if (this.yfrbP != 0L && this.yfrbP < TimeUnit.SECONDS.toMillis(10L) && this.antrD < this.UQQfL) {
            GAGFH.warn("{} - idleTimeout is less than 10000ms, setting to default {}ms.", (Object)this.EtuWp, (Object)EMqEv);
            this.yfrbP = EMqEv;
        } else if (this.yfrbP != EMqEv && this.yfrbP != 0L && this.antrD == this.UQQfL) {
            GAGFH.warn("{} - idleTimeout has been set but has no effect because the pool is operating as a fixed size pool.", (Object)this.EtuWp);
        }
    }

    private void qGVpb() {
        if (this.jDJCa) {
            throw new IllegalStateException("The configuration of the pool is sealed once started. Use HikariConfigMXBean for runtime changes.");
        }
    }

    private void Lqpzc() {
        GAGFH.debug("{} - configuration:", (Object)this.EtuWp);
        TreeSet<String> treeSet = new TreeSet<String>(PropertyElf.getPropertyNames(HikariConfig.class));
        for (String string : treeSet) {
            try {
                Object object = PropertyElf.getProperty(string, this);
                if ("dataSourceProperties".equals(string)) {
                    Properties properties = PropertyElf.copyProperties(this.Bjrjy);
                    properties.setProperty("password", "<masked>");
                    object = properties;
                }
                if ("initializationFailTimeout".equals(string) && this.knAZu == Long.MAX_VALUE) {
                    object = "infinite";
                } else if ("transactionIsolation".equals(string) && this.hWxIr == null) {
                    object = "default";
                } else if (string.matches("scheduledExecutorService|threadFactory") && object == null) {
                    object = "internal";
                } else if (string.contains("jdbcUrl") && object instanceof String) {
                    object = ((String)object).replaceAll("([?&;]password=)[^&#;]*(.*)", "$1<masked>$2");
                } else if (string.contains("password")) {
                    object = "<masked>";
                } else if (object instanceof String) {
                    object = "\"" + object + "\"";
                } else if (object == null) {
                    object = "none";
                }
                GAGFH.debug("{}{}", (Object)(string + "................................................".substring(0, 32)), object);
            }
            catch (Exception exception) {}
        }
    }

    private void Srqvu(String string) {
        block9: {
            File file = new File(string);
            try (InputStream inputStream = file.isFile() ? new FileInputStream(file) : this.getClass().getResourceAsStream(string);){
                if (inputStream != null) {
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    PropertyElf.setTargetFromProperties(this, properties);
                    break block9;
                }
                throw new IllegalArgumentException("Cannot find property file: " + string);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Failed to read property file", iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String lwJV() {
        String string = "HikariPool-";
        try {
            Properties properties = System.getProperties();
            synchronized (properties) {
                String string2 = String.valueOf(Integer.getInteger("me.angeschossen.upgradeablehoppers.hikari.pool_number", 0) + 1);
                System.setProperty("me.angeschossen.upgradeablehoppers.hikari.pool_number", string2);
                return "HikariPool-" + string2;
            }
        }
        catch (AccessControlException accessControlException) {
            ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
            StringBuilder stringBuilder = new StringBuilder("HikariPool-");
            for (int i = 0; i < 4; ++i) {
                stringBuilder.append(Srqvu[threadLocalRandom.nextInt(62)]);
            }
            GAGFH.info("assigned random pool name '{}' (security manager prevented access to system properties)", (Object)stringBuilder);
            return stringBuilder.toString();
        }
    }

    private Object GAGFH(Object object) {
        if (object instanceof String) {
            try {
                InitialContext initialContext = new InitialContext();
                return initialContext.lookup((String)object);
            }
            catch (NamingException namingException) {
                throw new IllegalArgumentException(namingException);
            }
        }
        return object;
    }
}

