/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablehoppers.hikari.hibernate;

import java.sql.Connection;
import java.util.Map;
import javax.sql.DataSource;
import me.angeschossen.upgradeablehoppers.hikari.HikariConfig;
import me.angeschossen.upgradeablehoppers.hikari.HikariDataSource;
import me.angeschossen.upgradeablehoppers.hikari.hibernate.HikariConfigurationUtil;
import me.angeschossen.upgradeablehoppers.slf4j.Logger;
import me.angeschossen.upgradeablehoppers.slf4j.LoggerFactory;
import org.hibernate.HibernateException;
import org.hibernate.Version;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;

public class HikariConnectionProvider
implements ConnectionProvider,
Configurable,
Stoppable {
    private static final long GAGFH = -9131625057941275711L;
    private static final Logger Srqvu = LoggerFactory.getLogger(HikariConnectionProvider.class);
    private HikariConfig qGVpb = null;
    private HikariDataSource Lqpzc = null;

    public HikariConnectionProvider() {
        if (Version.getVersionString().substring(0, 5).compareTo("4.3.6") >= 1) {
            Srqvu.warn("me.angeschossen.upgradeablehoppers.hikari.hibernate.HikariConnectionProvider has been deprecated for versions of Hibernate 4.3.6 and newer.  Please switch to org.hibernate.hikaricp.internal.HikariCPConnectionProvider.");
        }
    }

    public void configure(Map map) {
        try {
            Srqvu.debug("Configuring HikariCP");
            this.qGVpb = HikariConfigurationUtil.loadConfiguration(map);
            this.Lqpzc = new HikariDataSource(this.qGVpb);
        }
        catch (Exception exception) {
            throw new HibernateException((Throwable)exception);
        }
        Srqvu.debug("HikariCP Configured");
    }

    public Connection getConnection() {
        Connection connection = null;
        if (this.Lqpzc != null) {
            connection = this.Lqpzc.getConnection();
        }
        return connection;
    }

    public void closeConnection(Connection connection) {
        connection.close();
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public boolean isUnwrappableAs(Class clazz) {
        return ConnectionProvider.class.equals((Object)clazz) || HikariConnectionProvider.class.isAssignableFrom(clazz);
    }

    public <T> T unwrap(Class<T> clazz) {
        if (ConnectionProvider.class.equals(clazz) || HikariConnectionProvider.class.isAssignableFrom(clazz)) {
            return (T)this;
        }
        if (DataSource.class.isAssignableFrom(clazz)) {
            return (T)this.Lqpzc;
        }
        throw new UnknownUnwrapTypeException(clazz);
    }

    public void stop() {
        this.Lqpzc.close();
    }
}

