/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablehoppers.hikari.metrics.prometheus;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Summary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import me.angeschossen.upgradeablehoppers.hikari.metrics.IMetricsTracker;
import me.angeschossen.upgradeablehoppers.hikari.metrics.prometheus.HikariCPCollector;
import me.angeschossen.upgradeablehoppers.hikari.metrics.prometheus.PrometheusMetricsTrackerFactory;

class PrometheusMetricsTracker
implements IMetricsTracker {
    private static final Counter GAGFH = ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("hikaricp_connection_timeout_total")).labelNames(new String[]{"pool"})).help("Connection timeout total count")).create();
    private static final Summary Srqvu = PrometheusMetricsTracker.GAGFH("hikaricp_connection_acquired_nanos", "Connection acquired time (ns)");
    private static final Summary qGVpb = PrometheusMetricsTracker.GAGFH("hikaricp_connection_usage_millis", "Connection usage (ms)");
    private static final Summary Lqpzc = PrometheusMetricsTracker.GAGFH("hikaricp_connection_creation_millis", "Connection creation (ms)");
    private static final Map<CollectorRegistry, PrometheusMetricsTrackerFactory.RegistrationStatus> lwJV = new ConcurrentHashMap<CollectorRegistry, PrometheusMetricsTrackerFactory.RegistrationStatus>();
    private final String EMqEv;
    private final HikariCPCollector mToYg;
    private final Counter.Child aazaq;
    private final Summary.Child gXWTv;
    private final Summary.Child nzWuu;
    private final Summary.Child TqFJL;

    PrometheusMetricsTracker(String string, CollectorRegistry collectorRegistry, HikariCPCollector hikariCPCollector) {
        this.GAGFH(collectorRegistry);
        this.EMqEv = string;
        this.mToYg = hikariCPCollector;
        this.aazaq = (Counter.Child)GAGFH.labels(new String[]{string});
        this.gXWTv = (Summary.Child)Srqvu.labels(new String[]{string});
        this.nzWuu = (Summary.Child)qGVpb.labels(new String[]{string});
        this.TqFJL = (Summary.Child)Lqpzc.labels(new String[]{string});
    }

    private void GAGFH(CollectorRegistry collectorRegistry) {
        if (lwJV.putIfAbsent(collectorRegistry, PrometheusMetricsTrackerFactory.RegistrationStatus.REGISTERED) == null) {
            GAGFH.register(collectorRegistry);
            Srqvu.register(collectorRegistry);
            qGVpb.register(collectorRegistry);
            Lqpzc.register(collectorRegistry);
        }
    }

    @Override
    public void recordConnectionAcquiredNanos(long l) {
        this.gXWTv.observe((double)l);
    }

    @Override
    public void recordConnectionUsageMillis(long l) {
        this.nzWuu.observe((double)l);
    }

    @Override
    public void recordConnectionCreatedMillis(long l) {
        this.TqFJL.observe((double)l);
    }

    @Override
    public void recordConnectionTimeout() {
        this.aazaq.inc();
    }

    private static Summary GAGFH(String string, String string2) {
        return ((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name(string)).labelNames(new String[]{"pool"})).help(string2)).quantile(0.5, 0.05).quantile(0.95, 0.01).quantile(0.99, 0.001).maxAgeSeconds(TimeUnit.MINUTES.toSeconds(5L)).ageBuckets(5).create();
    }

    @Override
    public void close() {
        this.mToYg.GAGFH(this.EMqEv);
        GAGFH.remove(new String[]{this.EMqEv});
        Srqvu.remove(new String[]{this.EMqEv});
        qGVpb.remove(new String[]{this.EMqEv});
        Lqpzc.remove(new String[]{this.EMqEv});
    }
}

