/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablehoppers.hikari.pool;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTransientConnectionException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import me.angeschossen.upgradeablehoppers.hikari.HikariConfig;
import me.angeschossen.upgradeablehoppers.hikari.HikariPoolMXBean;
import me.angeschossen.upgradeablehoppers.hikari.metrics.MetricsTrackerFactory;
import me.angeschossen.upgradeablehoppers.hikari.metrics.PoolStats;
import me.angeschossen.upgradeablehoppers.hikari.metrics.dropwizard.CodahaleHealthChecker;
import me.angeschossen.upgradeablehoppers.hikari.metrics.dropwizard.CodahaleMetricsTrackerFactory;
import me.angeschossen.upgradeablehoppers.hikari.metrics.micrometer.MicrometerMetricsTrackerFactory;
import me.angeschossen.upgradeablehoppers.hikari.pool.PoolBase;
import me.angeschossen.upgradeablehoppers.hikari.pool.PoolEntry;
import me.angeschossen.upgradeablehoppers.hikari.pool.ProxyConnection;
import me.angeschossen.upgradeablehoppers.hikari.pool.ProxyLeakTaskFactory;
import me.angeschossen.upgradeablehoppers.hikari.util.ClockSource;
import me.angeschossen.upgradeablehoppers.hikari.util.ConcurrentBag;
import me.angeschossen.upgradeablehoppers.hikari.util.SuspendResumeLock;
import me.angeschossen.upgradeablehoppers.hikari.util.UtilityElf;
import me.angeschossen.upgradeablehoppers.slf4j.Logger;
import me.angeschossen.upgradeablehoppers.slf4j.LoggerFactory;

public final class HikariPool
extends PoolBase
implements HikariPoolMXBean,
ConcurrentBag.IBagStateListener {
    private final Logger mToYg = LoggerFactory.getLogger(HikariPool.class);
    public static final int POOL_NORMAL = 0;
    public static final int POOL_SUSPENDED = 1;
    public static final int POOL_SHUTDOWN = 2;
    public volatile int poolState;
    private final long aazaq = Long.getLong("me.angeschossen.upgradeablehoppers.hikari.aliveBypassWindowMs", TimeUnit.MILLISECONDS.toMillis(500L));
    private final long gXWTv = Long.getLong("me.angeschossen.upgradeablehoppers.hikari.housekeeping.periodMs", TimeUnit.SECONDS.toMillis(30L));
    private static final String nzWuu = "(connection was evicted)";
    private static final String TqFJL = "(connection is dead)";
    private final PoolEntryCreator WAGHG = new PoolEntryCreator(null);
    private final PoolEntryCreator UyMP = new PoolEntryCreator("After adding ");
    private final Collection<Runnable> yfrbP;
    private final ThreadPoolExecutor VyMXK;
    private final ThreadPoolExecutor hPPy;
    private final ConcurrentBag<PoolEntry> UQQfL = new ConcurrentBag(this);
    private final ProxyLeakTaskFactory antrD;
    private final SuspendResumeLock NIzf;
    private final ScheduledExecutorService XiKV;
    private ScheduledFuture<?> knAZu;

    public HikariPool(HikariConfig hikariConfig) {
        super(hikariConfig);
        this.NIzf = hikariConfig.isAllowPoolSuspension() ? new SuspendResumeLock() : SuspendResumeLock.FAUX_LOCK;
        this.XiKV = this.gXWTv();
        this.aazaq();
        if (hikariConfig.getMetricsTrackerFactory() != null) {
            this.setMetricsTrackerFactory(hikariConfig.getMetricsTrackerFactory());
        } else {
            this.setMetricRegistry(hikariConfig.getMetricRegistry());
        }
        this.setHealthCheckRegistry(hikariConfig.getHealthCheckRegistry());
        this.GAGFH(this, true);
        ThreadFactory threadFactory = hikariConfig.getThreadFactory();
        int n = hikariConfig.getMaximumPoolSize();
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>(n);
        this.yfrbP = Collections.unmodifiableCollection(linkedBlockingQueue);
        this.VyMXK = UtilityElf.createThreadPoolExecutor(linkedBlockingQueue, this.poolName + " connection adder", threadFactory, (RejectedExecutionHandler)new ThreadPoolExecutor.DiscardOldestPolicy());
        this.hPPy = UtilityElf.createThreadPoolExecutor(n, this.poolName + " connection closer", threadFactory, (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        this.antrD = new ProxyLeakTaskFactory(hikariConfig.getLeakDetectionThreshold(), this.XiKV);
        this.knAZu = this.XiKV.scheduleWithFixedDelay(new HouseKeeper(), 100L, this.gXWTv, TimeUnit.MILLISECONDS);
        if (Boolean.getBoolean("me.angeschossen.upgradeablehoppers.hikari.blockUntilFilled") && hikariConfig.getInitializationFailTimeout() > 1L) {
            this.VyMXK.setMaximumPoolSize(Math.min(16, Runtime.getRuntime().availableProcessors()));
            this.VyMXK.setCorePoolSize(Math.min(16, Runtime.getRuntime().availableProcessors()));
            long l = ClockSource.currentTime();
            while (ClockSource.elapsedMillis(l) < hikariConfig.getInitializationFailTimeout() && this.getTotalConnections() < hikariConfig.getMinimumIdle()) {
                UtilityElf.quietlySleep(TimeUnit.MILLISECONDS.toMillis(100L));
            }
            this.VyMXK.setCorePoolSize(1);
            this.VyMXK.setMaximumPoolSize(1);
        }
    }

    public Connection getConnection() {
        return this.getConnection(this.Lqpzc);
    }

    /*
     * Exception decompiling
     */
    public Connection getConnection(long var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        block8: {
            this.poolState = 2;
            if (this.VyMXK != null) break block8;
            this.GAGFH("After shutdown ");
            this.GAGFH(this, false);
            this.GAGFH.close();
            return;
        }
        try {
            this.GAGFH("Before shutdown ");
            if (this.knAZu != null) {
                this.knAZu.cancel(false);
                this.knAZu = null;
            }
            this.softEvictConnections();
            this.VyMXK.shutdown();
            this.VyMXK.awaitTermination(this.lwJV(), TimeUnit.SECONDS);
            this.nzWuu();
            this.UQQfL.close();
            ThreadPoolExecutor threadPoolExecutor = UtilityElf.createThreadPoolExecutor(this.config.getMaximumPoolSize(), this.poolName + " connection assassinator", this.config.getThreadFactory(), (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
            try {
                long l = ClockSource.currentTime();
                do {
                    this.GAGFH(threadPoolExecutor);
                    this.softEvictConnections();
                } while (this.getTotalConnections() > 0 && ClockSource.elapsedMillis(l) < TimeUnit.SECONDS.toMillis(10L));
            }
            finally {
                threadPoolExecutor.shutdown();
                threadPoolExecutor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            this.Lqpzc();
            this.hPPy.shutdown();
            this.hPPy.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            this.GAGFH("After shutdown ");
            this.GAGFH(this, false);
            this.GAGFH.close();
            throw throwable;
        }
        this.GAGFH("After shutdown ");
        this.GAGFH(this, false);
        this.GAGFH.close();
    }

    public void evictConnection(Connection connection) {
        ProxyConnection proxyConnection = (ProxyConnection)connection;
        proxyConnection.gXWTv();
        try {
            this.GAGFH(proxyConnection.mToYg(), "(connection evicted by user)", !connection.isClosed());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void setMetricRegistry(Object object) {
        if (object != null && UtilityElf.safeIsAssignableFrom(object, "com.codahale.metrics.MetricRegistry")) {
            this.setMetricsTrackerFactory(new CodahaleMetricsTrackerFactory((MetricRegistry)object));
        } else if (object != null && UtilityElf.safeIsAssignableFrom(object, "io.micrometer.core.instrument.MeterRegistry")) {
            this.setMetricsTrackerFactory(new MicrometerMetricsTrackerFactory((MeterRegistry)object));
        } else {
            this.setMetricsTrackerFactory(null);
        }
    }

    public void setMetricsTrackerFactory(MetricsTrackerFactory metricsTrackerFactory) {
        this.GAGFH = metricsTrackerFactory != null ? new PoolBase.MetricsTrackerDelegate(metricsTrackerFactory.create(this.config.getPoolName(), this.TqFJL())) : new PoolBase.NopMetricsTrackerDelegate();
    }

    public void setHealthCheckRegistry(Object object) {
        if (object != null) {
            CodahaleHealthChecker.registerHealthChecks(this, this.config, (HealthCheckRegistry)object);
        }
    }

    @Override
    public void addBagItem(int n) {
        boolean bl;
        boolean bl2 = bl = n - this.yfrbP.size() >= 0;
        if (bl) {
            this.VyMXK.submit(this.WAGHG);
        } else {
            this.mToYg.debug("{} - Add connection elided, waiting {}, queue {}", this.poolName, n, this.yfrbP.size());
        }
    }

    @Override
    public int getActiveConnections() {
        return this.UQQfL.getCount(1);
    }

    @Override
    public int getIdleConnections() {
        return this.UQQfL.getCount(0);
    }

    @Override
    public int getTotalConnections() {
        return this.UQQfL.size();
    }

    @Override
    public int getThreadsAwaitingConnection() {
        return this.UQQfL.getWaitingThreadCount();
    }

    @Override
    public void softEvictConnections() {
        this.UQQfL.values().forEach(poolEntry -> this.GAGFH((PoolEntry)poolEntry, "(connection evicted)", false));
    }

    @Override
    public synchronized void suspendPool() {
        if (this.NIzf == SuspendResumeLock.FAUX_LOCK) {
            throw new IllegalStateException(this.poolName + " - is not suspendable");
        }
        if (this.poolState != 1) {
            this.NIzf.suspend();
            this.poolState = 1;
        }
    }

    @Override
    public synchronized void resumePool() {
        if (this.poolState == 1) {
            this.poolState = 0;
            this.mToYg();
            this.NIzf.resume();
        }
    }

    void GAGFH(String ... stringArray) {
        if (this.mToYg.isDebugEnabled()) {
            this.mToYg.debug("{} - {}stats (total={}, active={}, idle={}, waiting={})", this.poolName, stringArray.length > 0 ? stringArray[0] : "", this.getTotalConnections(), this.getActiveConnections(), this.getIdleConnections(), this.getThreadsAwaitingConnection());
        }
    }

    @Override
    void GAGFH(PoolEntry poolEntry) {
        this.GAGFH.recordConnectionUsage(poolEntry);
        this.UQQfL.requite(poolEntry);
    }

    void GAGFH(PoolEntry poolEntry, String string) {
        if (this.UQQfL.remove(poolEntry)) {
            Connection connection = poolEntry.EMqEv();
            this.hPPy.execute(() -> {
                this.GAGFH(connection, string);
                if (this.poolState == 0) {
                    this.mToYg();
                }
            });
        }
    }

    int[] GAGFH() {
        return this.UQQfL.getStateCounts();
    }

    private PoolEntry EMqEv() {
        block6: {
            try {
                long l;
                long l2;
                PoolEntry poolEntry = this.qGVpb();
                long l3 = this.config.getMaxLifetime();
                if (l3 > 0L) {
                    l2 = l3 > 10000L ? ThreadLocalRandom.current().nextLong(l3 / 40L) : 0L;
                    l = l3 - l2;
                    poolEntry.GAGFH(this.XiKV.schedule(new MaxLifetimeTask(poolEntry), l, TimeUnit.MILLISECONDS));
                }
                if ((l2 = this.config.getKeepaliveTime()) > 0L) {
                    l = ThreadLocalRandom.current().nextLong(l2 / 10L);
                    long l4 = l2 - l;
                    poolEntry.setKeepalive(this.XiKV.scheduleWithFixedDelay(new KeepaliveTask(poolEntry), l4, l4, TimeUnit.MILLISECONDS));
                }
                return poolEntry;
            }
            catch (PoolBase.ConnectionSetupException connectionSetupException) {
                if (this.poolState == 0) {
                    this.mToYg.error("{} - Error thrown while acquiring connection from data source", (Object)this.poolName, (Object)connectionSetupException.getCause());
                    this.qGVpb.set(connectionSetupException);
                }
            }
            catch (Exception exception) {
                if (this.poolState != 0) break block6;
                this.mToYg.debug("{} - Cannot acquire connection from data source", (Object)this.poolName, (Object)exception);
            }
        }
        return null;
    }

    private synchronized void mToYg() {
        int n = Math.min(this.config.getMaximumPoolSize() - this.getTotalConnections(), this.config.getMinimumIdle() - this.getIdleConnections()) - this.yfrbP.size();
        if (n <= 0) {
            this.mToYg.debug("{} - Fill pool skipped, pool is at sufficient level.", (Object)this.poolName);
        }
        for (int i = 0; i < n; ++i) {
            this.VyMXK.submit(i < n - 1 ? this.WAGHG : this.UyMP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void GAGFH(ExecutorService executorService) {
        for (PoolEntry poolEntry : this.UQQfL.values(1)) {
            Connection connection = poolEntry.EMqEv();
            try {
                connection.abort(executorService);
            }
            catch (Throwable throwable) {
                this.GAGFH(connection, "(connection aborted during shutdown)");
            }
            finally {
                this.UQQfL.remove(poolEntry);
            }
        }
    }

    private void aazaq() {
        long l = this.config.getInitializationFailTimeout();
        if (l < 0L) {
            return;
        }
        long l2 = ClockSource.currentTime();
        do {
            PoolEntry poolEntry;
            if ((poolEntry = this.EMqEv()) != null) {
                if (this.config.getMinimumIdle() > 0) {
                    this.UQQfL.add(poolEntry);
                    this.mToYg.debug("{} - Added connection {}", (Object)this.poolName, (Object)poolEntry.GAGFH);
                } else {
                    this.GAGFH(poolEntry.EMqEv(), "(initialization check complete and minimumIdle is zero)");
                }
                return;
            }
            if (this.Srqvu() instanceof PoolBase.ConnectionSetupException) {
                this.GAGFH(this.Srqvu().getCause());
            }
            UtilityElf.quietlySleep(TimeUnit.SECONDS.toMillis(1L));
        } while (ClockSource.elapsedMillis(l2) < l);
        if (l > 0L) {
            this.GAGFH(this.Srqvu());
        }
    }

    private void GAGFH(Throwable throwable) {
        this.mToYg.error("{} - Exception during pool initialization.", (Object)this.poolName, (Object)throwable);
        this.nzWuu();
        throw new PoolInitializationException(throwable);
    }

    private boolean GAGFH(PoolEntry poolEntry, String string, boolean bl) {
        poolEntry.qGVpb();
        if (bl || this.UQQfL.reserve(poolEntry)) {
            this.GAGFH(poolEntry, string);
            return true;
        }
        return false;
    }

    private ScheduledExecutorService gXWTv() {
        if (this.config.getScheduledExecutor() == null) {
            ThreadFactory threadFactory = Optional.ofNullable(this.config.getThreadFactory()).orElseGet(() -> new UtilityElf.DefaultThreadFactory(this.poolName + " housekeeper", true));
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, threadFactory, new ThreadPoolExecutor.DiscardPolicy());
            scheduledThreadPoolExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            scheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
            return scheduledThreadPoolExecutor;
        }
        return this.config.getScheduledExecutor();
    }

    private void nzWuu() {
        if (this.config.getScheduledExecutor() == null) {
            this.XiKV.shutdownNow();
        }
    }

    private PoolStats TqFJL() {
        return new PoolStats(TimeUnit.SECONDS.toMillis(1L)){

            @Override
            protected void update() {
                this.pendingThreads = HikariPool.this.getThreadsAwaitingConnection();
                this.idleConnections = HikariPool.this.getIdleConnections();
                this.totalConnections = HikariPool.this.getTotalConnections();
                this.activeConnections = HikariPool.this.getActiveConnections();
                this.maxConnections = HikariPool.this.config.getMaximumPoolSize();
                this.minConnections = HikariPool.this.config.getMinimumIdle();
            }
        };
    }

    private SQLException GAGFH(long l) {
        this.GAGFH("Timeout failure ");
        this.GAGFH.recordConnectionTimeout();
        String string = null;
        Exception exception = this.Srqvu();
        if (exception instanceof SQLException) {
            string = ((SQLException)exception).getSQLState();
        }
        SQLTransientConnectionException sQLTransientConnectionException = new SQLTransientConnectionException(this.poolName + " - Connection is not available, request timed out after " + ClockSource.elapsedMillis(l) + "ms.", string, exception);
        if (exception instanceof SQLException) {
            sQLTransientConnectionException.setNextException((SQLException)exception);
        }
        return sQLTransientConnectionException;
    }

    public static class PoolInitializationException
    extends RuntimeException {
        private static final long GAGFH = 929872118275916520L;

        public PoolInitializationException(Throwable throwable) {
            super("Failed to initialize pool: " + throwable.getMessage(), throwable);
        }
    }

    private final class KeepaliveTask
    implements Runnable {
        private final PoolEntry Srqvu;

        KeepaliveTask(PoolEntry poolEntry) {
            this.Srqvu = poolEntry;
        }

        @Override
        public void run() {
            if (HikariPool.this.UQQfL.reserve(this.Srqvu)) {
                if (!HikariPool.this.GAGFH(this.Srqvu.GAGFH)) {
                    HikariPool.this.GAGFH(this.Srqvu, HikariPool.TqFJL, true);
                    HikariPool.this.addBagItem(HikariPool.this.UQQfL.getWaitingThreadCount());
                } else {
                    HikariPool.this.UQQfL.unreserve(this.Srqvu);
                    HikariPool.this.mToYg.debug("{} - keepalive: connection {} is alive", (Object)HikariPool.this.poolName, (Object)this.Srqvu.GAGFH);
                }
            }
        }
    }

    private final class MaxLifetimeTask
    implements Runnable {
        private final PoolEntry Srqvu;

        MaxLifetimeTask(PoolEntry poolEntry) {
            this.Srqvu = poolEntry;
        }

        @Override
        public void run() {
            if (HikariPool.this.GAGFH(this.Srqvu, "(connection has passed maxLifetime)", false)) {
                HikariPool.this.addBagItem(HikariPool.this.UQQfL.getWaitingThreadCount());
            }
        }
    }

    private final class HouseKeeper
    implements Runnable {
        private volatile long Srqvu;

        private HouseKeeper() {
            this.Srqvu = ClockSource.plusMillis(ClockSource.currentTime(), -HikariPool.this.gXWTv);
        }

        @Override
        public void run() {
            try {
                HikariPool.this.Lqpzc = HikariPool.this.config.getConnectionTimeout();
                HikariPool.this.lwJV = HikariPool.this.config.getValidationTimeout();
                HikariPool.this.antrD.GAGFH(HikariPool.this.config.getLeakDetectionThreshold());
                HikariPool.this.Srqvu = HikariPool.this.config.getCatalog() != null && !HikariPool.this.config.getCatalog().equals(HikariPool.this.Srqvu) ? HikariPool.this.config.getCatalog() : HikariPool.this.Srqvu;
                long l = HikariPool.this.config.getIdleTimeout();
                long l2 = ClockSource.currentTime();
                if (ClockSource.plusMillis(l2, 128L) < ClockSource.plusMillis(this.Srqvu, HikariPool.this.gXWTv)) {
                    HikariPool.this.mToYg.warn("{} - Retrograde clock change detected (housekeeper delta={}), soft-evicting connections from pool.", (Object)HikariPool.this.poolName, (Object)ClockSource.elapsedDisplayString(this.Srqvu, l2));
                    this.Srqvu = l2;
                    HikariPool.this.softEvictConnections();
                    return;
                }
                if (l2 > ClockSource.plusMillis(this.Srqvu, 3L * HikariPool.this.gXWTv / 2L)) {
                    HikariPool.this.mToYg.warn("{} - Thread starvation or clock leap detected (housekeeper delta={}).", (Object)HikariPool.this.poolName, (Object)ClockSource.elapsedDisplayString(this.Srqvu, l2));
                }
                this.Srqvu = l2;
                String string = "Pool ";
                if (l > 0L && HikariPool.this.config.getMinimumIdle() < HikariPool.this.config.getMaximumPoolSize()) {
                    HikariPool.this.GAGFH("Before cleanup ");
                    string = "After cleanup  ";
                    List list = HikariPool.this.UQQfL.values(0);
                    int n = list.size() - HikariPool.this.config.getMinimumIdle();
                    for (PoolEntry poolEntry : list) {
                        if (n <= 0 || ClockSource.elapsedMillis(poolEntry.Srqvu, l2) <= l || !HikariPool.this.UQQfL.reserve(poolEntry)) continue;
                        HikariPool.this.GAGFH(poolEntry, "(connection has passed idleTimeout)");
                        --n;
                    }
                }
                HikariPool.this.GAGFH(string);
                HikariPool.this.mToYg();
            }
            catch (Exception exception) {
                HikariPool.this.mToYg.error("Unexpected exception in housekeeping task", exception);
            }
        }
    }

    private final class PoolEntryCreator
    implements Callable<Boolean> {
        private final String Srqvu;

        PoolEntryCreator(String string) {
            this.Srqvu = string;
        }

        @Override
        public Boolean call() {
            long l = 250L;
            while (HikariPool.this.poolState == 0 && this.GAGFH()) {
                PoolEntry poolEntry = HikariPool.this.EMqEv();
                if (poolEntry != null) {
                    HikariPool.this.UQQfL.add(poolEntry);
                    HikariPool.this.mToYg.debug("{} - Added connection {}", (Object)HikariPool.this.poolName, (Object)poolEntry.GAGFH);
                    if (this.Srqvu != null) {
                        HikariPool.this.GAGFH(this.Srqvu);
                    }
                    return Boolean.TRUE;
                }
                if (this.Srqvu != null) {
                    HikariPool.this.mToYg.debug("{} - Connection add failed, sleeping with backoff: {}ms", (Object)HikariPool.this.poolName, (Object)l);
                }
                UtilityElf.quietlySleep(l);
                l = Math.min(TimeUnit.SECONDS.toMillis(10L), Math.min(HikariPool.this.Lqpzc, (long)((double)l * 1.5)));
            }
            return Boolean.FALSE;
        }

        private synchronized boolean GAGFH() {
            return HikariPool.this.getTotalConnections() < HikariPool.this.config.getMaximumPoolSize() && (HikariPool.this.UQQfL.getWaitingThreadCount() > 0 || HikariPool.this.getIdleConnections() < HikariPool.this.config.getMinimumIdle());
        }
    }
}

