/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablehoppers.hikari.pool;

import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTransientConnectionException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import me.angeschossen.upgradeablehoppers.hikari.HikariConfig;
import me.angeschossen.upgradeablehoppers.hikari.SQLExceptionOverride;
import me.angeschossen.upgradeablehoppers.hikari.metrics.IMetricsTracker;
import me.angeschossen.upgradeablehoppers.hikari.pool.HikariPool;
import me.angeschossen.upgradeablehoppers.hikari.pool.PoolEntry;
import me.angeschossen.upgradeablehoppers.hikari.pool.ProxyConnection;
import me.angeschossen.upgradeablehoppers.hikari.util.ClockSource;
import me.angeschossen.upgradeablehoppers.hikari.util.DriverDataSource;
import me.angeschossen.upgradeablehoppers.hikari.util.PropertyElf;
import me.angeschossen.upgradeablehoppers.hikari.util.UtilityElf;
import me.angeschossen.upgradeablehoppers.slf4j.Logger;
import me.angeschossen.upgradeablehoppers.slf4j.LoggerFactory;

abstract class PoolBase {
    private final Logger mToYg = LoggerFactory.getLogger(PoolBase.class);
    public final HikariConfig config;
    IMetricsTrackerDelegate GAGFH;
    protected final String poolName;
    volatile String Srqvu;
    final AtomicReference<Exception> qGVpb;
    long Lqpzc;
    long lwJV;
    SQLExceptionOverride EMqEv;
    private static final String[] aazaq = new String[]{"readOnly", "autoCommit", "isolation", "catalog", "netTimeout", "schema"};
    private static final int gXWTv = -1;
    private static final int nzWuu = 1;
    private static final int TqFJL = 0;
    private int WAGHG;
    private int UyMP;
    private int yfrbP;
    private int VyMXK;
    private int hPPy;
    private Executor UQQfL;
    private DataSource antrD;
    private final String NIzf;
    private final boolean XiKV;
    private final boolean knAZu;
    private final boolean Yhbnj;
    private final boolean fDxZ;
    private volatile boolean QdTwu;

    PoolBase(HikariConfig hikariConfig) {
        this.config = hikariConfig;
        this.WAGHG = -1;
        this.Srqvu = hikariConfig.getCatalog();
        this.NIzf = hikariConfig.getSchema();
        this.XiKV = hikariConfig.isReadOnly();
        this.knAZu = hikariConfig.isAutoCommit();
        this.EMqEv = UtilityElf.createInstance(hikariConfig.getExceptionOverrideClassName(), SQLExceptionOverride.class, new Object[0]);
        this.hPPy = UtilityElf.getTransactionIsolation(hikariConfig.getTransactionIsolation());
        this.yfrbP = -1;
        this.UyMP = -1;
        this.Yhbnj = hikariConfig.getConnectionTestQuery() == null;
        this.fDxZ = hikariConfig.isIsolateInternalQueries();
        this.poolName = hikariConfig.getPoolName();
        this.Lqpzc = hikariConfig.getConnectionTimeout();
        this.lwJV = hikariConfig.getValidationTimeout();
        this.qGVpb = new AtomicReference();
        this.GAGFH();
    }

    public String toString() {
        return this.poolName;
    }

    abstract void GAGFH(PoolEntry var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void GAGFH(Connection connection, String string) {
        if (connection != null) {
            try {
                this.mToYg.debug("{} - Closing connection {}: {}", this.poolName, connection, string);
                try {
                    this.Srqvu(connection, TimeUnit.SECONDS.toMillis(15L));
                }
                catch (SQLException sQLException) {
                }
                finally {
                    connection.close();
                }
            }
            catch (Exception exception) {
                this.mToYg.debug("{} - Closing connection {} failed", this.poolName, connection, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean GAGFH(Connection connection) {
        try {
            try {
                this.Srqvu(connection, this.lwJV);
                int n = (int)Math.max(1000L, this.lwJV) / 1000;
                if (this.Yhbnj) {
                    boolean bl = connection.isValid(n);
                    return bl;
                }
                try (Statement statement = connection.createStatement();){
                    if (this.UyMP != 1) {
                        this.GAGFH(statement, n);
                    }
                    statement.execute(this.config.getConnectionTestQuery());
                    return true;
                }
            }
            finally {
                this.Srqvu(connection, this.WAGHG);
                if (this.fDxZ && !this.knAZu) {
                    connection.rollback();
                }
            }
        }
        catch (Exception exception) {
            this.qGVpb.set(exception);
            this.mToYg.warn("{} - Failed to validate connection {} ({}). Possibly consider using a shorter maxLifetime value.", this.poolName, connection, exception.getMessage());
            return false;
        }
    }

    Exception Srqvu() {
        return this.qGVpb.get();
    }

    public DataSource getUnwrappedDataSource() {
        return this.antrD;
    }

    PoolEntry qGVpb() {
        return new PoolEntry(this.EMqEv(), this, this.XiKV, this.knAZu);
    }

    void GAGFH(Connection connection, ProxyConnection proxyConnection, int n) {
        int n2 = 0;
        if ((n & 1) != 0 && proxyConnection.lwJV() != this.XiKV) {
            connection.setReadOnly(this.XiKV);
            n2 |= 1;
        }
        if ((n & 2) != 0 && proxyConnection.GAGFH() != this.knAZu) {
            connection.setAutoCommit(this.knAZu);
            n2 |= 2;
        }
        if ((n & 4) != 0 && proxyConnection.Lqpzc() != this.hPPy) {
            connection.setTransactionIsolation(this.hPPy);
            n2 |= 4;
        }
        if ((n & 8) != 0 && this.Srqvu != null && !this.Srqvu.equals(proxyConnection.Srqvu())) {
            connection.setCatalog(this.Srqvu);
            n2 |= 8;
        }
        if ((n & 0x10) != 0 && proxyConnection.EMqEv() != this.WAGHG) {
            this.Srqvu(connection, this.WAGHG);
            n2 |= 0x10;
        }
        if ((n & 0x20) != 0 && this.NIzf != null && !this.NIzf.equals(proxyConnection.qGVpb())) {
            connection.setSchema(this.NIzf);
            n2 |= 0x20;
        }
        if (n2 != 0 && this.mToYg.isDebugEnabled()) {
            this.mToYg.debug("{} - Reset ({}) on connection {}", this.poolName, this.GAGFH(n2), connection);
        }
    }

    void Lqpzc() {
        if (this.UQQfL instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.UQQfL).shutdownNow();
        }
    }

    long lwJV() {
        try {
            return this.antrD != null ? (long)this.antrD.getLoginTimeout() : TimeUnit.SECONDS.toSeconds(5L);
        }
        catch (SQLException sQLException) {
            return TimeUnit.SECONDS.toSeconds(5L);
        }
    }

    void GAGFH(HikariPool hikariPool, boolean bl) {
        if (!this.config.isRegisterMbeans()) {
            return;
        }
        try {
            ObjectName objectName;
            ObjectName objectName2;
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            if ("true".equals(System.getProperty("hikaricp.jmx.register2.0"))) {
                objectName2 = new ObjectName("me.angeschossen.upgradeablehoppers.hikari:type=PoolConfig,name=" + this.poolName);
                objectName = new ObjectName("me.angeschossen.upgradeablehoppers.hikari:type=Pool,name=" + this.poolName);
            } else {
                objectName2 = new ObjectName("me.angeschossen.upgradeablehoppers.hikari:type=PoolConfig (" + this.poolName + ")");
                objectName = new ObjectName("me.angeschossen.upgradeablehoppers.hikari:type=Pool (" + this.poolName + ")");
            }
            if (bl) {
                if (!mBeanServer.isRegistered(objectName2)) {
                    mBeanServer.registerMBean(this.config, objectName2);
                    mBeanServer.registerMBean(hikariPool, objectName);
                } else {
                    this.mToYg.error("{} - JMX name ({}) is already registered.", (Object)this.poolName, (Object)this.poolName);
                }
            } else if (mBeanServer.isRegistered(objectName2)) {
                mBeanServer.unregisterMBean(objectName2);
                mBeanServer.unregisterMBean(objectName);
            }
        }
        catch (Exception exception) {
            this.mToYg.warn("{} - Failed to {} management beans.", this.poolName, bl ? "register" : "unregister", exception);
        }
    }

    private void GAGFH() {
        String string = this.config.getJdbcUrl();
        String string2 = this.config.getUsername();
        String string3 = this.config.getPassword();
        String string4 = this.config.getDataSourceClassName();
        String string5 = this.config.getDriverClassName();
        String string6 = this.config.getDataSourceJNDI();
        Properties properties = this.config.getDataSourceProperties();
        DataSource dataSource = this.config.getDataSource();
        if (string4 != null && dataSource == null) {
            dataSource = UtilityElf.createInstance(string4, DataSource.class, new Object[0]);
            PropertyElf.setTargetFromProperties(dataSource, properties);
        } else if (string != null && dataSource == null) {
            dataSource = new DriverDataSource(string, string5, properties, string2, string3);
        } else if (string6 != null && dataSource == null) {
            try {
                InitialContext initialContext = new InitialContext();
                dataSource = (DataSource)initialContext.lookup(string6);
            }
            catch (NamingException namingException) {
                throw new HikariPool.PoolInitializationException(namingException);
            }
        }
        if (dataSource != null) {
            this.GAGFH(dataSource);
            this.GAGFH(dataSource, string4, string);
        }
        this.antrD = dataSource;
    }

    private Connection EMqEv() {
        long l = ClockSource.currentTime();
        Connection connection = null;
        try {
            String string = this.config.getUsername();
            String string2 = this.config.getPassword();
            Connection connection2 = connection = string == null ? this.antrD.getConnection() : this.antrD.getConnection(string, string2);
            if (connection == null) {
                throw new SQLTransientConnectionException("DataSource returned null unexpectedly");
            }
            this.Srqvu(connection);
            this.qGVpb.set(null);
            Connection connection3 = connection;
            return connection3;
        }
        catch (Exception exception) {
            if (connection != null) {
                this.GAGFH(connection, "(Failed to create/setup connection)");
            } else if (this.Srqvu() == null) {
                this.mToYg.debug("{} - Failed to create/setup connection: {}", (Object)this.poolName, (Object)exception.getMessage());
            }
            this.qGVpb.set(exception);
            throw exception;
        }
        finally {
            if (this.GAGFH != null) {
                this.GAGFH.recordConnectionCreated(ClockSource.elapsedMillis(l));
            }
        }
    }

    private void Srqvu(Connection connection) {
        try {
            if (this.WAGHG == -1) {
                this.WAGHG = this.GAGFH(connection, this.lwJV);
            } else {
                this.Srqvu(connection, this.lwJV);
            }
            if (connection.isReadOnly() != this.XiKV) {
                connection.setReadOnly(this.XiKV);
            }
            if (connection.getAutoCommit() != this.knAZu) {
                connection.setAutoCommit(this.knAZu);
            }
            this.qGVpb(connection);
            if (this.hPPy != this.VyMXK) {
                connection.setTransactionIsolation(this.hPPy);
            }
            if (this.Srqvu != null) {
                connection.setCatalog(this.Srqvu);
            }
            if (this.NIzf != null) {
                connection.setSchema(this.NIzf);
            }
            this.GAGFH(connection, this.config.getConnectionInitSql(), true);
            this.Srqvu(connection, this.WAGHG);
        }
        catch (SQLException sQLException) {
            throw new ConnectionSetupException(sQLException);
        }
    }

    private void qGVpb(Connection connection) {
        if (!this.QdTwu) {
            this.Lqpzc(connection);
            this.lwJV(connection);
            this.QdTwu = true;
        }
    }

    private void Lqpzc(Connection connection) {
        try {
            if (this.Yhbnj) {
                connection.isValid(1);
            } else {
                this.GAGFH(connection, this.config.getConnectionTestQuery(), false);
            }
        }
        catch (AbstractMethodError | Exception throwable) {
            this.mToYg.error("{} - Failed to execute{} connection test query ({}).", this.poolName, this.Yhbnj ? " isValid() for connection, configure" : "", throwable.getMessage());
            throw throwable;
        }
    }

    private void lwJV(Connection connection) {
        block3: {
            try {
                this.VyMXK = connection.getTransactionIsolation();
                if (this.hPPy == -1) {
                    this.hPPy = this.VyMXK;
                }
            }
            catch (SQLException sQLException) {
                this.mToYg.warn("{} - Default transaction isolation level detection failed ({}).", (Object)this.poolName, (Object)sQLException.getMessage());
                if (sQLException.getSQLState() == null || sQLException.getSQLState().startsWith("08")) break block3;
                throw sQLException;
            }
        }
    }

    private void GAGFH(Statement statement, int n) {
        block3: {
            if (this.yfrbP != 0) {
                try {
                    statement.setQueryTimeout(n);
                    this.yfrbP = 1;
                }
                catch (Exception exception) {
                    if (this.yfrbP != -1) break block3;
                    this.yfrbP = 0;
                    this.mToYg.info("{} - Failed to set query timeout for statement. ({})", (Object)this.poolName, (Object)exception.getMessage());
                }
            }
        }
    }

    private int GAGFH(Connection connection, long l) {
        block4: {
            if (this.UyMP != 0) {
                try {
                    int n = connection.getNetworkTimeout();
                    connection.setNetworkTimeout(this.UQQfL, (int)l);
                    this.UyMP = 1;
                    return n;
                }
                catch (AbstractMethodError | Exception throwable) {
                    if (this.UyMP != -1) break block4;
                    this.UyMP = 0;
                    this.mToYg.info("{} - Driver does not support get/set network timeout for connections. ({})", (Object)this.poolName, (Object)throwable.getMessage());
                    if (this.lwJV < TimeUnit.SECONDS.toMillis(1L)) {
                        this.mToYg.warn("{} - A validationTimeout of less than 1 second cannot be honored on drivers without setNetworkTimeout() support.", (Object)this.poolName);
                    }
                    if (this.lwJV % TimeUnit.SECONDS.toMillis(1L) == 0L) break block4;
                    this.mToYg.warn("{} - A validationTimeout with fractional second granularity cannot be honored on drivers without setNetworkTimeout() support.", (Object)this.poolName);
                }
            }
        }
        return 0;
    }

    private void Srqvu(Connection connection, long l) {
        if (this.UyMP == 1) {
            connection.setNetworkTimeout(this.UQQfL, (int)l);
        }
    }

    private void GAGFH(Connection connection, String string, boolean bl) {
        if (string != null) {
            try (Statement statement = connection.createStatement();){
                statement.execute(string);
            }
            if (this.fDxZ && !this.knAZu) {
                if (bl) {
                    connection.commit();
                } else {
                    connection.rollback();
                }
            }
        }
    }

    private void GAGFH(DataSource dataSource, String string, String string2) {
        if (string != null && string.contains("Mysql") || string2 != null && string2.contains("mysql") || dataSource != null && dataSource.getClass().getName().contains("Mysql")) {
            this.UQQfL = new SynchronousExecutor();
        } else {
            ThreadFactory threadFactory = this.config.getThreadFactory();
            threadFactory = threadFactory != null ? threadFactory : new UtilityElf.DefaultThreadFactory(this.poolName + " network timeout executor", true);
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)Executors.newCachedThreadPool(threadFactory);
            threadPoolExecutor.setKeepAliveTime(15L, TimeUnit.SECONDS);
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            this.UQQfL = threadPoolExecutor;
        }
    }

    private void GAGFH(DataSource dataSource) {
        if (this.Lqpzc != Integer.MAX_VALUE) {
            try {
                dataSource.setLoginTimeout(Math.max(1, (int)TimeUnit.MILLISECONDS.toSeconds(500L + this.Lqpzc)));
            }
            catch (Exception exception) {
                this.mToYg.info("{} - Failed to set login timeout for data source. ({})", (Object)this.poolName, (Object)exception.getMessage());
            }
        }
    }

    private String GAGFH(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < aazaq.length; ++i) {
            if ((n & 1 << i) == 0) continue;
            stringBuilder.append(aazaq[i]).append(", ");
        }
        stringBuilder.setLength(stringBuilder.length() - 2);
        return stringBuilder.toString();
    }

    static final class NopMetricsTrackerDelegate
    implements IMetricsTrackerDelegate {
        NopMetricsTrackerDelegate() {
        }
    }

    static class MetricsTrackerDelegate
    implements IMetricsTrackerDelegate {
        final IMetricsTracker GAGFH;

        MetricsTrackerDelegate(IMetricsTracker iMetricsTracker) {
            this.GAGFH = iMetricsTracker;
        }

        @Override
        public void recordConnectionUsage(PoolEntry poolEntry) {
            this.GAGFH.recordConnectionUsageMillis(poolEntry.Lqpzc());
        }

        @Override
        public void recordConnectionCreated(long l) {
            this.GAGFH.recordConnectionCreatedMillis(l);
        }

        @Override
        public void recordBorrowTimeoutStats(long l) {
            this.GAGFH.recordConnectionAcquiredNanos(ClockSource.elapsedNanos(l));
        }

        @Override
        public void recordBorrowStats(PoolEntry poolEntry, long l) {
            long l2;
            poolEntry.qGVpb = l2 = ClockSource.currentTime();
            this.GAGFH.recordConnectionAcquiredNanos(ClockSource.elapsedNanos(l, l2));
        }

        @Override
        public void recordConnectionTimeout() {
            this.GAGFH.recordConnectionTimeout();
        }

        @Override
        public void close() {
            this.GAGFH.close();
        }
    }

    static interface IMetricsTrackerDelegate
    extends AutoCloseable {
        default public void recordConnectionUsage(PoolEntry poolEntry) {
        }

        default public void recordConnectionCreated(long connectionCreatedMillis) {
        }

        default public void recordBorrowTimeoutStats(long startTime) {
        }

        default public void recordBorrowStats(PoolEntry poolEntry, long startTime) {
        }

        default public void recordConnectionTimeout() {
        }

        @Override
        default public void close() {
        }
    }

    private static class SynchronousExecutor
    implements Executor {
        private SynchronousExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                LoggerFactory.getLogger(PoolBase.class).debug("Failed to execute: {}", (Object)runnable, (Object)exception);
            }
        }
    }

    static class ConnectionSetupException
    extends Exception {
        private static final long GAGFH = 929872118275916521L;

        ConnectionSetupException(Throwable throwable) {
            super(throwable);
        }
    }
}

