/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablehoppers.hikari.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Collectors;
import me.angeschossen.upgradeablehoppers.hikari.util.ClockSource;
import me.angeschossen.upgradeablehoppers.hikari.util.FastList;
import me.angeschossen.upgradeablehoppers.slf4j.Logger;
import me.angeschossen.upgradeablehoppers.slf4j.LoggerFactory;

public class ConcurrentBag<T extends IConcurrentBagEntry>
implements AutoCloseable {
    private static final Logger GAGFH = LoggerFactory.getLogger(ConcurrentBag.class);
    private final CopyOnWriteArrayList<T> Srqvu;
    private final boolean qGVpb;
    private final ThreadLocal<List<Object>> Lqpzc;
    private final IBagStateListener lwJV;
    private final AtomicInteger EMqEv;
    private volatile boolean mToYg;
    private final SynchronousQueue<T> aazaq;

    public ConcurrentBag(IBagStateListener iBagStateListener) {
        this.lwJV = iBagStateListener;
        this.qGVpb = this.GAGFH();
        this.aazaq = new SynchronousQueue(true);
        this.EMqEv = new AtomicInteger();
        this.Srqvu = new CopyOnWriteArrayList();
        this.Lqpzc = this.qGVpb ? ThreadLocal.withInitial(() -> new ArrayList(16)) : ThreadLocal.withInitial(() -> new FastList(IConcurrentBagEntry.class, 16));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T borrow(long l, TimeUnit timeUnit) {
        int n;
        List<Object> list = this.Lqpzc.get();
        for (n = list.size() - 1; n >= 0; --n) {
            IConcurrentBagEntry iConcurrentBagEntry;
            Iterator<T> iterator = list.remove(n);
            IConcurrentBagEntry iConcurrentBagEntry2 = iConcurrentBagEntry = this.qGVpb ? (IConcurrentBagEntry)((WeakReference)((Object)iterator)).get() : (IConcurrentBagEntry)((Object)iterator);
            if (iConcurrentBagEntry == null || !iConcurrentBagEntry.compareAndSet(0, 1)) continue;
            return (T)iConcurrentBagEntry;
        }
        n = this.EMqEv.incrementAndGet();
        try {
            long l2;
            for (IConcurrentBagEntry iConcurrentBagEntry : this.Srqvu) {
                if (!iConcurrentBagEntry.compareAndSet(0, 1)) continue;
                if (n > 1) {
                    this.lwJV.addBagItem(n - 1);
                }
                IConcurrentBagEntry iConcurrentBagEntry3 = iConcurrentBagEntry;
                return (T)iConcurrentBagEntry3;
            }
            this.lwJV.addBagItem(n);
            l = timeUnit.toNanos(l);
            do {
                l2 = ClockSource.currentTime();
                IConcurrentBagEntry iConcurrentBagEntry = (IConcurrentBagEntry)this.aazaq.poll(l, TimeUnit.NANOSECONDS);
                if (iConcurrentBagEntry != null && !iConcurrentBagEntry.compareAndSet(0, 1)) continue;
                IConcurrentBagEntry iConcurrentBagEntry4 = iConcurrentBagEntry;
                return (T)iConcurrentBagEntry4;
            } while ((l -= ClockSource.elapsedNanos(l2)) > 10000L);
            T t = null;
            return t;
        }
        finally {
            this.EMqEv.decrementAndGet();
        }
    }

    public void requite(T t) {
        t.setState(0);
        int n = 0;
        while (this.EMqEv.get() > 0) {
            if (t.getState() != 0 || this.aazaq.offer(t)) {
                return;
            }
            if ((n & 0xFF) == 255) {
                LockSupport.parkNanos(TimeUnit.MICROSECONDS.toNanos(10L));
            } else {
                Thread.yield();
            }
            ++n;
        }
        List<Object> list = this.Lqpzc.get();
        if (list.size() < 50) {
            list.add(this.qGVpb ? new WeakReference<T>(t) : t);
        }
    }

    public void add(T t) {
        if (this.mToYg) {
            GAGFH.info("ConcurrentBag has been closed, ignoring add()");
            throw new IllegalStateException("ConcurrentBag has been closed, ignoring add()");
        }
        this.Srqvu.add(t);
        while (this.EMqEv.get() > 0 && t.getState() == 0 && !this.aazaq.offer(t)) {
            Thread.yield();
        }
    }

    public boolean remove(T t) {
        if (!(t.compareAndSet(1, -1) || t.compareAndSet(-2, -1) || this.mToYg)) {
            GAGFH.warn("Attempt to remove an object from the bag that was not borrowed or reserved: {}", (Object)t);
            return false;
        }
        boolean bl = this.Srqvu.remove(t);
        if (!bl && !this.mToYg) {
            GAGFH.warn("Attempt to remove an object from the bag that does not exist: {}", (Object)t);
        }
        this.Lqpzc.get().remove(t);
        return bl;
    }

    @Override
    public void close() {
        this.mToYg = true;
    }

    public List<T> values(int n) {
        List list = this.Srqvu.stream().filter(iConcurrentBagEntry -> iConcurrentBagEntry.getState() == n).collect(Collectors.toList());
        Collections.reverse(list);
        return list;
    }

    public List<T> values() {
        return (List)this.Srqvu.clone();
    }

    public boolean reserve(T t) {
        return t.compareAndSet(0, -2);
    }

    public void unreserve(T t) {
        if (t.compareAndSet(-2, 0)) {
            while (this.EMqEv.get() > 0 && !this.aazaq.offer(t)) {
                Thread.yield();
            }
        } else {
            GAGFH.warn("Attempt to relinquish an object to the bag that was not reserved: {}", (Object)t);
        }
    }

    public int getWaitingThreadCount() {
        return this.EMqEv.get();
    }

    public int getCount(int n) {
        int n2 = 0;
        for (IConcurrentBagEntry iConcurrentBagEntry : this.Srqvu) {
            if (iConcurrentBagEntry.getState() != n) continue;
            ++n2;
        }
        return n2;
    }

    public int[] getStateCounts() {
        int[] nArray = new int[6];
        for (IConcurrentBagEntry iConcurrentBagEntry : this.Srqvu) {
            int n = iConcurrentBagEntry.getState();
            nArray[n] = nArray[n] + 1;
        }
        nArray[4] = this.Srqvu.size();
        nArray[5] = this.EMqEv.get();
        return nArray;
    }

    public int size() {
        return this.Srqvu.size();
    }

    public void dumpState() {
        this.Srqvu.forEach(iConcurrentBagEntry -> GAGFH.info(iConcurrentBagEntry.toString()));
    }

    private boolean GAGFH() {
        try {
            if (System.getProperty("me.angeschossen.upgradeablehoppers.hikari.useWeakReferences") != null) {
                return Boolean.getBoolean("me.angeschossen.upgradeablehoppers.hikari.useWeakReferences");
            }
            return this.getClass().getClassLoader() != ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException securityException) {
            return true;
        }
    }

    public static interface IBagStateListener {
        public void addBagItem(int var1);
    }

    public static interface IConcurrentBagEntry {
        public static final int STATE_NOT_IN_USE = 0;
        public static final int STATE_IN_USE = 1;
        public static final int STATE_REMOVED = -1;
        public static final int STATE_RESERVED = -2;

        public boolean compareAndSet(int var1, int var2);

        public void setState(int var1);

        public int getState();
    }
}

