/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.internal;

import ia.sh.com.jayway.jsonpath.Configuration;
import ia.sh.com.jayway.jsonpath.DocumentContext;
import ia.sh.com.jayway.jsonpath.EvaluationListener;
import ia.sh.com.jayway.jsonpath.JsonPath;
import ia.sh.com.jayway.jsonpath.MapFunction;
import ia.sh.com.jayway.jsonpath.Option;
import ia.sh.com.jayway.jsonpath.Predicate;
import ia.sh.com.jayway.jsonpath.ReadContext;
import ia.sh.com.jayway.jsonpath.TypeRef;
import ia.sh.com.jayway.jsonpath.internal.JsonContext$LimitingEvaluationListener;
import ia.sh.com.jayway.jsonpath.internal.Utils;
import ia.sh.com.jayway.jsonpath.spi.cache.Cache;
import ia.sh.com.jayway.jsonpath.spi.cache.CacheProvider;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonContext
implements DocumentContext {
    private static final Logger logger = LoggerFactory.getLogger(JsonContext.class);
    private final Configuration configuration;
    private final Object json;

    JsonContext(Object object, Configuration configuration) {
        Utils.notNull(object, "json can not be null");
        Utils.notNull(configuration, "configuration can not be null");
        this.configuration = configuration;
        this.json = object;
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }

    @Override
    public Object json() {
        return this.json;
    }

    @Override
    public String jsonString() {
        return this.configuration.jsonProvider().toJson(this.json);
    }

    @Override
    public Object read(String string, Predicate ... predicateArray) {
        Utils.notEmpty(string, "path can not be null or empty");
        return this.read(this.pathFromCache(string, predicateArray));
    }

    @Override
    public Object read(String string, Class clazz, Predicate ... predicateArray) {
        return this.convert(this.read(string, predicateArray), clazz, this.configuration);
    }

    @Override
    public Object read(JsonPath jsonPath) {
        Utils.notNull(jsonPath, "path can not be null");
        return jsonPath.read(this.json, this.configuration);
    }

    @Override
    public Object read(JsonPath jsonPath, Class clazz) {
        return this.convert(this.read(jsonPath), clazz, this.configuration);
    }

    @Override
    public Object read(JsonPath jsonPath, TypeRef typeRef) {
        return this.convert(this.read(jsonPath), typeRef, this.configuration);
    }

    @Override
    public Object read(String string, TypeRef typeRef) {
        return this.convert(this.read(string, new Predicate[0]), typeRef, this.configuration);
    }

    @Override
    public ReadContext limit(int n2) {
        return this.withListeners(new JsonContext$LimitingEvaluationListener(n2, null));
    }

    @Override
    public ReadContext withListeners(EvaluationListener ... evaluationListenerArray) {
        return new JsonContext(this.json, this.configuration.setEvaluationListeners(evaluationListenerArray));
    }

    private Object convert(Object object, Class clazz, Configuration configuration) {
        return configuration.mappingProvider().map(object, clazz, configuration);
    }

    private Object convert(Object object, TypeRef typeRef, Configuration configuration) {
        return configuration.mappingProvider().map(object, typeRef, configuration);
    }

    @Override
    public DocumentContext set(String string, Object object, Predicate ... predicateArray) {
        return this.set(this.pathFromCache(string, predicateArray), object);
    }

    @Override
    public DocumentContext set(JsonPath jsonPath, Object object) {
        List list = (List)jsonPath.set(this.json, object, this.configuration.addOptions(Option.AS_PATH_LIST));
        if (logger.isDebugEnabled()) {
            for (String string : list) {
                logger.debug("Set path {} new value {}", (Object)string, object);
            }
        }
        return this;
    }

    @Override
    public DocumentContext map(String string, MapFunction mapFunction, Predicate ... predicateArray) {
        this.map(this.pathFromCache(string, predicateArray), mapFunction);
        return this;
    }

    @Override
    public DocumentContext map(JsonPath jsonPath, MapFunction mapFunction) {
        Object object = jsonPath.map(this.json, mapFunction, this.configuration);
        return object == null ? null : this;
    }

    @Override
    public DocumentContext delete(String string, Predicate ... predicateArray) {
        return this.delete(this.pathFromCache(string, predicateArray));
    }

    @Override
    public DocumentContext delete(JsonPath jsonPath) {
        List list = (List)jsonPath.delete(this.json, this.configuration.addOptions(Option.AS_PATH_LIST));
        if (logger.isDebugEnabled()) {
            for (String string : list) {
                logger.debug("Delete path {}", (Object)string);
            }
        }
        return this;
    }

    @Override
    public DocumentContext add(String string, Object object, Predicate ... predicateArray) {
        return this.add(this.pathFromCache(string, predicateArray), object);
    }

    @Override
    public DocumentContext add(JsonPath jsonPath, Object object) {
        List list = (List)jsonPath.add(this.json, object, this.configuration.addOptions(Option.AS_PATH_LIST));
        if (logger.isDebugEnabled()) {
            for (String string : list) {
                logger.debug("Add path {} new value {}", (Object)string, object);
            }
        }
        return this;
    }

    @Override
    public DocumentContext put(String string, String string2, Object object, Predicate ... predicateArray) {
        return this.put(this.pathFromCache(string, predicateArray), string2, object);
    }

    @Override
    public DocumentContext renameKey(String string, String string2, String string3, Predicate ... predicateArray) {
        return this.renameKey(this.pathFromCache(string, predicateArray), string2, string3);
    }

    @Override
    public DocumentContext renameKey(JsonPath jsonPath, String string, String string2) {
        List list = (List)jsonPath.renameKey(this.json, string, string2, this.configuration.addOptions(Option.AS_PATH_LIST));
        if (logger.isDebugEnabled()) {
            for (String string3 : list) {
                logger.debug("Rename path {} new value {}", (Object)string3, (Object)string2);
            }
        }
        return this;
    }

    @Override
    public DocumentContext put(JsonPath jsonPath, String string, Object object) {
        List list = (List)jsonPath.put(this.json, string, object, this.configuration.addOptions(Option.AS_PATH_LIST));
        if (logger.isDebugEnabled()) {
            for (String string2 : list) {
                logger.debug("Put path {} key {} value {}", new Object[]{string2, string, object});
            }
        }
        return this;
    }

    private JsonPath pathFromCache(String string, Predicate[] predicateArray) {
        String string2;
        Cache cache = CacheProvider.getCache();
        JsonPath jsonPath = cache.get(string2 = predicateArray == null || predicateArray.length == 0 ? string : Utils.concat(string, Arrays.toString(predicateArray)));
        if (jsonPath == null) {
            jsonPath = JsonPath.compile(string, predicateArray);
            cache.put(string2, jsonPath);
        }
        return jsonPath;
    }
}

