/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.internal.filter;

import ia.sh.com.jayway.jsonpath.Predicate$PredicateContext;
import ia.sh.com.jayway.jsonpath.internal.Utils;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNode;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNodes$NumberNode;
import java.math.BigDecimal;

public class ValueNodes$StringNode
extends ValueNode {
    private final String string;
    private boolean useSingleQuote = true;

    ValueNodes$StringNode(CharSequence charSequence, boolean bl2) {
        if (bl2 && charSequence.length() > 1) {
            char c2 = charSequence.charAt(0);
            char c3 = charSequence.charAt(charSequence.length() - 1);
            if (c2 == '\'' && c3 == '\'') {
                charSequence = charSequence.subSequence(1, charSequence.length() - 1);
            } else if (c2 == '\"' && c3 == '\"') {
                charSequence = charSequence.subSequence(1, charSequence.length() - 1);
                this.useSingleQuote = false;
            }
            this.string = Utils.unescape(charSequence.toString());
        } else {
            this.string = charSequence.toString();
        }
    }

    @Override
    public ValueNodes$NumberNode asNumberNode() {
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(this.string);
        }
        catch (NumberFormatException numberFormatException) {
            return ValueNodes$NumberNode.NAN;
        }
        return new ValueNodes$NumberNode(bigDecimal);
    }

    public String getString() {
        return this.string;
    }

    public int length() {
        return this.getString().length();
    }

    public boolean isEmpty() {
        return this.getString().isEmpty();
    }

    public boolean contains(String string) {
        return this.getString().contains(string);
    }

    @Override
    public Class type(Predicate$PredicateContext predicate$PredicateContext) {
        return String.class;
    }

    @Override
    public boolean isStringNode() {
        return true;
    }

    @Override
    public ValueNodes$StringNode asStringNode() {
        return this;
    }

    public String toString() {
        String string = this.useSingleQuote ? "'" : "\"";
        return string + Utils.escape(this.string, true) + string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ValueNodes$StringNode) && !(object instanceof ValueNodes$NumberNode)) {
            return false;
        }
        ValueNodes$StringNode valueNodes$StringNode = ((ValueNode)object).asStringNode();
        return !(this.string == null ? valueNodes$StringNode.getString() != null : !this.string.equals(valueNodes$StringNode.getString()));
    }
}

