/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.internal.function;

import ia.sh.com.jayway.jsonpath.InvalidPathException;
import ia.sh.com.jayway.jsonpath.internal.function.PathFunction;
import ia.sh.com.jayway.jsonpath.internal.function.json.Append;
import ia.sh.com.jayway.jsonpath.internal.function.json.KeySetFunction;
import ia.sh.com.jayway.jsonpath.internal.function.numeric.Average;
import ia.sh.com.jayway.jsonpath.internal.function.numeric.Max;
import ia.sh.com.jayway.jsonpath.internal.function.numeric.Min;
import ia.sh.com.jayway.jsonpath.internal.function.numeric.StandardDeviation;
import ia.sh.com.jayway.jsonpath.internal.function.numeric.Sum;
import ia.sh.com.jayway.jsonpath.internal.function.text.Concatenate;
import ia.sh.com.jayway.jsonpath.internal.function.text.Length;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PathFunctionFactory {
    public static final Map FUNCTIONS;

    public static PathFunction newFunction(String string) {
        Class clazz = (Class)FUNCTIONS.get(string);
        if (clazz == null) {
            throw new InvalidPathException("Function with name: " + string + " does not exist.");
        }
        try {
            return (PathFunction)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new InvalidPathException("Function of name: " + string + " cannot be created", exception);
        }
    }

    static {
        HashMap<String, Class<KeySetFunction>> hashMap = new HashMap<String, Class<KeySetFunction>>();
        hashMap.put("avg", Average.class);
        hashMap.put("stddev", StandardDeviation.class);
        hashMap.put("sum", Sum.class);
        hashMap.put("min", Min.class);
        hashMap.put("max", Max.class);
        hashMap.put("concat", Concatenate.class);
        hashMap.put("length", Length.class);
        hashMap.put("size", Length.class);
        hashMap.put("append", Append.class);
        hashMap.put("keys", KeySetFunction.class);
        FUNCTIONS = Collections.unmodifiableMap(hashMap);
    }
}

