/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.internal.path;

import ia.sh.com.jayway.jsonpath.InvalidPathException;
import ia.sh.com.jayway.jsonpath.internal.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class ArrayIndexOperation {
    private static final Pattern COMMA = Pattern.compile("\\s*,\\s*");
    private final List indexes;

    private ArrayIndexOperation(List list) {
        this.indexes = Collections.unmodifiableList(list);
    }

    public List indexes() {
        return this.indexes;
    }

    public boolean isSingleIndexOperation() {
        return this.indexes.size() == 1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(Utils.join(",", this.indexes));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static ArrayIndexOperation parse(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isDigit(c2) || c2 == ',' || c2 == ' ' || c2 == '-') continue;
            throw new InvalidPathException("Failed to parse ArrayIndexOperation: " + string);
        }
        String[] stringArray = COMMA.split(string, -1);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(stringArray.length);
        for (String string2 : stringArray) {
            arrayList.add(ArrayIndexOperation.parseInteger(string2));
        }
        return new ArrayIndexOperation(arrayList);
    }

    private static Integer parseInteger(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new InvalidPathException("Failed to parse token in ArrayIndexOperation: " + string, exception);
        }
    }
}

