/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.internal.path;

import ia.sh.com.jayway.jsonpath.InvalidPathException;
import ia.sh.com.jayway.jsonpath.internal.path.ArraySliceOperation$Operation;

public class ArraySliceOperation {
    private final Integer from;
    private final Integer to;
    private final ArraySliceOperation$Operation operation;

    private ArraySliceOperation(Integer n2, Integer n3, ArraySliceOperation$Operation arraySliceOperation$Operation) {
        this.from = n2;
        this.to = n3;
        this.operation = arraySliceOperation$Operation;
    }

    public Integer from() {
        return this.from;
    }

    public Integer to() {
        return this.to;
    }

    public ArraySliceOperation$Operation operation() {
        return this.operation;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(this.from == null ? "" : this.from.toString());
        stringBuilder.append(":");
        stringBuilder.append(this.to == null ? "" : this.to.toString());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static ArraySliceOperation parse(String string) {
        ArraySliceOperation$Operation arraySliceOperation$Operation;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isDigit(c2) || c2 == '-' || c2 == ':') continue;
            throw new InvalidPathException("Failed to parse SliceOperation: " + string);
        }
        String[] stringArray = string.split(":");
        Integer n2 = ArraySliceOperation.tryRead(stringArray, 0);
        Integer n3 = ArraySliceOperation.tryRead(stringArray, 1);
        if (n2 != null && n3 == null) {
            arraySliceOperation$Operation = ArraySliceOperation$Operation.SLICE_FROM;
        } else if (n2 != null) {
            arraySliceOperation$Operation = ArraySliceOperation$Operation.SLICE_BETWEEN;
        } else if (n3 != null) {
            arraySliceOperation$Operation = ArraySliceOperation$Operation.SLICE_TO;
        } else {
            throw new InvalidPathException("Failed to parse SliceOperation: " + string);
        }
        return new ArraySliceOperation(n2, n3, arraySliceOperation$Operation);
    }

    private static Integer tryRead(String[] stringArray, int n2) {
        if (stringArray.length > n2) {
            if (stringArray[n2].equals("")) {
                return null;
            }
            return Integer.parseInt(stringArray[n2]);
        }
        return null;
    }
}

