/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.internal.path;

import ia.sh.com.jayway.jsonpath.Configuration;
import ia.sh.com.jayway.jsonpath.EvaluationListener;
import ia.sh.com.jayway.jsonpath.EvaluationListener$EvaluationContinuation;
import ia.sh.com.jayway.jsonpath.Option;
import ia.sh.com.jayway.jsonpath.PathNotFoundException;
import ia.sh.com.jayway.jsonpath.internal.EvaluationAbortException;
import ia.sh.com.jayway.jsonpath.internal.EvaluationContext;
import ia.sh.com.jayway.jsonpath.internal.Path;
import ia.sh.com.jayway.jsonpath.internal.PathRef;
import ia.sh.com.jayway.jsonpath.internal.Utils;
import ia.sh.com.jayway.jsonpath.internal.path.CompiledPath;
import ia.sh.com.jayway.jsonpath.internal.path.EvaluationContextImpl$FoundResultImpl;
import ia.sh.com.jayway.jsonpath.internal.path.RootPathToken;
import ia.sh.com.jayway.jsonpath.spi.json.JsonProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class EvaluationContextImpl
implements EvaluationContext {
    private static final EvaluationAbortException ABORT_EVALUATION = new EvaluationAbortException();
    private final Configuration configuration;
    private final Object valueResult;
    private final Object pathResult;
    private final Path path;
    private final Object rootDocument;
    private final List updateOperations;
    private final HashMap documentEvalCache = new HashMap();
    private final boolean forUpdate;
    private final boolean suppressExceptions;
    private int resultIndex = 0;

    public RootPathToken getRoot() {
        return ((CompiledPath)this.path).getRoot();
    }

    public EvaluationContextImpl(Path path, Object object, Configuration configuration, boolean bl2) {
        Utils.notNull(path, "path can not be null");
        Utils.notNull(object, "root can not be null");
        Utils.notNull(configuration, "configuration can not be null");
        this.forUpdate = bl2;
        this.path = path;
        this.rootDocument = object;
        this.configuration = configuration;
        this.valueResult = configuration.jsonProvider().createArray();
        this.pathResult = configuration.jsonProvider().createArray();
        this.updateOperations = new ArrayList();
        this.suppressExceptions = configuration.containsOption(Option.SUPPRESS_EXCEPTIONS);
    }

    public HashMap documentEvalCache() {
        return this.documentEvalCache;
    }

    public boolean forUpdate() {
        return this.forUpdate;
    }

    public void addResult(String string, PathRef pathRef, Object object) {
        if (this.forUpdate) {
            this.updateOperations.add(pathRef);
        }
        this.configuration.jsonProvider().setArrayIndex(this.valueResult, this.resultIndex, object);
        this.configuration.jsonProvider().setArrayIndex(this.pathResult, this.resultIndex, string);
        ++this.resultIndex;
        if (!this.configuration().getEvaluationListeners().isEmpty()) {
            int n2 = this.resultIndex - 1;
            for (EvaluationListener evaluationListener : this.configuration().getEvaluationListeners()) {
                EvaluationListener$EvaluationContinuation evaluationListener$EvaluationContinuation = evaluationListener.resultFound(new EvaluationContextImpl$FoundResultImpl(n2, string, object, null));
                if (EvaluationListener$EvaluationContinuation.ABORT != evaluationListener$EvaluationContinuation) continue;
                throw ABORT_EVALUATION;
            }
        }
    }

    public JsonProvider jsonProvider() {
        return this.configuration.jsonProvider();
    }

    public Set options() {
        return this.configuration.getOptions();
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }

    @Override
    public Object rootDocument() {
        return this.rootDocument;
    }

    @Override
    public Collection updateOperations() {
        Collections.sort(this.updateOperations);
        return Collections.unmodifiableCollection(this.updateOperations);
    }

    @Override
    public Object getValue() {
        return this.getValue(true);
    }

    @Override
    public Object getValue(boolean bl2) {
        if (this.path.isDefinite()) {
            Object object;
            if (this.resultIndex == 0) {
                if (this.suppressExceptions) {
                    return null;
                }
                throw new PathNotFoundException("No results for path: " + this.path.toString());
            }
            int n2 = this.jsonProvider().length(this.valueResult);
            Object object2 = object = n2 > 0 ? this.jsonProvider().getArrayIndex(this.valueResult, n2 - 1) : null;
            if (object != null && bl2) {
                object = this.jsonProvider().unwrap(object);
            }
            return object;
        }
        return this.valueResult;
    }

    @Override
    public Object getPath() {
        if (this.resultIndex == 0) {
            if (this.suppressExceptions) {
                return null;
            }
            throw new PathNotFoundException("No results for path: " + this.path.toString());
        }
        return this.pathResult;
    }

    @Override
    public List getPathList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.resultIndex > 0) {
            Iterable iterable = this.configuration.jsonProvider().toIterable(this.pathResult);
            for (Object t2 : iterable) {
                arrayList.add((String)t2);
            }
        }
        return arrayList;
    }
}

