/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.internal.path;

import ia.sh.com.jayway.jsonpath.internal.PathRef;
import ia.sh.com.jayway.jsonpath.internal.function.Parameter;
import ia.sh.com.jayway.jsonpath.internal.function.PathFunction;
import ia.sh.com.jayway.jsonpath.internal.function.PathFunctionFactory;
import ia.sh.com.jayway.jsonpath.internal.function.latebinding.JsonLateBindingValue;
import ia.sh.com.jayway.jsonpath.internal.function.latebinding.PathLateBindingValue;
import ia.sh.com.jayway.jsonpath.internal.path.EvaluationContextImpl;
import ia.sh.com.jayway.jsonpath.internal.path.PathToken;
import java.util.List;

public class FunctionPathToken
extends PathToken {
    private final String functionName;
    private final String pathFragment;
    private List functionParams;

    public FunctionPathToken(String string, List list) {
        this.pathFragment = string + (list != null && list.size() > 0 ? "(...)" : "()");
        if (null != string) {
            this.functionName = string;
            this.functionParams = list;
        } else {
            this.functionName = null;
            this.functionParams = null;
        }
    }

    @Override
    public void evaluate(String string, PathRef pathRef, Object object, EvaluationContextImpl evaluationContextImpl) {
        PathFunction pathFunction = PathFunctionFactory.newFunction(this.functionName);
        this.evaluateParameters(string, pathRef, object, evaluationContextImpl);
        Object object2 = pathFunction.invoke(string, pathRef, object, evaluationContextImpl, this.functionParams);
        evaluationContextImpl.addResult(string + "." + this.functionName, pathRef, object2);
        if (!this.isLeaf()) {
            this.next().evaluate(string, pathRef, object2, evaluationContextImpl);
        }
    }

    private void evaluateParameters(String string, PathRef pathRef, Object object, EvaluationContextImpl evaluationContextImpl) {
        if (null != this.functionParams) {
            for (Parameter parameter : this.functionParams) {
                switch (parameter.getType()) {
                    case PATH: {
                        PathLateBindingValue pathLateBindingValue = new PathLateBindingValue(parameter.getPath(), evaluationContextImpl.rootDocument(), evaluationContextImpl.configuration());
                        if (parameter.hasEvaluated() && pathLateBindingValue.equals(parameter.getILateBingValue())) break;
                        parameter.setLateBinding(pathLateBindingValue);
                        parameter.setEvaluated(true);
                        break;
                    }
                    case JSON: {
                        if (parameter.hasEvaluated()) break;
                        parameter.setLateBinding(new JsonLateBindingValue(evaluationContextImpl.configuration().jsonProvider(), parameter));
                        parameter.setEvaluated(true);
                    }
                }
            }
        }
    }

    @Override
    public boolean isTokenDefinite() {
        return true;
    }

    @Override
    public String getPathFragment() {
        return "." + this.pathFragment;
    }

    public void setParameters(List list) {
        this.functionParams = list;
    }

    public List getParameters() {
        return this.functionParams;
    }

    public String getFunctionName() {
        return this.functionName;
    }
}

