/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.spi.cache;

import ia.sh.com.jayway.jsonpath.JsonPath;
import ia.sh.com.jayway.jsonpath.spi.cache.Cache;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class LRUCache
implements Cache {
    private final ReentrantLock lock = new ReentrantLock();
    private final Map map = new ConcurrentHashMap();
    private final Deque queue = new LinkedList();
    private final int limit;

    public LRUCache(int n2) {
        this.limit = n2;
    }

    @Override
    public void put(String string, JsonPath jsonPath) {
        JsonPath jsonPath2 = this.map.put(string, jsonPath);
        if (jsonPath2 != null) {
            this.removeThenAddKey(string);
        } else {
            this.addKey(string);
        }
        if (this.map.size() > this.limit) {
            this.map.remove(this.removeLast());
        }
    }

    @Override
    public JsonPath get(String string) {
        JsonPath jsonPath = (JsonPath)this.map.get(string);
        if (jsonPath != null) {
            this.removeThenAddKey(string);
        }
        return jsonPath;
    }

    private void addKey(String string) {
        this.lock.lock();
        try {
            this.queue.addFirst(string);
        }
        finally {
            this.lock.unlock();
        }
    }

    private String removeLast() {
        this.lock.lock();
        try {
            String string;
            String string2 = string = (String)this.queue.removeLast();
            return string2;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void removeThenAddKey(String string) {
        this.lock.lock();
        try {
            this.queue.removeFirstOccurrence(string);
            this.queue.addFirst(string);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void removeFirstOccurrence(String string) {
        this.lock.lock();
        try {
            this.queue.removeFirstOccurrence(string);
        }
        finally {
            this.lock.unlock();
        }
    }

    public JsonPath getSilent(String string) {
        return (JsonPath)this.map.get(string);
    }

    public void remove(String string) {
        this.removeFirstOccurrence(string);
        this.map.remove(string);
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }
}

