/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.spi.json;

import ia.sh.com.jayway.jsonpath.InvalidJsonException;
import ia.sh.com.jayway.jsonpath.JsonPathException;
import ia.sh.com.jayway.jsonpath.spi.json.AbstractJsonProvider;
import ia.sh.net.minidev.json.JSONArray;
import ia.sh.net.minidev.json.JSONObject;
import ia.sh.net.minidev.json.JSONStyle;
import ia.sh.net.minidev.json.JSONValue;
import ia.sh.net.minidev.json.parser.JSONParser;
import ia.sh.net.minidev.json.parser.ParseException;
import ia.sh.net.minidev.json.writer.JsonReaderI;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;

public class JsonSmartJsonProvider
extends AbstractJsonProvider {
    private final int parseMode;
    private final JsonReaderI mapper;

    public JsonSmartJsonProvider() {
        this(-1, JSONValue.defaultReader.DEFAULT_ORDERED);
    }

    public JsonSmartJsonProvider(int n2) {
        this(n2, JSONValue.defaultReader.DEFAULT_ORDERED);
    }

    public JsonSmartJsonProvider(int n2, JsonReaderI jsonReaderI) {
        this.parseMode = n2;
        this.mapper = jsonReaderI;
    }

    @Override
    public Object createArray() {
        return this.mapper.createArray();
    }

    @Override
    public Object createMap() {
        return this.mapper.createObject();
    }

    @Override
    public Object parse(String string) {
        try {
            return this.createParser().parse(string, this.mapper);
        }
        catch (ParseException parseException) {
            throw new InvalidJsonException(parseException);
        }
    }

    @Override
    public Object parse(InputStream inputStream, String string) {
        try {
            return this.createParser().parse((Reader)new InputStreamReader(inputStream, string), this.mapper);
        }
        catch (ParseException parseException) {
            throw new InvalidJsonException(parseException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JsonPathException(unsupportedEncodingException);
        }
    }

    @Override
    public String toJson(Object object) {
        if (object instanceof Map) {
            return JSONObject.toJSONString((Map)object, JSONStyle.LT_COMPRESS);
        }
        if (object instanceof List) {
            return JSONArray.toJSONString((List)object, JSONStyle.LT_COMPRESS);
        }
        throw new UnsupportedOperationException(object.getClass().getName() + " can not be converted to JSON");
    }

    private JSONParser createParser() {
        return new JSONParser(this.parseMode);
    }
}

